"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var chunk_QILXJUEP_exports = {};
__export(chunk_QILXJUEP_exports, {
  GetConfigError: () => GetConfigError,
  getConfig: () => getConfig,
  getDirectUrl: () => getDirectUrl,
  getEffectiveUrl: () => getEffectiveUrl,
  resolveUrl: () => resolveUrl
});
module.exports = __toCommonJS(chunk_QILXJUEP_exports);
var import_chunk_YRBRUREX = require("./chunk-YRBRUREX.js");
var import_chunk_EKSAMZHR = require("./chunk-EKSAMZHR.js");
var import_chunk_WMIBAVWZ = require("./chunk-WMIBAVWZ.js");
var import_chunk_377DM2ES = require("./chunk-377DM2ES.js");
var import_chunk_SMHAELKS = require("./chunk-SMHAELKS.js");
var import_chunk_H3T4L34H = require("./chunk-H3T4L34H.js");
var import_chunk_XHAV7VB6 = require("./chunk-XHAV7VB6.js");
var import_chunk_A4QWQE3W = require("./chunk-A4QWQE3W.js");
var import_chunk_JM6ICT4D = require("./chunk-JM6ICT4D.js");
var import_chunk_PG5FDKSF = require("./chunk-PG5FDKSF.js");
var import_chunk_WWAWV7DQ = require("./chunk-WWAWV7DQ.js");
var import_debug = __toESM(require("@prisma/debug"));
var import_get_platform = require("@prisma/get-platform");
var import_function = (0, import_chunk_WWAWV7DQ.__toESM)((0, import_chunk_SMHAELKS.require_function)());
var debug = (0, import_debug.default)("prisma:getConfig");
var SCHEMA_VALIDATION_ERROR_CODE = "P1012";
var GetConfigError = class extends Error {
  constructor(params) {
    const constructedErrorMessage = (0, import_chunk_H3T4L34H.$)(params).with({ _tag: "parsed" }, ({ errorCode, message, reason }) => {
      const errorCodeMessage = errorCode ? `Error code: ${errorCode}` : "";
      return `${reason}
${errorCodeMessage}
${message}`;
    }).with({ _tag: "unparsed" }, ({ message, reason }) => {
      const detailsHeader = (0, import_chunk_PG5FDKSF.red)((0, import_chunk_PG5FDKSF.bold)("Details:"));
      return `${reason}
${detailsHeader} ${message}`;
    }).exhaustive();
    const errorMessageWithContext = `${constructedErrorMessage}
[Context: getConfig]`;
    super((0, import_chunk_377DM2ES.addVersionDetailsToErrorMessage)(errorMessageWithContext));
    this.name = "GetConfigError";
  }
};
function getEffectiveUrl(ds) {
  if (ds.directUrl !== void 0) return ds.directUrl;
  return ds.url;
}
function getDirectUrl(ds) {
  return ds.directUrl;
}
function resolveUrl(envValue) {
  const urlFromValue = envValue?.value;
  const urlEnvVarName = envValue?.fromEnvVar;
  const urlEnvVarValue = urlEnvVarName ? process.env[urlEnvVarName] : void 0;
  return urlFromValue ?? urlEnvVarValue;
}
async function getConfig(options) {
  const debugErrorType = (0, import_chunk_EKSAMZHR.createDebugErrorType)(debug, "getConfigWasm");
  debug(`Using getConfig Wasm`);
  const configEither = (0, import_function.pipe)(
    (0, import_chunk_JM6ICT4D.tryCatch)(
      () => {
        if (process.env.FORCE_PANIC_QUERY_ENGINE_GET_CONFIG) {
          debug("Triggering a Rust panic...");
          import_chunk_XHAV7VB6.prismaSchemaWasm.debug_panic();
        }
        const params = JSON.stringify({
          prismaSchema: options.datamodel,
          datasourceOverrides: {},
          ignoreEnvVarErrors: options.ignoreEnvVarErrors ?? false,
          env: process.env
        });
        const data = import_chunk_XHAV7VB6.prismaSchemaWasm.get_config(params);
        return data;
      },
      (e) => ({
        type: "wasm-error",
        reason: "(get-config wasm)",
        error: e
      })
    ),
    (0, import_chunk_JM6ICT4D.map)((result) => ({ result })),
    (0, import_chunk_JM6ICT4D.chainW)(
      ({ result }) => (
        // NOTE: this should never fail, as we expect returned values to be valid JSON-serializable strings
        (0, import_chunk_JM6ICT4D.tryCatch)(
          () => JSON.parse(result),
          (e) => ({
            type: "parse-json",
            reason: "Unable to parse JSON",
            error: e
          })
        )
      )
    ),
    (0, import_chunk_JM6ICT4D.chainW)((response) => {
      if (response.errors.length > 0) {
        return (0, import_chunk_JM6ICT4D.left)({
          type: "validation-error",
          reason: "(get-config wasm)",
          error: response.errors
        });
      }
      return (0, import_chunk_JM6ICT4D.right)(response.config);
    })
  );
  if ((0, import_chunk_JM6ICT4D.isRight)(configEither)) {
    debug("config data retrieved without errors in getConfig Wasm");
    const { right: data } = configEither;
    for (const generator of data.generators) {
      await resolveBinaryTargets(generator);
    }
    return Promise.resolve(data);
  }
  const error = (0, import_chunk_H3T4L34H.$)(configEither.left).with({ type: "wasm-error" }, (e) => {
    debugErrorType(e);
    if ((0, import_chunk_A4QWQE3W.isWasmPanic)(e.error)) {
      const { message, stack } = (0, import_chunk_A4QWQE3W.getWasmError)(e.error);
      const panic = new import_chunk_A4QWQE3W.RustPanic(
        /* message */
        message,
        /* rustStack */
        stack,
        /* request */
        "@prisma/prisma-schema-wasm get_config",
        "FMT_CLI",
        /* schemaPath */
        options.prismaPath,
        /* schema */
        (0, import_chunk_YRBRUREX.toMultipleSchemas)(options.datamodel)
      );
      return panic;
    }
    const errorOutput = e.error.message;
    return new GetConfigError((0, import_chunk_EKSAMZHR.parseQueryEngineError)({ errorOutput, reason: e.reason }));
  }).with({ type: "validation-error" }, (e) => {
    return new GetConfigError({
      _tag: "parsed",
      errorCode: SCHEMA_VALIDATION_ERROR_CODE,
      reason: (0, import_chunk_EKSAMZHR.createSchemaValidationError)(e.reason),
      message: formatErrors(e.error)
    });
  }).otherwise((e) => {
    debugErrorType(e);
    return new GetConfigError({ _tag: "unparsed", message: e.error.message, reason: e.reason });
  });
  throw error;
}
async function resolveBinaryTargets(generator) {
  for (const binaryTarget of generator.binaryTargets) {
    if (binaryTarget.fromEnvVar && process.env[binaryTarget.fromEnvVar]) {
      const value = JSON.parse(process.env[binaryTarget.fromEnvVar]);
      if (Array.isArray(value)) {
        generator.binaryTargets = value.map((v) => ({ fromEnvVar: null, value: v }));
        await resolveBinaryTargets(generator);
      } else {
        binaryTarget.value = value;
      }
    }
    if (binaryTarget.value === "native") {
      binaryTarget.value = await (0, import_get_platform.getBinaryTargetForCurrentPlatform)();
      binaryTarget.native = true;
    }
  }
  if (generator.binaryTargets.length === 0) {
    generator.binaryTargets = [{ fromEnvVar: null, value: await (0, import_get_platform.getBinaryTargetForCurrentPlatform)(), native: true }];
  }
}
function formatErrors(errors) {
  const formattedErrors = errors.map((e) => (0, import_chunk_WMIBAVWZ.relativizePathInPSLError)(e.message)).join("\n\n");
  const errorCount = `Validation Error Count: ${errors.length}`;
  return `${formattedErrors}
${errorCount}`;
}
