"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var chunk_YDZVEVUG_exports = {};
__export(chunk_YDZVEVUG_exports, {
  detect: () => detect,
  getCommand: () => getCommand
});
module.exports = __toCommonJS(chunk_YDZVEVUG_exports);
var import_chunk_WWAWV7DQ = require("./chunk-WWAWV7DQ.js");
var import_fs = __toESM(require("fs"));
var import_path = __toESM(require("path"));
var import_process = __toESM(require("process"));
var import_buffer = require("buffer");
var import_child_process = __toESM(require("child_process"));
var import_child_process2 = __toESM(require("child_process"));
var import_path2 = __toESM(require("path"));
var import_fs2 = __toESM(require("fs"));
var import_url = __toESM(require("url"));
var import_os = __toESM(require("os"));
var import_promises = require("timers/promises");
var import_stream = __toESM(require("stream"));
var import_util = require("util");
var import_os2 = __toESM(require("os"));
var import_tty = __toESM(require("tty"));
var import_readline = __toESM(require("readline"));
var import_events = __toESM(require("events"));
var import_promises2 = __toESM(require("fs/promises"));
function npmRun(agent) {
  return (args) => {
    if (args.length > 1)
      return `${agent} run ${args[0]} -- ${args.slice(1).join(" ")}`;
    else
      return `${agent} run ${args[0]}`;
  };
}
var yarn = {
  "agent": "yarn {0}",
  "run": "yarn run {0}",
  "install": "yarn install {0}",
  "frozen": "yarn install --frozen-lockfile",
  "global": "yarn global add {0}",
  "add": "yarn add {0}",
  "upgrade": "yarn upgrade {0}",
  "upgrade-interactive": "yarn upgrade-interactive {0}",
  "execute": "npx {0}",
  "uninstall": "yarn remove {0}",
  "global_uninstall": "yarn global remove {0}"
};
var pnpm = {
  "agent": "pnpm {0}",
  "run": "pnpm run {0}",
  "install": "pnpm i {0}",
  "frozen": "pnpm i --frozen-lockfile",
  "global": "pnpm add -g {0}",
  "add": "pnpm add {0}",
  "upgrade": "pnpm update {0}",
  "upgrade-interactive": "pnpm update -i {0}",
  "execute": "pnpm dlx {0}",
  "uninstall": "pnpm remove {0}",
  "global_uninstall": "pnpm remove --global {0}"
};
var bun = {
  "agent": "bun {0}",
  "run": "bun run {0}",
  "install": "bun install {0}",
  "frozen": "bun install --no-save",
  "global": "bun add -g {0}",
  "add": "bun add {0}",
  "upgrade": "bun update {0}",
  "upgrade-interactive": "bun update {0}",
  "execute": "bunx {0}",
  "uninstall": "bun remove {0}",
  "global_uninstall": "bun remove -g {0}"
};
var AGENTS = {
  "npm": {
    "agent": "npm {0}",
    "run": npmRun("npm"),
    "install": "npm i {0}",
    "frozen": "npm ci",
    "global": "npm i -g {0}",
    "add": "npm i {0}",
    "upgrade": "npm update {0}",
    "upgrade-interactive": null,
    "execute": "npx {0}",
    "uninstall": "npm uninstall {0}",
    "global_uninstall": "npm uninstall -g {0}"
  },
  "yarn": yarn,
  "yarn@berry": {
    ...yarn,
    "frozen": "yarn install --immutable",
    "upgrade": "yarn up {0}",
    "upgrade-interactive": "yarn up -i {0}",
    "execute": "yarn dlx {0}",
    // Yarn 2+ removed 'global', see https://github.com/yarnpkg/berry/issues/821
    "global": "npm i -g {0}",
    "global_uninstall": "npm uninstall -g {0}"
  },
  "pnpm": pnpm,
  // pnpm v6.x or below
  "pnpm@6": {
    ...pnpm,
    run: npmRun("pnpm")
  },
  "bun": bun
};
var agents = Object.keys(AGENTS);
var LOCKS = {
  "bun.lockb": "bun",
  "pnpm-lock.yaml": "pnpm",
  "yarn.lock": "yarn",
  "package-lock.json": "npm",
  "npm-shrinkwrap.json": "npm"
};
var INSTALL_PAGE = {
  "bun": "https://bun.sh",
  "pnpm": "https://pnpm.io/installation",
  "pnpm@6": "https://pnpm.io/6.x/installation",
  "yarn": "https://classic.yarnpkg.com/en/docs/install",
  "yarn@berry": "https://yarnpkg.com/getting-started/install",
  "npm": "https://docs.npmjs.com/cli/v8/configuring-npm/install"
};
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs(x) {
  return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
}
var { hasOwnProperty } = Object.prototype;
var crossSpawn$1 = { exports: {} };
var windows;
var hasRequiredWindows;
function requireWindows() {
  if (hasRequiredWindows) return windows;
  hasRequiredWindows = 1;
  windows = isexe2;
  isexe2.sync = sync2;
  var fs2 = import_fs2.default;
  function checkPathExt2(path2, options2) {
    var pathext = options2.pathExt !== void 0 ? options2.pathExt : process.env.PATHEXT;
    if (!pathext) {
      return true;
    }
    pathext = pathext.split(";");
    if (pathext.indexOf("") !== -1) {
      return true;
    }
    for (var i = 0; i < pathext.length; i++) {
      var p = pathext[i].toLowerCase();
      if (p && path2.substr(-p.length).toLowerCase() === p) {
        return true;
      }
    }
    return false;
  }
  function checkStat2(stat, path2, options2) {
    if (!stat.isSymbolicLink() && !stat.isFile()) {
      return false;
    }
    return checkPathExt2(path2, options2);
  }
  function isexe2(path2, options2, cb) {
    fs2.stat(path2, function(er, stat) {
      cb(er, er ? false : checkStat2(stat, path2, options2));
    });
  }
  function sync2(path2, options2) {
    return checkStat2(fs2.statSync(path2), path2, options2);
  }
  return windows;
}
var mode;
var hasRequiredMode;
function requireMode() {
  if (hasRequiredMode) return mode;
  hasRequiredMode = 1;
  mode = isexe2;
  isexe2.sync = sync2;
  var fs2 = import_fs2.default;
  function isexe2(path2, options2, cb) {
    fs2.stat(path2, function(er, stat) {
      cb(er, er ? false : checkStat2(stat, options2));
    });
  }
  function sync2(path2, options2) {
    return checkStat2(fs2.statSync(path2), options2);
  }
  function checkStat2(stat, options2) {
    return stat.isFile() && checkMode2(stat, options2);
  }
  function checkMode2(stat, options2) {
    var mod = stat.mode;
    var uid = stat.uid;
    var gid = stat.gid;
    var myUid = options2.uid !== void 0 ? options2.uid : process.getuid && process.getuid();
    var myGid = options2.gid !== void 0 ? options2.gid : process.getgid && process.getgid();
    var u = parseInt("100", 8);
    var g = parseInt("010", 8);
    var o = parseInt("001", 8);
    var ug = u | g;
    var ret = mod & o || mod & g && gid === myGid || mod & u && uid === myUid || mod & ug && myUid === 0;
    return ret;
  }
  return mode;
}
var core;
if (process.platform === "win32" || commonjsGlobal.TESTING_WINDOWS) {
  core = requireWindows();
} else {
  core = requireMode();
}
var isexe_1 = isexe$4;
isexe$4.sync = sync$2;
function isexe$4(path2, options2, cb) {
  if (typeof options2 === "function") {
    cb = options2;
    options2 = {};
  }
  if (!cb) {
    if (typeof Promise !== "function") {
      throw new TypeError("callback not provided");
    }
    return new Promise(function(resolve2, reject) {
      isexe$4(path2, options2 || {}, function(er, is) {
        if (er) {
          reject(er);
        } else {
          resolve2(is);
        }
      });
    });
  }
  core(path2, options2 || {}, function(er, is) {
    if (er) {
      if (er.code === "EACCES" || options2 && options2.ignoreErrors) {
        er = null;
        is = false;
      }
    }
    cb(er, is);
  });
}
function sync$2(path2, options2) {
  try {
    return core.sync(path2, options2 || {});
  } catch (er) {
    if (options2 && options2.ignoreErrors || er.code === "EACCES") {
      return false;
    } else {
      throw er;
    }
  }
}
var isWindows$1 = process.platform === "win32" || process.env.OSTYPE === "cygwin" || process.env.OSTYPE === "msys";
var path$2 = import_path2.default;
var COLON = isWindows$1 ? ";" : ":";
var isexe$3 = isexe_1;
var getNotFoundError$1 = (cmd) => Object.assign(new Error(`not found: ${cmd}`), { code: "ENOENT" });
var getPathInfo$1 = (cmd, opt) => {
  const colon = opt.colon || COLON;
  const pathEnv = cmd.match(/\//) || isWindows$1 && cmd.match(/\\/) ? [""] : [
    // windows always checks the cwd first
    ...isWindows$1 ? [process.cwd()] : [],
    ...(opt.path || process.env.PATH || /* istanbul ignore next: very unusual */
    "").split(colon)
  ];
  const pathExtExe = isWindows$1 ? opt.pathExt || process.env.PATHEXT || ".EXE;.CMD;.BAT;.COM" : "";
  const pathExt = isWindows$1 ? pathExtExe.split(colon) : [""];
  if (isWindows$1) {
    if (cmd.indexOf(".") !== -1 && pathExt[0] !== "")
      pathExt.unshift("");
  }
  return {
    pathEnv,
    pathExt,
    pathExtExe
  };
};
var which$3 = (cmd, opt, cb) => {
  if (typeof opt === "function") {
    cb = opt;
    opt = {};
  }
  if (!opt)
    opt = {};
  const { pathEnv, pathExt, pathExtExe } = getPathInfo$1(cmd, opt);
  const found = [];
  const step = (i) => new Promise((resolve2, reject) => {
    if (i === pathEnv.length)
      return opt.all && found.length ? resolve2(found) : reject(getNotFoundError$1(cmd));
    const ppRaw = pathEnv[i];
    const pathPart = /^".*"$/.test(ppRaw) ? ppRaw.slice(1, -1) : ppRaw;
    const pCmd = path$2.join(pathPart, cmd);
    const p = !pathPart && /^\.[\\\/]/.test(cmd) ? cmd.slice(0, 2) + pCmd : pCmd;
    resolve2(subStep(p, i, 0));
  });
  const subStep = (p, i, ii) => new Promise((resolve2, reject) => {
    if (ii === pathExt.length)
      return resolve2(step(i + 1));
    const ext = pathExt[ii];
    isexe$3(p + ext, { pathExt: pathExtExe }, (er, is) => {
      if (!er && is) {
        if (opt.all)
          found.push(p + ext);
        else
          return resolve2(p + ext);
      }
      return resolve2(subStep(p, i, ii + 1));
    });
  });
  return cb ? step(0).then((res) => cb(null, res), cb) : step(0);
};
var whichSync$1 = (cmd, opt) => {
  opt = opt || {};
  const { pathEnv, pathExt, pathExtExe } = getPathInfo$1(cmd, opt);
  const found = [];
  for (let i = 0; i < pathEnv.length; i++) {
    const ppRaw = pathEnv[i];
    const pathPart = /^".*"$/.test(ppRaw) ? ppRaw.slice(1, -1) : ppRaw;
    const pCmd = path$2.join(pathPart, cmd);
    const p = !pathPart && /^\.[\\\/]/.test(cmd) ? cmd.slice(0, 2) + pCmd : pCmd;
    for (let j = 0; j < pathExt.length; j++) {
      const cur = p + pathExt[j];
      try {
        const is = isexe$3.sync(cur, { pathExt: pathExtExe });
        if (is) {
          if (opt.all)
            found.push(cur);
          else
            return cur;
        }
      } catch (ex) {
      }
    }
  }
  if (opt.all && found.length)
    return found;
  if (opt.nothrow)
    return null;
  throw getNotFoundError$1(cmd);
};
var which_1 = which$3;
which$3.sync = whichSync$1;
var pathKey$2 = { exports: {} };
var pathKey$1 = (options2 = {}) => {
  const environment = options2.env || process.env;
  const platform = options2.platform || process.platform;
  if (platform !== "win32") {
    return "PATH";
  }
  return Object.keys(environment).reverse().find((key) => key.toUpperCase() === "PATH") || "Path";
};
pathKey$2.exports = pathKey$1;
pathKey$2.exports.default = pathKey$1;
var pathKeyExports = pathKey$2.exports;
var path$1 = import_path2.default;
var which$2 = which_1;
var getPathKey = pathKeyExports;
function resolveCommandAttempt(parsed, withoutPathExt) {
  const env2 = parsed.options.env || process.env;
  const cwd = process.cwd();
  const hasCustomCwd = parsed.options.cwd != null;
  const shouldSwitchCwd = hasCustomCwd && process.chdir !== void 0 && !process.chdir.disabled;
  if (shouldSwitchCwd) {
    try {
      process.chdir(parsed.options.cwd);
    } catch (err) {
    }
  }
  let resolved;
  try {
    resolved = which$2.sync(parsed.command, {
      path: env2[getPathKey({ env: env2 })],
      pathExt: withoutPathExt ? path$1.delimiter : void 0
    });
  } catch (e) {
  } finally {
    if (shouldSwitchCwd) {
      process.chdir(cwd);
    }
  }
  if (resolved) {
    resolved = path$1.resolve(hasCustomCwd ? parsed.options.cwd : "", resolved);
  }
  return resolved;
}
function resolveCommand$1(parsed) {
  return resolveCommandAttempt(parsed) || resolveCommandAttempt(parsed, true);
}
var resolveCommand_1 = resolveCommand$1;
var _escape = {};
var metaCharsRegExp = /([()\][%!^"`<>&|;, *?])/g;
function escapeCommand(arg) {
  arg = arg.replace(metaCharsRegExp, "^$1");
  return arg;
}
function escapeArgument(arg, doubleEscapeMetaChars) {
  arg = `${arg}`;
  arg = arg.replace(/(\\*)"/g, '$1$1\\"');
  arg = arg.replace(/(\\*)$/, "$1$1");
  arg = `"${arg}"`;
  arg = arg.replace(metaCharsRegExp, "^$1");
  if (doubleEscapeMetaChars) {
    arg = arg.replace(metaCharsRegExp, "^$1");
  }
  return arg;
}
_escape.command = escapeCommand;
_escape.argument = escapeArgument;
var shebangRegex$1 = /^#!(.*)/;
var shebangRegex = shebangRegex$1;
var shebangCommand$1 = (string = "") => {
  const match = string.match(shebangRegex);
  if (!match) {
    return null;
  }
  const [path2, argument] = match[0].replace(/#! ?/, "").split(" ");
  const binary = path2.split("/").pop();
  if (binary === "env") {
    return argument;
  }
  return argument ? `${binary} ${argument}` : binary;
};
var fs = import_fs2.default;
var shebangCommand = shebangCommand$1;
function readShebang$1(command) {
  const size = 150;
  const buffer = Buffer.alloc(size);
  let fd;
  try {
    fd = fs.openSync(command, "r");
    fs.readSync(fd, buffer, 0, size, 0);
    fs.closeSync(fd);
  } catch (e) {
  }
  return shebangCommand(buffer.toString());
}
var readShebang_1 = readShebang$1;
var path = import_path2.default;
var resolveCommand = resolveCommand_1;
var escape = _escape;
var readShebang = readShebang_1;
var isWin$1 = process.platform === "win32";
var isExecutableRegExp = /\.(?:com|exe)$/i;
var isCmdShimRegExp = /node_modules[\\/].bin[\\/][^\\/]+\.cmd$/i;
function detectShebang(parsed) {
  parsed.file = resolveCommand(parsed);
  const shebang = parsed.file && readShebang(parsed.file);
  if (shebang) {
    parsed.args.unshift(parsed.file);
    parsed.command = shebang;
    return resolveCommand(parsed);
  }
  return parsed.file;
}
function parseNonShell(parsed) {
  if (!isWin$1) {
    return parsed;
  }
  const commandFile = detectShebang(parsed);
  const needsShell = !isExecutableRegExp.test(commandFile);
  if (parsed.options.forceShell || needsShell) {
    const needsDoubleEscapeMetaChars = isCmdShimRegExp.test(commandFile);
    parsed.command = path.normalize(parsed.command);
    parsed.command = escape.command(parsed.command);
    parsed.args = parsed.args.map((arg) => escape.argument(arg, needsDoubleEscapeMetaChars));
    const shellCommand = [parsed.command].concat(parsed.args).join(" ");
    parsed.args = ["/d", "/s", "/c", `"${shellCommand}"`];
    parsed.command = process.env.comspec || "cmd.exe";
    parsed.options.windowsVerbatimArguments = true;
  }
  return parsed;
}
function parse$1(command, args, options2) {
  if (args && !Array.isArray(args)) {
    options2 = args;
    args = null;
  }
  args = args ? args.slice(0) : [];
  options2 = Object.assign({}, options2);
  const parsed = {
    command,
    args,
    options: options2,
    file: void 0,
    original: {
      command,
      args
    }
  };
  return options2.shell ? parsed : parseNonShell(parsed);
}
var parse_1 = parse$1;
var isWin = process.platform === "win32";
function notFoundError(original, syscall) {
  return Object.assign(new Error(`${syscall} ${original.command} ENOENT`), {
    code: "ENOENT",
    errno: "ENOENT",
    syscall: `${syscall} ${original.command}`,
    path: original.command,
    spawnargs: original.args
  });
}
function hookChildProcess(cp2, parsed) {
  if (!isWin) {
    return;
  }
  const originalEmit = cp2.emit;
  cp2.emit = function(name, arg1) {
    if (name === "exit") {
      const err = verifyENOENT(arg1, parsed);
      if (err) {
        return originalEmit.call(cp2, "error", err);
      }
    }
    return originalEmit.apply(cp2, arguments);
  };
}
function verifyENOENT(status, parsed) {
  if (isWin && status === 1 && !parsed.file) {
    return notFoundError(parsed.original, "spawn");
  }
  return null;
}
function verifyENOENTSync(status, parsed) {
  if (isWin && status === 1 && !parsed.file) {
    return notFoundError(parsed.original, "spawnSync");
  }
  return null;
}
var enoent$1 = {
  hookChildProcess,
  verifyENOENT,
  verifyENOENTSync,
  notFoundError
};
var cp = import_child_process2.default;
var parse = parse_1;
var enoent = enoent$1;
function spawn(command, args, options2) {
  const parsed = parse(command, args, options2);
  const spawned = cp.spawn(parsed.command, parsed.args, parsed.options);
  enoent.hookChildProcess(spawned, parsed);
  return spawned;
}
function spawnSync(command, args, options2) {
  const parsed = parse(command, args, options2);
  const result = cp.spawnSync(parsed.command, parsed.args, parsed.options);
  result.error = result.error || enoent.verifyENOENTSync(result.status, parsed);
  return result;
}
crossSpawn$1.exports = spawn;
crossSpawn$1.exports.spawn = spawn;
crossSpawn$1.exports.sync = spawnSync;
crossSpawn$1.exports._parse = parse;
crossSpawn$1.exports._enoent = enoent;
var crossSpawnExports = crossSpawn$1.exports;
var crossSpawn = /* @__PURE__ */ getDefaultExportFromCjs(crossSpawnExports);
function stripFinalNewline(input) {
  const LF = typeof input === "string" ? "\n" : "\n".charCodeAt();
  const CR = typeof input === "string" ? "\r" : "\r".charCodeAt();
  if (input[input.length - 1] === LF) {
    input = input.slice(0, -1);
  }
  if (input[input.length - 1] === CR) {
    input = input.slice(0, -1);
  }
  return input;
}
function pathKey(options2 = {}) {
  const {
    env: env2 = process.env,
    platform = process.platform
  } = options2;
  if (platform !== "win32") {
    return "PATH";
  }
  return Object.keys(env2).reverse().find((key) => key.toUpperCase() === "PATH") || "Path";
}
function npmRunPath(options2 = {}) {
  const {
    cwd = import_process.default.cwd(),
    path: path_ = import_process.default.env[pathKey()],
    execPath = import_process.default.execPath
  } = options2;
  let previous;
  const cwdString = cwd instanceof URL ? import_url.default.fileURLToPath(cwd) : cwd;
  let cwdPath = import_path.default.resolve(cwdString);
  const result = [];
  while (previous !== cwdPath) {
    result.push(import_path.default.join(cwdPath, "node_modules/.bin"));
    previous = cwdPath;
    cwdPath = import_path.default.resolve(cwdPath, "..");
  }
  result.push(import_path.default.resolve(cwdString, execPath, ".."));
  return [...result, path_].join(import_path.default.delimiter);
}
function npmRunPathEnv({ env: env2 = import_process.default.env, ...options2 } = {}) {
  env2 = { ...env2 };
  const path2 = pathKey({ env: env2 });
  options2.path = env2[path2];
  env2[path2] = npmRunPath(options2);
  return env2;
}
var copyProperty = (to, from, property, ignoreNonConfigurable) => {
  if (property === "length" || property === "prototype") {
    return;
  }
  if (property === "arguments" || property === "caller") {
    return;
  }
  const toDescriptor = Object.getOwnPropertyDescriptor(to, property);
  const fromDescriptor = Object.getOwnPropertyDescriptor(from, property);
  if (!canCopyProperty(toDescriptor, fromDescriptor) && ignoreNonConfigurable) {
    return;
  }
  Object.defineProperty(to, property, fromDescriptor);
};
var canCopyProperty = function(toDescriptor, fromDescriptor) {
  return toDescriptor === void 0 || toDescriptor.configurable || toDescriptor.writable === fromDescriptor.writable && toDescriptor.enumerable === fromDescriptor.enumerable && toDescriptor.configurable === fromDescriptor.configurable && (toDescriptor.writable || toDescriptor.value === fromDescriptor.value);
};
var changePrototype = (to, from) => {
  const fromPrototype = Object.getPrototypeOf(from);
  if (fromPrototype === Object.getPrototypeOf(to)) {
    return;
  }
  Object.setPrototypeOf(to, fromPrototype);
};
var wrappedToString = (withName, fromBody) => `/* Wrapped ${withName}*/
${fromBody}`;
var toStringDescriptor = Object.getOwnPropertyDescriptor(Function.prototype, "toString");
var toStringName = Object.getOwnPropertyDescriptor(Function.prototype.toString, "name");
var changeToString = (to, from, name) => {
  const withName = name === "" ? "" : `with ${name.trim()}() `;
  const newToString = wrappedToString.bind(null, withName, from.toString());
  Object.defineProperty(newToString, "name", toStringName);
  Object.defineProperty(to, "toString", { ...toStringDescriptor, value: newToString });
};
function mimicFunction(to, from, { ignoreNonConfigurable = false } = {}) {
  const { name } = to;
  for (const property of Reflect.ownKeys(from)) {
    copyProperty(to, from, property, ignoreNonConfigurable);
  }
  changePrototype(to, from);
  changeToString(to, from, name);
  return to;
}
var calledFunctions = /* @__PURE__ */ new WeakMap();
var onetime = (function_, options2 = {}) => {
  if (typeof function_ !== "function") {
    throw new TypeError("Expected a function");
  }
  let returnValue;
  let callCount = 0;
  const functionName = function_.displayName || function_.name || "<anonymous>";
  const onetime2 = function(...arguments_) {
    calledFunctions.set(onetime2, ++callCount);
    if (callCount === 1) {
      returnValue = function_.apply(this, arguments_);
      function_ = null;
    } else if (options2.throw === true) {
      throw new Error(`Function \`${functionName}\` can only be called once`);
    }
    return returnValue;
  };
  mimicFunction(onetime2, function_);
  calledFunctions.set(onetime2, callCount);
  return onetime2;
};
onetime.callCount = (function_) => {
  if (!calledFunctions.has(function_)) {
    throw new Error(`The given function \`${function_.name}\` is not wrapped by the \`onetime\` package`);
  }
  return calledFunctions.get(function_);
};
var getRealtimeSignals = () => {
  const length = SIGRTMAX - SIGRTMIN + 1;
  return Array.from({ length }, getRealtimeSignal);
};
var getRealtimeSignal = (value, index) => ({
  name: `SIGRT${index + 1}`,
  number: SIGRTMIN + index,
  action: "terminate",
  description: "Application-specific signal (realtime)",
  standard: "posix"
});
var SIGRTMIN = 34;
var SIGRTMAX = 64;
var SIGNALS = [
  {
    name: "SIGHUP",
    number: 1,
    action: "terminate",
    description: "Terminal closed",
    standard: "posix"
  },
  {
    name: "SIGINT",
    number: 2,
    action: "terminate",
    description: "User interruption with CTRL-C",
    standard: "ansi"
  },
  {
    name: "SIGQUIT",
    number: 3,
    action: "core",
    description: "User interruption with CTRL-\\",
    standard: "posix"
  },
  {
    name: "SIGILL",
    number: 4,
    action: "core",
    description: "Invalid machine instruction",
    standard: "ansi"
  },
  {
    name: "SIGTRAP",
    number: 5,
    action: "core",
    description: "Debugger breakpoint",
    standard: "posix"
  },
  {
    name: "SIGABRT",
    number: 6,
    action: "core",
    description: "Aborted",
    standard: "ansi"
  },
  {
    name: "SIGIOT",
    number: 6,
    action: "core",
    description: "Aborted",
    standard: "bsd"
  },
  {
    name: "SIGBUS",
    number: 7,
    action: "core",
    description: "Bus error due to misaligned, non-existing address or paging error",
    standard: "bsd"
  },
  {
    name: "SIGEMT",
    number: 7,
    action: "terminate",
    description: "Command should be emulated but is not implemented",
    standard: "other"
  },
  {
    name: "SIGFPE",
    number: 8,
    action: "core",
    description: "Floating point arithmetic error",
    standard: "ansi"
  },
  {
    name: "SIGKILL",
    number: 9,
    action: "terminate",
    description: "Forced termination",
    standard: "posix",
    forced: true
  },
  {
    name: "SIGUSR1",
    number: 10,
    action: "terminate",
    description: "Application-specific signal",
    standard: "posix"
  },
  {
    name: "SIGSEGV",
    number: 11,
    action: "core",
    description: "Segmentation fault",
    standard: "ansi"
  },
  {
    name: "SIGUSR2",
    number: 12,
    action: "terminate",
    description: "Application-specific signal",
    standard: "posix"
  },
  {
    name: "SIGPIPE",
    number: 13,
    action: "terminate",
    description: "Broken pipe or socket",
    standard: "posix"
  },
  {
    name: "SIGALRM",
    number: 14,
    action: "terminate",
    description: "Timeout or timer",
    standard: "posix"
  },
  {
    name: "SIGTERM",
    number: 15,
    action: "terminate",
    description: "Termination",
    standard: "ansi"
  },
  {
    name: "SIGSTKFLT",
    number: 16,
    action: "terminate",
    description: "Stack is empty or overflowed",
    standard: "other"
  },
  {
    name: "SIGCHLD",
    number: 17,
    action: "ignore",
    description: "Child process terminated, paused or unpaused",
    standard: "posix"
  },
  {
    name: "SIGCLD",
    number: 17,
    action: "ignore",
    description: "Child process terminated, paused or unpaused",
    standard: "other"
  },
  {
    name: "SIGCONT",
    number: 18,
    action: "unpause",
    description: "Unpaused",
    standard: "posix",
    forced: true
  },
  {
    name: "SIGSTOP",
    number: 19,
    action: "pause",
    description: "Paused",
    standard: "posix",
    forced: true
  },
  {
    name: "SIGTSTP",
    number: 20,
    action: "pause",
    description: 'Paused using CTRL-Z or "suspend"',
    standard: "posix"
  },
  {
    name: "SIGTTIN",
    number: 21,
    action: "pause",
    description: "Background process cannot read terminal input",
    standard: "posix"
  },
  {
    name: "SIGBREAK",
    number: 21,
    action: "terminate",
    description: "User interruption with CTRL-BREAK",
    standard: "other"
  },
  {
    name: "SIGTTOU",
    number: 22,
    action: "pause",
    description: "Background process cannot write to terminal output",
    standard: "posix"
  },
  {
    name: "SIGURG",
    number: 23,
    action: "ignore",
    description: "Socket received out-of-band data",
    standard: "bsd"
  },
  {
    name: "SIGXCPU",
    number: 24,
    action: "core",
    description: "Process timed out",
    standard: "bsd"
  },
  {
    name: "SIGXFSZ",
    number: 25,
    action: "core",
    description: "File too big",
    standard: "bsd"
  },
  {
    name: "SIGVTALRM",
    number: 26,
    action: "terminate",
    description: "Timeout or timer",
    standard: "bsd"
  },
  {
    name: "SIGPROF",
    number: 27,
    action: "terminate",
    description: "Timeout or timer",
    standard: "bsd"
  },
  {
    name: "SIGWINCH",
    number: 28,
    action: "ignore",
    description: "Terminal window size changed",
    standard: "bsd"
  },
  {
    name: "SIGIO",
    number: 29,
    action: "terminate",
    description: "I/O is available",
    standard: "other"
  },
  {
    name: "SIGPOLL",
    number: 29,
    action: "terminate",
    description: "Watched event",
    standard: "other"
  },
  {
    name: "SIGINFO",
    number: 29,
    action: "ignore",
    description: "Request for process information",
    standard: "other"
  },
  {
    name: "SIGPWR",
    number: 30,
    action: "terminate",
    description: "Device running out of power",
    standard: "systemv"
  },
  {
    name: "SIGSYS",
    number: 31,
    action: "core",
    description: "Invalid system call",
    standard: "other"
  },
  {
    name: "SIGUNUSED",
    number: 31,
    action: "terminate",
    description: "Invalid system call",
    standard: "other"
  }
];
var getSignals = () => {
  const realtimeSignals = getRealtimeSignals();
  const signals2 = [...SIGNALS, ...realtimeSignals].map(normalizeSignal);
  return signals2;
};
var normalizeSignal = ({
  name,
  number: defaultNumber,
  description,
  action: action2,
  forced = false,
  standard
}) => {
  const {
    signals: { [name]: constantSignal }
  } = import_os.constants;
  const supported = constantSignal !== void 0;
  const number2 = supported ? constantSignal : defaultNumber;
  return { name, number: number2, description, supported, action: action2, forced, standard };
};
var getSignalsByName = () => {
  const signals2 = getSignals();
  return Object.fromEntries(signals2.map(getSignalByName));
};
var getSignalByName = ({
  name,
  number: number2,
  description,
  supported,
  action: action2,
  forced,
  standard
}) => [name, { name, number: number2, description, supported, action: action2, forced, standard }];
var signalsByName = getSignalsByName();
var getSignalsByNumber = () => {
  const signals2 = getSignals();
  const length = SIGRTMAX + 1;
  const signalsA = Array.from(
    { length },
    (value, number2) => getSignalByNumber(number2, signals2)
  );
  return Object.assign({}, ...signalsA);
};
var getSignalByNumber = (number2, signals2) => {
  const signal = findSignalByNumber(number2, signals2);
  if (signal === void 0) {
    return {};
  }
  const { name, description, supported, action: action2, forced, standard } = signal;
  return {
    [number2]: {
      name,
      number: number2,
      description,
      supported,
      action: action2,
      forced,
      standard
    }
  };
};
var findSignalByNumber = (number2, signals2) => {
  const signal = signals2.find(({ name }) => import_os.constants.signals[name] === number2);
  if (signal !== void 0) {
    return signal;
  }
  return signals2.find((signalA) => signalA.number === number2);
};
getSignalsByNumber();
var getErrorPrefix = ({ timedOut, timeout, errorCode, signal, signalDescription, exitCode, isCanceled }) => {
  if (timedOut) {
    return `timed out after ${timeout} milliseconds`;
  }
  if (isCanceled) {
    return "was canceled";
  }
  if (errorCode !== void 0) {
    return `failed with ${errorCode}`;
  }
  if (signal !== void 0) {
    return `was killed with ${signal} (${signalDescription})`;
  }
  if (exitCode !== void 0) {
    return `failed with exit code ${exitCode}`;
  }
  return "failed";
};
var makeError = ({
  stdout,
  stderr,
  all,
  error,
  signal,
  exitCode,
  command,
  escapedCommand,
  timedOut,
  isCanceled,
  killed,
  parsed: { options: { timeout, cwd = import_process.default.cwd() } }
}) => {
  exitCode = exitCode === null ? void 0 : exitCode;
  signal = signal === null ? void 0 : signal;
  const signalDescription = signal === void 0 ? void 0 : signalsByName[signal].description;
  const errorCode = error && error.code;
  const prefix = getErrorPrefix({ timedOut, timeout, errorCode, signal, signalDescription, exitCode, isCanceled });
  const execaMessage = `Command ${prefix}: ${command}`;
  const isError = Object.prototype.toString.call(error) === "[object Error]";
  const shortMessage = isError ? `${execaMessage}
${error.message}` : execaMessage;
  const message = [shortMessage, stderr, stdout].filter(Boolean).join("\n");
  if (isError) {
    error.originalMessage = error.message;
    error.message = message;
  } else {
    error = new Error(message);
  }
  error.shortMessage = shortMessage;
  error.command = command;
  error.escapedCommand = escapedCommand;
  error.exitCode = exitCode;
  error.signal = signal;
  error.signalDescription = signalDescription;
  error.stdout = stdout;
  error.stderr = stderr;
  error.cwd = cwd;
  if (all !== void 0) {
    error.all = all;
  }
  if ("bufferedData" in error) {
    delete error.bufferedData;
  }
  error.failed = true;
  error.timedOut = Boolean(timedOut);
  error.isCanceled = isCanceled;
  error.killed = killed && !timedOut;
  return error;
};
var aliases = ["stdin", "stdout", "stderr"];
var hasAlias = (options2) => aliases.some((alias) => options2[alias] !== void 0);
var normalizeStdio = (options2) => {
  if (!options2) {
    return;
  }
  const { stdio } = options2;
  if (stdio === void 0) {
    return aliases.map((alias) => options2[alias]);
  }
  if (hasAlias(options2)) {
    throw new Error(`It's not possible to provide \`stdio\` in combination with one of ${aliases.map((alias) => `\`${alias}\``).join(", ")}`);
  }
  if (typeof stdio === "string") {
    return stdio;
  }
  if (!Array.isArray(stdio)) {
    throw new TypeError(`Expected \`stdio\` to be of type \`string\` or \`Array\`, got \`${typeof stdio}\``);
  }
  const length = Math.max(stdio.length, aliases.length);
  return Array.from({ length }, (value, index) => stdio[index]);
};
var signals = [];
signals.push("SIGHUP", "SIGINT", "SIGTERM");
if (process.platform !== "win32") {
  signals.push(
    "SIGALRM",
    "SIGABRT",
    "SIGVTALRM",
    "SIGXCPU",
    "SIGXFSZ",
    "SIGUSR2",
    "SIGTRAP",
    "SIGSYS",
    "SIGQUIT",
    "SIGIOT"
    // should detect profiler and enable/disable accordingly.
    // see #21
    // 'SIGPROF'
  );
}
if (process.platform === "linux") {
  signals.push("SIGIO", "SIGPOLL", "SIGPWR", "SIGSTKFLT");
}
var processOk = (process2) => !!process2 && typeof process2 === "object" && typeof process2.removeListener === "function" && typeof process2.emit === "function" && typeof process2.reallyExit === "function" && typeof process2.listeners === "function" && typeof process2.kill === "function" && typeof process2.pid === "number" && typeof process2.on === "function";
var kExitEmitter = Symbol.for("signal-exit emitter");
var global$1 = globalThis;
var ObjectDefineProperty = Object.defineProperty.bind(Object);
var Emitter = class {
  constructor() {
    (0, import_chunk_WWAWV7DQ.__publicField)(this, "emitted", {
      afterExit: false,
      exit: false
    });
    (0, import_chunk_WWAWV7DQ.__publicField)(this, "listeners", {
      afterExit: [],
      exit: []
    });
    (0, import_chunk_WWAWV7DQ.__publicField)(this, "count", 0);
    (0, import_chunk_WWAWV7DQ.__publicField)(this, "id", Math.random());
    if (global$1[kExitEmitter]) {
      return global$1[kExitEmitter];
    }
    ObjectDefineProperty(global$1, kExitEmitter, {
      value: this,
      writable: false,
      enumerable: false,
      configurable: false
    });
  }
  on(ev, fn) {
    this.listeners[ev].push(fn);
  }
  removeListener(ev, fn) {
    const list = this.listeners[ev];
    const i = list.indexOf(fn);
    if (i === -1) {
      return;
    }
    if (i === 0 && list.length === 1) {
      list.length = 0;
    } else {
      list.splice(i, 1);
    }
  }
  emit(ev, code, signal) {
    if (this.emitted[ev]) {
      return false;
    }
    this.emitted[ev] = true;
    let ret = false;
    for (const fn of this.listeners[ev]) {
      ret = fn(code, signal) === true || ret;
    }
    if (ev === "exit") {
      ret = this.emit("afterExit", code, signal) || ret;
    }
    return ret;
  }
};
var SignalExitBase = class {
};
var signalExitWrap = (handler) => {
  return {
    onExit(cb, opts) {
      return handler.onExit(cb, opts);
    },
    load() {
      return handler.load();
    },
    unload() {
      return handler.unload();
    }
  };
};
var SignalExitFallback = class extends SignalExitBase {
  onExit() {
    return () => {
    };
  }
  load() {
  }
  unload() {
  }
};
var _hupSig, _emitter, _process, _originalProcessEmit, _originalProcessReallyExit, _sigListeners, _loaded, _SignalExit_instances, processReallyExit_fn, processEmit_fn;
var SignalExit = class extends SignalExitBase {
  constructor(process2) {
    super();
    (0, import_chunk_WWAWV7DQ.__privateAdd)(this, _SignalExit_instances);
    (0, import_chunk_WWAWV7DQ.__privateAdd)(this, _hupSig, process$1.platform === "win32" ? "SIGINT" : "SIGHUP");
    (0, import_chunk_WWAWV7DQ.__privateAdd)(this, _emitter, new Emitter());
    (0, import_chunk_WWAWV7DQ.__privateAdd)(this, _process);
    (0, import_chunk_WWAWV7DQ.__privateAdd)(this, _originalProcessEmit);
    (0, import_chunk_WWAWV7DQ.__privateAdd)(this, _originalProcessReallyExit);
    (0, import_chunk_WWAWV7DQ.__privateAdd)(this, _sigListeners, {});
    (0, import_chunk_WWAWV7DQ.__privateAdd)(this, _loaded, false);
    (0, import_chunk_WWAWV7DQ.__privateSet)(this, _process, process2);
    (0, import_chunk_WWAWV7DQ.__privateSet)(this, _sigListeners, {});
    for (const sig of signals) {
      (0, import_chunk_WWAWV7DQ.__privateGet)(this, _sigListeners)[sig] = () => {
        const listeners = (0, import_chunk_WWAWV7DQ.__privateGet)(this, _process).listeners(sig);
        let { count } = (0, import_chunk_WWAWV7DQ.__privateGet)(this, _emitter);
        const p = process2;
        if (typeof p.__signal_exit_emitter__ === "object" && typeof p.__signal_exit_emitter__.count === "number") {
          count += p.__signal_exit_emitter__.count;
        }
        if (listeners.length === count) {
          this.unload();
          const ret = (0, import_chunk_WWAWV7DQ.__privateGet)(this, _emitter).emit("exit", null, sig);
          const s = sig === "SIGHUP" ? (0, import_chunk_WWAWV7DQ.__privateGet)(this, _hupSig) : sig;
          if (!ret)
            process2.kill(process2.pid, s);
        }
      };
    }
    (0, import_chunk_WWAWV7DQ.__privateSet)(this, _originalProcessReallyExit, process2.reallyExit);
    (0, import_chunk_WWAWV7DQ.__privateSet)(this, _originalProcessEmit, process2.emit);
  }
  onExit(cb, opts) {
    if (!processOk((0, import_chunk_WWAWV7DQ.__privateGet)(this, _process))) {
      return () => {
      };
    }
    if ((0, import_chunk_WWAWV7DQ.__privateGet)(this, _loaded) === false) {
      this.load();
    }
    const ev = opts?.alwaysLast ? "afterExit" : "exit";
    (0, import_chunk_WWAWV7DQ.__privateGet)(this, _emitter).on(ev, cb);
    return () => {
      (0, import_chunk_WWAWV7DQ.__privateGet)(this, _emitter).removeListener(ev, cb);
      if ((0, import_chunk_WWAWV7DQ.__privateGet)(this, _emitter).listeners["exit"].length === 0 && (0, import_chunk_WWAWV7DQ.__privateGet)(this, _emitter).listeners["afterExit"].length === 0) {
        this.unload();
      }
    };
  }
  load() {
    if ((0, import_chunk_WWAWV7DQ.__privateGet)(this, _loaded)) {
      return;
    }
    (0, import_chunk_WWAWV7DQ.__privateSet)(this, _loaded, true);
    (0, import_chunk_WWAWV7DQ.__privateGet)(this, _emitter).count += 1;
    for (const sig of signals) {
      try {
        const fn = (0, import_chunk_WWAWV7DQ.__privateGet)(this, _sigListeners)[sig];
        if (fn)
          (0, import_chunk_WWAWV7DQ.__privateGet)(this, _process).on(sig, fn);
      } catch (_) {
      }
    }
    (0, import_chunk_WWAWV7DQ.__privateGet)(this, _process).emit = (ev, ...a) => {
      return (0, import_chunk_WWAWV7DQ.__privateMethod)(this, _SignalExit_instances, processEmit_fn).call(this, ev, ...a);
    };
    (0, import_chunk_WWAWV7DQ.__privateGet)(this, _process).reallyExit = (code) => {
      return (0, import_chunk_WWAWV7DQ.__privateMethod)(this, _SignalExit_instances, processReallyExit_fn).call(this, code);
    };
  }
  unload() {
    if (!(0, import_chunk_WWAWV7DQ.__privateGet)(this, _loaded)) {
      return;
    }
    (0, import_chunk_WWAWV7DQ.__privateSet)(this, _loaded, false);
    signals.forEach((sig) => {
      const listener = (0, import_chunk_WWAWV7DQ.__privateGet)(this, _sigListeners)[sig];
      if (!listener) {
        throw new Error("Listener not defined for signal: " + sig);
      }
      try {
        (0, import_chunk_WWAWV7DQ.__privateGet)(this, _process).removeListener(sig, listener);
      } catch (_) {
      }
    });
    (0, import_chunk_WWAWV7DQ.__privateGet)(this, _process).emit = (0, import_chunk_WWAWV7DQ.__privateGet)(this, _originalProcessEmit);
    (0, import_chunk_WWAWV7DQ.__privateGet)(this, _process).reallyExit = (0, import_chunk_WWAWV7DQ.__privateGet)(this, _originalProcessReallyExit);
    (0, import_chunk_WWAWV7DQ.__privateGet)(this, _emitter).count -= 1;
  }
};
_hupSig = /* @__PURE__ */ new WeakMap();
_emitter = /* @__PURE__ */ new WeakMap();
_process = /* @__PURE__ */ new WeakMap();
_originalProcessEmit = /* @__PURE__ */ new WeakMap();
_originalProcessReallyExit = /* @__PURE__ */ new WeakMap();
_sigListeners = /* @__PURE__ */ new WeakMap();
_loaded = /* @__PURE__ */ new WeakMap();
_SignalExit_instances = /* @__PURE__ */ new WeakSet();
processReallyExit_fn = function(code) {
  if (!processOk((0, import_chunk_WWAWV7DQ.__privateGet)(this, _process))) {
    return 0;
  }
  (0, import_chunk_WWAWV7DQ.__privateGet)(this, _process).exitCode = code || 0;
  (0, import_chunk_WWAWV7DQ.__privateGet)(this, _emitter).emit("exit", (0, import_chunk_WWAWV7DQ.__privateGet)(this, _process).exitCode, null);
  return (0, import_chunk_WWAWV7DQ.__privateGet)(this, _originalProcessReallyExit).call((0, import_chunk_WWAWV7DQ.__privateGet)(this, _process), (0, import_chunk_WWAWV7DQ.__privateGet)(this, _process).exitCode);
};
processEmit_fn = function(ev, ...args) {
  const og = (0, import_chunk_WWAWV7DQ.__privateGet)(this, _originalProcessEmit);
  if (ev === "exit" && processOk((0, import_chunk_WWAWV7DQ.__privateGet)(this, _process))) {
    if (typeof args[0] === "number") {
      (0, import_chunk_WWAWV7DQ.__privateGet)(this, _process).exitCode = args[0];
    }
    const ret = og.call((0, import_chunk_WWAWV7DQ.__privateGet)(this, _process), ev, ...args);
    (0, import_chunk_WWAWV7DQ.__privateGet)(this, _emitter).emit("exit", (0, import_chunk_WWAWV7DQ.__privateGet)(this, _process).exitCode, null);
    return ret;
  } else {
    return og.call((0, import_chunk_WWAWV7DQ.__privateGet)(this, _process), ev, ...args);
  }
};
var process$1 = globalThis.process;
var {
  /**
   * Called when the process is exiting, whether via signal, explicit
   * exit, or running out of stuff to do.
   *
   * If the global process object is not suitable for instrumentation,
   * then this will be a no-op.
   *
   * Returns a function that may be used to unload signal-exit.
   */
  onExit,
  /**
   * Load the listeners.  Likely you never need to call this, unless
   * doing a rather deep integration with signal-exit functionality.
   * Mostly exposed for the benefit of testing.
   *
   * @internal
   */
  load,
  /**
   * Unload the listeners.  Likely you never need to call this, unless
   * doing a rather deep integration with signal-exit functionality.
   * Mostly exposed for the benefit of testing.
   *
   * @internal
   */
  unload
} = signalExitWrap(processOk(process$1) ? new SignalExit(process$1) : new SignalExitFallback());
var DEFAULT_FORCE_KILL_TIMEOUT = 1e3 * 5;
var spawnedKill = (kill, signal = "SIGTERM", options2 = {}) => {
  const killResult = kill(signal);
  setKillTimeout(kill, signal, options2, killResult);
  return killResult;
};
var setKillTimeout = (kill, signal, options2, killResult) => {
  if (!shouldForceKill(signal, options2, killResult)) {
    return;
  }
  const timeout = getForceKillAfterTimeout(options2);
  const t = setTimeout(() => {
    kill("SIGKILL");
  }, timeout);
  if (t.unref) {
    t.unref();
  }
};
var shouldForceKill = (signal, { forceKillAfterTimeout }, killResult) => isSigterm(signal) && forceKillAfterTimeout !== false && killResult;
var isSigterm = (signal) => signal === import_os.default.constants.signals.SIGTERM || typeof signal === "string" && signal.toUpperCase() === "SIGTERM";
var getForceKillAfterTimeout = ({ forceKillAfterTimeout = true }) => {
  if (forceKillAfterTimeout === true) {
    return DEFAULT_FORCE_KILL_TIMEOUT;
  }
  if (!Number.isFinite(forceKillAfterTimeout) || forceKillAfterTimeout < 0) {
    throw new TypeError(`Expected the \`forceKillAfterTimeout\` option to be a non-negative integer, got \`${forceKillAfterTimeout}\` (${typeof forceKillAfterTimeout})`);
  }
  return forceKillAfterTimeout;
};
var spawnedCancel = (spawned, context) => {
  const killResult = spawned.kill();
  if (killResult) {
    context.isCanceled = true;
  }
};
var timeoutKill = (spawned, signal, reject) => {
  spawned.kill(signal);
  reject(Object.assign(new Error("Timed out"), { timedOut: true, signal }));
};
var setupTimeout = (spawned, { timeout, killSignal = "SIGTERM" }, spawnedPromise) => {
  if (timeout === 0 || timeout === void 0) {
    return spawnedPromise;
  }
  let timeoutId;
  const timeoutPromise = new Promise((resolve2, reject) => {
    timeoutId = setTimeout(() => {
      timeoutKill(spawned, killSignal, reject);
    }, timeout);
  });
  const safeSpawnedPromise = spawnedPromise.finally(() => {
    clearTimeout(timeoutId);
  });
  return Promise.race([timeoutPromise, safeSpawnedPromise]);
};
var validateTimeout = ({ timeout }) => {
  if (timeout !== void 0 && (!Number.isFinite(timeout) || timeout < 0)) {
    throw new TypeError(`Expected the \`timeout\` option to be a non-negative integer, got \`${timeout}\` (${typeof timeout})`);
  }
};
var setExitHandler = async (spawned, { cleanup, detached }, timedPromise) => {
  if (!cleanup || detached) {
    return timedPromise;
  }
  const removeExitHandler = onExit(() => {
    spawned.kill();
  });
  return timedPromise.finally(() => {
    removeExitHandler();
  });
};
function isStream(stream) {
  return stream !== null && typeof stream === "object" && typeof stream.pipe === "function";
}
function isWritableStream(stream) {
  return isStream(stream) && stream.writable !== false && typeof stream._write === "function" && typeof stream._writableState === "object";
}
var isExecaChildProcess = (target) => target instanceof import_child_process.ChildProcess && typeof target.then === "function";
var pipeToTarget = (spawned, streamName, target) => {
  if (typeof target === "string") {
    spawned[streamName].pipe((0, import_fs.createWriteStream)(target));
    return spawned;
  }
  if (isWritableStream(target)) {
    spawned[streamName].pipe(target);
    return spawned;
  }
  if (!isExecaChildProcess(target)) {
    throw new TypeError("The second argument must be a string, a stream or an Execa child process.");
  }
  if (!isWritableStream(target.stdin)) {
    throw new TypeError("The target child process's stdin must be available.");
  }
  spawned[streamName].pipe(target.stdin);
  return target;
};
var addPipeMethods = (spawned) => {
  if (spawned.stdout !== null) {
    spawned.pipeStdout = pipeToTarget.bind(void 0, spawned, "stdout");
  }
  if (spawned.stderr !== null) {
    spawned.pipeStderr = pipeToTarget.bind(void 0, spawned, "stderr");
  }
  if (spawned.all !== void 0) {
    spawned.pipeAll = pipeToTarget.bind(void 0, spawned, "all");
  }
};
var getStreamContents = async (stream, { init: init2, convertChunk, getSize, truncateChunk, addChunk, getFinalChunk, finalize }, { maxBuffer = Number.POSITIVE_INFINITY } = {}) => {
  if (!isAsyncIterable(stream)) {
    throw new Error("The first argument must be a Readable, a ReadableStream, or an async iterable.");
  }
  const state = init2();
  state.length = 0;
  try {
    for await (const chunk of stream) {
      const chunkType = getChunkType(chunk);
      const convertedChunk = convertChunk[chunkType](chunk, state);
      appendChunk({ convertedChunk, state, getSize, truncateChunk, addChunk, maxBuffer });
    }
    appendFinalChunk({ state, convertChunk, getSize, truncateChunk, addChunk, getFinalChunk, maxBuffer });
    return finalize(state);
  } catch (error) {
    error.bufferedData = finalize(state);
    throw error;
  }
};
var appendFinalChunk = ({ state, getSize, truncateChunk, addChunk, getFinalChunk, maxBuffer }) => {
  const convertedChunk = getFinalChunk(state);
  if (convertedChunk !== void 0) {
    appendChunk({ convertedChunk, state, getSize, truncateChunk, addChunk, maxBuffer });
  }
};
var appendChunk = ({ convertedChunk, state, getSize, truncateChunk, addChunk, maxBuffer }) => {
  const chunkSize = getSize(convertedChunk);
  const newLength = state.length + chunkSize;
  if (newLength <= maxBuffer) {
    addNewChunk(convertedChunk, state, addChunk, newLength);
    return;
  }
  const truncatedChunk = truncateChunk(convertedChunk, maxBuffer - state.length);
  if (truncatedChunk !== void 0) {
    addNewChunk(truncatedChunk, state, addChunk, maxBuffer);
  }
  throw new MaxBufferError();
};
var addNewChunk = (convertedChunk, state, addChunk, newLength) => {
  state.contents = addChunk(convertedChunk, state, newLength);
  state.length = newLength;
};
var isAsyncIterable = (stream) => typeof stream === "object" && stream !== null && typeof stream[Symbol.asyncIterator] === "function";
var getChunkType = (chunk) => {
  const typeOfChunk = typeof chunk;
  if (typeOfChunk === "string") {
    return "string";
  }
  if (typeOfChunk !== "object" || chunk === null) {
    return "others";
  }
  if (globalThis.Buffer?.isBuffer(chunk)) {
    return "buffer";
  }
  const prototypeName = objectToString.call(chunk);
  if (prototypeName === "[object ArrayBuffer]") {
    return "arrayBuffer";
  }
  if (prototypeName === "[object DataView]") {
    return "dataView";
  }
  if (Number.isInteger(chunk.byteLength) && Number.isInteger(chunk.byteOffset) && objectToString.call(chunk.buffer) === "[object ArrayBuffer]") {
    return "typedArray";
  }
  return "others";
};
var { toString: objectToString } = Object.prototype;
var MaxBufferError = class extends Error {
  constructor() {
    super("maxBuffer exceeded");
    (0, import_chunk_WWAWV7DQ.__publicField)(this, "name", "MaxBufferError");
  }
};
var identity = (value) => value;
var noop$1 = () => void 0;
var getContentsProp = ({ contents }) => contents;
var throwObjectStream = (chunk) => {
  throw new Error(`Streams in object mode are not supported: ${String(chunk)}`);
};
var getLengthProp = (convertedChunk) => convertedChunk.length;
async function getStreamAsArrayBuffer(stream, options2) {
  return getStreamContents(stream, arrayBufferMethods, options2);
}
var initArrayBuffer = () => ({ contents: new ArrayBuffer(0) });
var useTextEncoder = (chunk) => textEncoder.encode(chunk);
var textEncoder = new TextEncoder();
var useUint8Array = (chunk) => new Uint8Array(chunk);
var useUint8ArrayWithOffset = (chunk) => new Uint8Array(chunk.buffer, chunk.byteOffset, chunk.byteLength);
var truncateArrayBufferChunk = (convertedChunk, chunkSize) => convertedChunk.slice(0, chunkSize);
var addArrayBufferChunk = (convertedChunk, { contents, length: previousLength }, length) => {
  const newContents = hasArrayBufferResize() ? resizeArrayBuffer(contents, length) : resizeArrayBufferSlow(contents, length);
  new Uint8Array(newContents).set(convertedChunk, previousLength);
  return newContents;
};
var resizeArrayBufferSlow = (contents, length) => {
  if (length <= contents.byteLength) {
    return contents;
  }
  const arrayBuffer = new ArrayBuffer(getNewContentsLength(length));
  new Uint8Array(arrayBuffer).set(new Uint8Array(contents), 0);
  return arrayBuffer;
};
var resizeArrayBuffer = (contents, length) => {
  if (length <= contents.maxByteLength) {
    contents.resize(length);
    return contents;
  }
  const arrayBuffer = new ArrayBuffer(length, { maxByteLength: getNewContentsLength(length) });
  new Uint8Array(arrayBuffer).set(new Uint8Array(contents), 0);
  return arrayBuffer;
};
var getNewContentsLength = (length) => SCALE_FACTOR ** Math.ceil(Math.log(length) / Math.log(SCALE_FACTOR));
var SCALE_FACTOR = 2;
var finalizeArrayBuffer = ({ contents, length }) => hasArrayBufferResize() ? contents : contents.slice(0, length);
var hasArrayBufferResize = () => "resize" in ArrayBuffer.prototype;
var arrayBufferMethods = {
  init: initArrayBuffer,
  convertChunk: {
    string: useTextEncoder,
    buffer: useUint8Array,
    arrayBuffer: useUint8Array,
    dataView: useUint8ArrayWithOffset,
    typedArray: useUint8ArrayWithOffset,
    others: throwObjectStream
  },
  getSize: getLengthProp,
  truncateChunk: truncateArrayBufferChunk,
  addChunk: addArrayBufferChunk,
  getFinalChunk: noop$1,
  finalize: finalizeArrayBuffer
};
async function getStreamAsBuffer(stream, options2) {
  if (!("Buffer" in globalThis)) {
    throw new Error("getStreamAsBuffer() is only supported in Node.js");
  }
  try {
    return arrayBufferToNodeBuffer(await getStreamAsArrayBuffer(stream, options2));
  } catch (error) {
    if (error.bufferedData !== void 0) {
      error.bufferedData = arrayBufferToNodeBuffer(error.bufferedData);
    }
    throw error;
  }
}
var arrayBufferToNodeBuffer = (arrayBuffer) => globalThis.Buffer.from(arrayBuffer);
async function getStreamAsString(stream, options2) {
  return getStreamContents(stream, stringMethods, options2);
}
var initString = () => ({ contents: "", textDecoder: new TextDecoder() });
var useTextDecoder = (chunk, { textDecoder }) => textDecoder.decode(chunk, { stream: true });
var addStringChunk = (convertedChunk, { contents }) => contents + convertedChunk;
var truncateStringChunk = (convertedChunk, chunkSize) => convertedChunk.slice(0, chunkSize);
var getFinalStringChunk = ({ textDecoder }) => {
  const finalChunk = textDecoder.decode();
  return finalChunk === "" ? void 0 : finalChunk;
};
var stringMethods = {
  init: initString,
  convertChunk: {
    string: identity,
    buffer: useTextDecoder,
    arrayBuffer: useTextDecoder,
    dataView: useTextDecoder,
    typedArray: useTextDecoder,
    others: throwObjectStream
  },
  getSize: getLengthProp,
  truncateChunk: truncateStringChunk,
  addChunk: addStringChunk,
  getFinalChunk: getFinalStringChunk,
  finalize: getContentsProp
};
var { PassThrough } = import_stream.default;
var mergeStream = function() {
  var sources = [];
  var output = new PassThrough({ objectMode: true });
  output.setMaxListeners(0);
  output.add = add;
  output.isEmpty = isEmpty;
  output.on("unpipe", remove2);
  Array.prototype.slice.call(arguments).forEach(add);
  return output;
  function add(source) {
    if (Array.isArray(source)) {
      source.forEach(add);
      return this;
    }
    sources.push(source);
    source.once("end", remove2.bind(null, source));
    source.once("error", output.emit.bind(output, "error"));
    source.pipe(output, { end: false });
    return this;
  }
  function isEmpty() {
    return sources.length == 0;
  }
  function remove2(source) {
    sources = sources.filter(function(it) {
      return it !== source;
    });
    if (!sources.length && output.readable) {
      output.end();
    }
  }
};
var mergeStream$1 = /* @__PURE__ */ getDefaultExportFromCjs(mergeStream);
var validateInputOptions = (input) => {
  if (input !== void 0) {
    throw new TypeError("The `input` and `inputFile` options cannot be both set.");
  }
};
var getInput = ({ input, inputFile }) => {
  if (typeof inputFile !== "string") {
    return input;
  }
  validateInputOptions(input);
  return (0, import_fs.createReadStream)(inputFile);
};
var handleInput = (spawned, options2) => {
  const input = getInput(options2);
  if (input === void 0) {
    return;
  }
  if (isStream(input)) {
    input.pipe(spawned.stdin);
  } else {
    spawned.stdin.end(input);
  }
};
var makeAllStream = (spawned, { all }) => {
  if (!all || !spawned.stdout && !spawned.stderr) {
    return;
  }
  const mixed = mergeStream$1();
  if (spawned.stdout) {
    mixed.add(spawned.stdout);
  }
  if (spawned.stderr) {
    mixed.add(spawned.stderr);
  }
  return mixed;
};
var getBufferedData = async (stream, streamPromise) => {
  if (!stream || streamPromise === void 0) {
    return;
  }
  await (0, import_promises.setTimeout)(0);
  stream.destroy();
  try {
    return await streamPromise;
  } catch (error) {
    return error.bufferedData;
  }
};
var getStreamPromise = (stream, { encoding, buffer, maxBuffer }) => {
  if (!stream || !buffer) {
    return;
  }
  if (encoding === "utf8" || encoding === "utf-8") {
    return getStreamAsString(stream, { maxBuffer });
  }
  if (encoding === null || encoding === "buffer") {
    return getStreamAsBuffer(stream, { maxBuffer });
  }
  return applyEncoding(stream, maxBuffer, encoding);
};
var applyEncoding = async (stream, maxBuffer, encoding) => {
  const buffer = await getStreamAsBuffer(stream, { maxBuffer });
  return buffer.toString(encoding);
};
var getSpawnedResult = async ({ stdout, stderr, all }, { encoding, buffer, maxBuffer }, processDone) => {
  const stdoutPromise = getStreamPromise(stdout, { encoding, buffer, maxBuffer });
  const stderrPromise = getStreamPromise(stderr, { encoding, buffer, maxBuffer });
  const allPromise = getStreamPromise(all, { encoding, buffer, maxBuffer: maxBuffer * 2 });
  try {
    return await Promise.all([processDone, stdoutPromise, stderrPromise, allPromise]);
  } catch (error) {
    return Promise.all([
      { error, signal: error.signal, timedOut: error.timedOut },
      getBufferedData(stdout, stdoutPromise),
      getBufferedData(stderr, stderrPromise),
      getBufferedData(all, allPromise)
    ]);
  }
};
var nativePromisePrototype = (async () => {
})().constructor.prototype;
var descriptors = ["then", "catch", "finally"].map((property) => [
  property,
  Reflect.getOwnPropertyDescriptor(nativePromisePrototype, property)
]);
var mergePromise = (spawned, promise) => {
  for (const [property, descriptor] of descriptors) {
    const value = typeof promise === "function" ? (...args) => Reflect.apply(descriptor.value, promise(), args) : descriptor.value.bind(promise);
    Reflect.defineProperty(spawned, property, { ...descriptor, value });
  }
};
var getSpawnedPromise = (spawned) => new Promise((resolve2, reject) => {
  spawned.on("exit", (exitCode, signal) => {
    resolve2({ exitCode, signal });
  });
  spawned.on("error", (error) => {
    reject(error);
  });
  if (spawned.stdin) {
    spawned.stdin.on("error", (error) => {
      reject(error);
    });
  }
});
var normalizeArgs = (file, args = []) => {
  if (!Array.isArray(args)) {
    return [file];
  }
  return [file, ...args];
};
var NO_ESCAPE_REGEXP = /^[\w.-]+$/;
var escapeArg = (arg) => {
  if (typeof arg !== "string" || NO_ESCAPE_REGEXP.test(arg)) {
    return arg;
  }
  return `"${arg.replaceAll('"', '\\"')}"`;
};
var joinCommand = (file, args) => normalizeArgs(file, args).join(" ");
var getEscapedCommand = (file, args) => normalizeArgs(file, args).map((arg) => escapeArg(arg)).join(" ");
var SPACES_REGEXP = / +/g;
var parseCommand = (command) => {
  const tokens = [];
  for (const token of command.trim().split(SPACES_REGEXP)) {
    const previousToken = tokens.at(-1);
    if (previousToken && previousToken.endsWith("\\")) {
      tokens[tokens.length - 1] = `${previousToken.slice(0, -1)} ${token}`;
    } else {
      tokens.push(token);
    }
  }
  return tokens;
};
var verboseDefault = (0, import_util.debuglog)("execa").enabled;
var padField = (field, padding) => String(field).padStart(padding, "0");
var getTimestamp = () => {
  const date2 = /* @__PURE__ */ new Date();
  return `${padField(date2.getHours(), 2)}:${padField(date2.getMinutes(), 2)}:${padField(date2.getSeconds(), 2)}.${padField(date2.getMilliseconds(), 3)}`;
};
var logCommand = (escapedCommand, { verbose }) => {
  if (!verbose) {
    return;
  }
  import_process.default.stderr.write(`[${getTimestamp()}] ${escapedCommand}
`);
};
var DEFAULT_MAX_BUFFER = 1e3 * 1e3 * 100;
var getEnv = ({ env: envOption, extendEnv, preferLocal, localDir, execPath }) => {
  const env2 = extendEnv ? { ...import_process.default.env, ...envOption } : envOption;
  if (preferLocal) {
    return npmRunPathEnv({ env: env2, cwd: localDir, execPath });
  }
  return env2;
};
var handleArguments = (file, args, options2 = {}) => {
  const parsed = crossSpawn._parse(file, args, options2);
  file = parsed.command;
  args = parsed.args;
  options2 = parsed.options;
  options2 = {
    maxBuffer: DEFAULT_MAX_BUFFER,
    buffer: true,
    stripFinalNewline: true,
    extendEnv: true,
    preferLocal: false,
    localDir: options2.cwd || import_process.default.cwd(),
    execPath: import_process.default.execPath,
    encoding: "utf8",
    reject: true,
    cleanup: true,
    all: false,
    windowsHide: true,
    verbose: verboseDefault,
    ...options2
  };
  options2.env = getEnv(options2);
  options2.stdio = normalizeStdio(options2);
  if (import_process.default.platform === "win32" && import_path.default.basename(file, ".exe") === "cmd") {
    args.unshift("/q");
  }
  return { file, args, options: options2, parsed };
};
var handleOutput = (options2, value, error) => {
  if (typeof value !== "string" && !import_buffer.Buffer.isBuffer(value)) {
    return error === void 0 ? void 0 : "";
  }
  if (options2.stripFinalNewline) {
    return stripFinalNewline(value);
  }
  return value;
};
function execa(file, args, options2) {
  const parsed = handleArguments(file, args, options2);
  const command = joinCommand(file, args);
  const escapedCommand = getEscapedCommand(file, args);
  logCommand(escapedCommand, parsed.options);
  validateTimeout(parsed.options);
  let spawned;
  try {
    spawned = import_child_process.default.spawn(parsed.file, parsed.args, parsed.options);
  } catch (error) {
    const dummySpawned = new import_child_process.default.ChildProcess();
    const errorPromise = Promise.reject(makeError({
      error,
      stdout: "",
      stderr: "",
      all: "",
      command,
      escapedCommand,
      parsed,
      timedOut: false,
      isCanceled: false,
      killed: false
    }));
    mergePromise(dummySpawned, errorPromise);
    return dummySpawned;
  }
  const spawnedPromise = getSpawnedPromise(spawned);
  const timedPromise = setupTimeout(spawned, parsed.options, spawnedPromise);
  const processDone = setExitHandler(spawned, parsed.options, timedPromise);
  const context = { isCanceled: false };
  spawned.kill = spawnedKill.bind(null, spawned.kill.bind(spawned));
  spawned.cancel = spawnedCancel.bind(null, spawned, context);
  const handlePromise = async () => {
    const [{ error, exitCode, signal, timedOut }, stdoutResult, stderrResult, allResult] = await getSpawnedResult(spawned, parsed.options, processDone);
    const stdout = handleOutput(parsed.options, stdoutResult);
    const stderr = handleOutput(parsed.options, stderrResult);
    const all = handleOutput(parsed.options, allResult);
    if (error || exitCode !== 0 || signal !== null) {
      const returnedError = makeError({
        error,
        exitCode,
        signal,
        stdout,
        stderr,
        all,
        command,
        escapedCommand,
        parsed,
        timedOut,
        isCanceled: parsed.options.signal ? parsed.options.signal.aborted : false,
        killed: spawned.killed
      });
      if (!parsed.options.reject) {
        return returnedError;
      }
      throw returnedError;
    }
    return {
      command,
      escapedCommand,
      exitCode: 0,
      stdout,
      stderr,
      all,
      failed: false,
      timedOut: false,
      isCanceled: false,
      killed: false
    };
  };
  const handlePromiseOnce = onetime(handlePromise);
  handleInput(spawned, parsed.options);
  spawned.all = makeAllStream(spawned, parsed.options);
  addPipeMethods(spawned);
  mergePromise(spawned, handlePromiseOnce);
  return spawned;
}
function execaCommand(command, options2) {
  const [file, ...args] = parseCommand(command);
  return execa(file, args, options2);
}
var Node = class {
  constructor(value) {
    (0, import_chunk_WWAWV7DQ.__publicField)(this, "value");
    (0, import_chunk_WWAWV7DQ.__publicField)(this, "next");
    this.value = value;
  }
};
var _head, _tail, _size;
var Queue = class {
  constructor() {
    (0, import_chunk_WWAWV7DQ.__privateAdd)(this, _head);
    (0, import_chunk_WWAWV7DQ.__privateAdd)(this, _tail);
    (0, import_chunk_WWAWV7DQ.__privateAdd)(this, _size);
    this.clear();
  }
  enqueue(value) {
    const node = new Node(value);
    if ((0, import_chunk_WWAWV7DQ.__privateGet)(this, _head)) {
      (0, import_chunk_WWAWV7DQ.__privateGet)(this, _tail).next = node;
      (0, import_chunk_WWAWV7DQ.__privateSet)(this, _tail, node);
    } else {
      (0, import_chunk_WWAWV7DQ.__privateSet)(this, _head, node);
      (0, import_chunk_WWAWV7DQ.__privateSet)(this, _tail, node);
    }
    (0, import_chunk_WWAWV7DQ.__privateWrapper)(this, _size)._++;
  }
  dequeue() {
    const current = (0, import_chunk_WWAWV7DQ.__privateGet)(this, _head);
    if (!current) {
      return;
    }
    (0, import_chunk_WWAWV7DQ.__privateSet)(this, _head, (0, import_chunk_WWAWV7DQ.__privateGet)(this, _head).next);
    (0, import_chunk_WWAWV7DQ.__privateWrapper)(this, _size)._--;
    return current.value;
  }
  clear() {
    (0, import_chunk_WWAWV7DQ.__privateSet)(this, _head, void 0);
    (0, import_chunk_WWAWV7DQ.__privateSet)(this, _tail, void 0);
    (0, import_chunk_WWAWV7DQ.__privateSet)(this, _size, 0);
  }
  get size() {
    return (0, import_chunk_WWAWV7DQ.__privateGet)(this, _size);
  }
  *[Symbol.iterator]() {
    let current = (0, import_chunk_WWAWV7DQ.__privateGet)(this, _head);
    while (current) {
      yield current.value;
      current = current.next;
    }
  }
};
_head = /* @__PURE__ */ new WeakMap();
_tail = /* @__PURE__ */ new WeakMap();
_size = /* @__PURE__ */ new WeakMap();
function pLimit(concurrency) {
  if (!((Number.isInteger(concurrency) || concurrency === Number.POSITIVE_INFINITY) && concurrency > 0)) {
    throw new TypeError("Expected `concurrency` to be a number from 1 and up");
  }
  const queue = new Queue();
  let activeCount = 0;
  const next = () => {
    activeCount--;
    if (queue.size > 0) {
      queue.dequeue()();
    }
  };
  const run2 = async (fn, resolve2, args) => {
    activeCount++;
    const result = (async () => fn(...args))();
    resolve2(result);
    try {
      await result;
    } catch {
    }
    next();
  };
  const enqueue = (fn, resolve2, args) => {
    queue.enqueue(run2.bind(void 0, fn, resolve2, args));
    (async () => {
      await Promise.resolve();
      if (activeCount < concurrency && queue.size > 0) {
        queue.dequeue()();
      }
    })();
  };
  const generator = (fn, ...args) => new Promise((resolve2) => {
    enqueue(fn, resolve2, args);
  });
  Object.defineProperties(generator, {
    activeCount: {
      get: () => activeCount
    },
    pendingCount: {
      get: () => queue.size
    },
    clearQueue: {
      value: () => {
        queue.clear();
      }
    }
  });
  return generator;
}
var EndError = class extends Error {
  constructor(value) {
    super();
    this.value = value;
  }
};
var testElement = async (element, tester) => tester(await element);
var finder = async (element) => {
  const values = await Promise.all(element);
  if (values[1] === true) {
    throw new EndError(values[0]);
  }
  return false;
};
async function pLocate(iterable, tester, {
  concurrency = Number.POSITIVE_INFINITY,
  preserveOrder = true
} = {}) {
  const limit = pLimit(concurrency);
  const items = [...iterable].map((element) => [element, limit(testElement, element, tester)]);
  const checkLimit = pLimit(preserveOrder ? 1 : Number.POSITIVE_INFINITY);
  try {
    await Promise.all(items.map((element) => checkLimit(finder, element)));
  } catch (error) {
    if (error instanceof EndError) {
      return error.value;
    }
    throw error;
  }
}
var typeMappings = {
  directory: "isDirectory",
  file: "isFile"
};
function checkType(type) {
  if (Object.hasOwnProperty.call(typeMappings, type)) {
    return;
  }
  throw new Error(`Invalid type specified: ${type}`);
}
var matchType = (type, stat) => stat[typeMappings[type]]();
var toPath$1 = (urlOrPath) => urlOrPath instanceof URL ? (0, import_url.fileURLToPath)(urlOrPath) : urlOrPath;
async function locatePath(paths, {
  cwd = import_process.default.cwd(),
  type = "file",
  allowSymlinks = true,
  concurrency,
  preserveOrder
} = {}) {
  checkType(type);
  cwd = toPath$1(cwd);
  const statFunction = allowSymlinks ? import_fs.promises.stat : import_fs.promises.lstat;
  return pLocate(paths, async (path_) => {
    try {
      const stat = await statFunction(import_path.default.resolve(cwd, path_));
      return matchType(type, stat);
    } catch {
      return false;
    }
  }, { concurrency, preserveOrder });
}
var toPath = (urlOrPath) => urlOrPath instanceof URL ? (0, import_url.fileURLToPath)(urlOrPath) : urlOrPath;
var findUpStop = Symbol("findUpStop");
async function findUpMultiple(name, options2 = {}) {
  let directory = import_path.default.resolve(toPath(options2.cwd) || "");
  const { root } = import_path.default.parse(directory);
  const stopAt = import_path.default.resolve(directory, options2.stopAt || root);
  const limit = options2.limit || Number.POSITIVE_INFINITY;
  const paths = [name].flat();
  const runMatcher = async (locateOptions) => {
    if (typeof name !== "function") {
      return locatePath(paths, locateOptions);
    }
    const foundPath = await name(locateOptions.cwd);
    if (typeof foundPath === "string") {
      return locatePath([foundPath], locateOptions);
    }
    return foundPath;
  };
  const matches = [];
  while (true) {
    const foundPath = await runMatcher({ ...options2, cwd: directory });
    if (foundPath === findUpStop) {
      break;
    }
    if (foundPath) {
      matches.push(import_path.default.resolve(directory, foundPath));
    }
    if (directory === stopAt || matches.length >= limit) {
      break;
    }
    directory = import_path.default.dirname(directory);
  }
  return matches;
}
async function findUp(name, options2 = {}) {
  const matches = await findUpMultiple(name, { ...options2, limit: 1 });
  return matches[0];
}
var ESC$1 = "\x1B[";
var OSC = "\x1B]";
var BEL = "\x07";
var SEP = ";";
var isTerminalApp = process.env.TERM_PROGRAM === "Apple_Terminal";
var ansiEscapes = {};
ansiEscapes.cursorTo = (x, y) => {
  if (typeof x !== "number") {
    throw new TypeError("The `x` argument is required");
  }
  if (typeof y !== "number") {
    return ESC$1 + (x + 1) + "G";
  }
  return ESC$1 + (y + 1) + ";" + (x + 1) + "H";
};
ansiEscapes.cursorMove = (x, y) => {
  if (typeof x !== "number") {
    throw new TypeError("The `x` argument is required");
  }
  let returnValue = "";
  if (x < 0) {
    returnValue += ESC$1 + -x + "D";
  } else if (x > 0) {
    returnValue += ESC$1 + x + "C";
  }
  if (y < 0) {
    returnValue += ESC$1 + -y + "A";
  } else if (y > 0) {
    returnValue += ESC$1 + y + "B";
  }
  return returnValue;
};
ansiEscapes.cursorUp = (count = 1) => ESC$1 + count + "A";
ansiEscapes.cursorDown = (count = 1) => ESC$1 + count + "B";
ansiEscapes.cursorForward = (count = 1) => ESC$1 + count + "C";
ansiEscapes.cursorBackward = (count = 1) => ESC$1 + count + "D";
ansiEscapes.cursorLeft = ESC$1 + "G";
ansiEscapes.cursorSavePosition = isTerminalApp ? "\x1B7" : ESC$1 + "s";
ansiEscapes.cursorRestorePosition = isTerminalApp ? "\x1B8" : ESC$1 + "u";
ansiEscapes.cursorGetPosition = ESC$1 + "6n";
ansiEscapes.cursorNextLine = ESC$1 + "E";
ansiEscapes.cursorPrevLine = ESC$1 + "F";
ansiEscapes.cursorHide = ESC$1 + "?25l";
ansiEscapes.cursorShow = ESC$1 + "?25h";
ansiEscapes.eraseLines = (count) => {
  let clear2 = "";
  for (let i = 0; i < count; i++) {
    clear2 += ansiEscapes.eraseLine + (i < count - 1 ? ansiEscapes.cursorUp() : "");
  }
  if (count) {
    clear2 += ansiEscapes.cursorLeft;
  }
  return clear2;
};
ansiEscapes.eraseEndLine = ESC$1 + "K";
ansiEscapes.eraseStartLine = ESC$1 + "1K";
ansiEscapes.eraseLine = ESC$1 + "2K";
ansiEscapes.eraseDown = ESC$1 + "J";
ansiEscapes.eraseUp = ESC$1 + "1J";
ansiEscapes.eraseScreen = ESC$1 + "2J";
ansiEscapes.scrollUp = ESC$1 + "S";
ansiEscapes.scrollDown = ESC$1 + "T";
ansiEscapes.clearScreen = "\x1Bc";
ansiEscapes.clearTerminal = process.platform === "win32" ? `${ansiEscapes.eraseScreen}${ESC$1}0f` : (
  // 1. Erases the screen (Only done in case `2` is not supported)
  // 2. Erases the whole screen including scrollback buffer
  // 3. Moves cursor to the top-left position
  // More info: https://www.real-world-systems.com/docs/ANSIcode.html
  `${ansiEscapes.eraseScreen}${ESC$1}3J${ESC$1}H`
);
ansiEscapes.beep = BEL;
ansiEscapes.link = (text2, url2) => {
  return [
    OSC,
    "8",
    SEP,
    SEP,
    url2,
    BEL,
    text2,
    OSC,
    "8",
    SEP,
    SEP,
    BEL
  ].join("");
};
ansiEscapes.image = (buffer, options2 = {}) => {
  let returnValue = `${OSC}1337;File=inline=1`;
  if (options2.width) {
    returnValue += `;width=${options2.width}`;
  }
  if (options2.height) {
    returnValue += `;height=${options2.height}`;
  }
  if (options2.preserveAspectRatio === false) {
    returnValue += ";preserveAspectRatio=0";
  }
  return returnValue + ":" + buffer.toString("base64") + BEL;
};
ansiEscapes.iTerm = {
  setCwd: (cwd = process.cwd()) => `${OSC}50;CurrentDir=${cwd}${BEL}`,
  annotation: (message, options2 = {}) => {
    let returnValue = `${OSC}1337;`;
    const hasX = typeof options2.x !== "undefined";
    const hasY = typeof options2.y !== "undefined";
    if ((hasX || hasY) && !(hasX && hasY && typeof options2.length !== "undefined")) {
      throw new Error("`x`, `y` and `length` must be defined when `x` or `y` is defined");
    }
    message = message.replace(/\|/g, "");
    returnValue += options2.isHidden ? "AddHiddenAnnotation=" : "AddAnnotation=";
    if (options2.length > 0) {
      returnValue += (hasX ? [message, options2.length, options2.x, options2.y] : [options2.length, message]).join("|");
    } else {
      returnValue += message;
    }
    return returnValue + BEL;
  }
};
var hasFlag$2 = (flag, argv = process.argv) => {
  const prefix = flag.startsWith("-") ? "" : flag.length === 1 ? "-" : "--";
  const position = argv.indexOf(prefix + flag);
  const terminatorPosition = argv.indexOf("--");
  return position !== -1 && (terminatorPosition === -1 || position < terminatorPosition);
};
var os = import_os2.default;
var tty = import_tty.default;
var hasFlag$1 = hasFlag$2;
var { env } = process;
var forceColor;
if (hasFlag$1("no-color") || hasFlag$1("no-colors") || hasFlag$1("color=false") || hasFlag$1("color=never")) {
  forceColor = 0;
} else if (hasFlag$1("color") || hasFlag$1("colors") || hasFlag$1("color=true") || hasFlag$1("color=always")) {
  forceColor = 1;
}
if ("FORCE_COLOR" in env) {
  if (env.FORCE_COLOR === "true") {
    forceColor = 1;
  } else if (env.FORCE_COLOR === "false") {
    forceColor = 0;
  } else {
    forceColor = env.FORCE_COLOR.length === 0 ? 1 : Math.min(parseInt(env.FORCE_COLOR, 10), 3);
  }
}
function translateLevel(level) {
  if (level === 0) {
    return false;
  }
  return {
    level,
    hasBasic: true,
    has256: level >= 2,
    has16m: level >= 3
  };
}
function supportsColor$1(haveStream, streamIsTTY) {
  if (forceColor === 0) {
    return 0;
  }
  if (hasFlag$1("color=16m") || hasFlag$1("color=full") || hasFlag$1("color=truecolor")) {
    return 3;
  }
  if (hasFlag$1("color=256")) {
    return 2;
  }
  if (haveStream && !streamIsTTY && forceColor === void 0) {
    return 0;
  }
  const min = forceColor || 0;
  if (env.TERM === "dumb") {
    return min;
  }
  if (process.platform === "win32") {
    const osRelease = os.release().split(".");
    if (Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
      return Number(osRelease[2]) >= 14931 ? 3 : 2;
    }
    return 1;
  }
  if ("CI" in env) {
    if (["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI", "GITHUB_ACTIONS", "BUILDKITE"].some((sign) => sign in env) || env.CI_NAME === "codeship") {
      return 1;
    }
    return min;
  }
  if ("TEAMCITY_VERSION" in env) {
    return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
  }
  if (env.COLORTERM === "truecolor") {
    return 3;
  }
  if ("TERM_PROGRAM" in env) {
    const version = parseInt((env.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
    switch (env.TERM_PROGRAM) {
      case "iTerm.app":
        return version >= 3 ? 3 : 2;
      case "Apple_Terminal":
        return 2;
    }
  }
  if (/-256(color)?$/i.test(env.TERM)) {
    return 2;
  }
  if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
    return 1;
  }
  if ("COLORTERM" in env) {
    return 1;
  }
  return min;
}
function getSupportLevel(stream) {
  const level = supportsColor$1(stream, stream && stream.isTTY);
  return translateLevel(level);
}
var supportsColor_1 = {
  supportsColor: getSupportLevel,
  stdout: translateLevel(supportsColor$1(true, tty.isatty(1))),
  stderr: translateLevel(supportsColor$1(true, tty.isatty(2)))
};
var supportsColor = supportsColor_1;
var hasFlag = hasFlag$2;
function parseVersion(versionString) {
  if (/^\d{3,4}$/.test(versionString)) {
    const m = /(\d{1,2})(\d{2})/.exec(versionString);
    return {
      major: 0,
      minor: parseInt(m[1], 10),
      patch: parseInt(m[2], 10)
    };
  }
  const versions = (versionString || "").split(".").map((n) => parseInt(n, 10));
  return {
    major: versions[0],
    minor: versions[1],
    patch: versions[2]
  };
}
function supportsHyperlink(stream) {
  const { env: env2 } = process;
  if ("FORCE_HYPERLINK" in env2) {
    return !(env2.FORCE_HYPERLINK.length > 0 && parseInt(env2.FORCE_HYPERLINK, 10) === 0);
  }
  if (hasFlag("no-hyperlink") || hasFlag("no-hyperlinks") || hasFlag("hyperlink=false") || hasFlag("hyperlink=never")) {
    return false;
  }
  if (hasFlag("hyperlink=true") || hasFlag("hyperlink=always")) {
    return true;
  }
  if (!supportsColor.supportsColor(stream)) {
    return false;
  }
  if (stream && !stream.isTTY) {
    return false;
  }
  if (process.platform === "win32") {
    return false;
  }
  if ("NETLIFY" in env2) {
    return true;
  }
  if ("CI" in env2) {
    return false;
  }
  if ("TEAMCITY_VERSION" in env2) {
    return false;
  }
  if ("TERM_PROGRAM" in env2) {
    const version = parseVersion(env2.TERM_PROGRAM_VERSION);
    switch (env2.TERM_PROGRAM) {
      case "iTerm.app":
        if (version.major === 3) {
          return version.minor >= 1;
        }
        return version.major > 3;
    }
  }
  if ("VTE_VERSION" in env2) {
    if (env2.VTE_VERSION === "0.50.0") {
      return false;
    }
    const version = parseVersion(env2.VTE_VERSION);
    return version.major > 0 || version.minor >= 50;
  }
  return false;
}
var supportsHyperlinks = {
  supportsHyperlink,
  stdout: supportsHyperlink(process.stdout),
  stderr: supportsHyperlink(process.stderr)
};
var supportsHyperlinks$1 = /* @__PURE__ */ getDefaultExportFromCjs(supportsHyperlinks);
function terminalLink(text2, url2, { target = "stdout", ...options2 } = {}) {
  if (!supportsHyperlinks$1[target]) {
    if (options2.fallback === false) {
      return text2;
    }
    return typeof options2.fallback === "function" ? options2.fallback(text2, url2) : `${text2} (\u200B${url2}\u200B)`;
  }
  return ansiEscapes.link(text2, url2);
}
terminalLink.isSupported = supportsHyperlinks$1.stdout;
terminalLink.stderr = (text2, url2, options2 = {}) => terminalLink(text2, url2, { target: "stderr", ...options2 });
terminalLink.stderr.isSupported = supportsHyperlinks$1.stderr;
var prompts$3 = {};
var FORCE_COLOR$1;
var NODE_DISABLE_COLORS$1;
var NO_COLOR$1;
var TERM$1;
var isTTY$1 = true;
if (typeof process !== "undefined") {
  ({ FORCE_COLOR: FORCE_COLOR$1, NODE_DISABLE_COLORS: NODE_DISABLE_COLORS$1, NO_COLOR: NO_COLOR$1, TERM: TERM$1 } = process.env || {});
  isTTY$1 = process.stdout && process.stdout.isTTY;
}
var $$1 = {
  enabled: !NODE_DISABLE_COLORS$1 && NO_COLOR$1 == null && TERM$1 !== "dumb" && (FORCE_COLOR$1 != null && FORCE_COLOR$1 !== "0" || isTTY$1),
  // modifiers
  reset: init$1(0, 0),
  bold: init$1(1, 22),
  dim: init$1(2, 22),
  italic: init$1(3, 23),
  underline: init$1(4, 24),
  inverse: init$1(7, 27),
  hidden: init$1(8, 28),
  strikethrough: init$1(9, 29),
  // colors
  black: init$1(30, 39),
  red: init$1(31, 39),
  green: init$1(32, 39),
  yellow: init$1(33, 39),
  blue: init$1(34, 39),
  magenta: init$1(35, 39),
  cyan: init$1(36, 39),
  white: init$1(37, 39),
  gray: init$1(90, 39),
  grey: init$1(90, 39),
  // background colors
  bgBlack: init$1(40, 49),
  bgRed: init$1(41, 49),
  bgGreen: init$1(42, 49),
  bgYellow: init$1(43, 49),
  bgBlue: init$1(44, 49),
  bgMagenta: init$1(45, 49),
  bgCyan: init$1(46, 49),
  bgWhite: init$1(47, 49)
};
function run$2(arr, str) {
  let i = 0, tmp, beg = "", end = "";
  for (; i < arr.length; i++) {
    tmp = arr[i];
    beg += tmp.open;
    end += tmp.close;
    if (!!~str.indexOf(tmp.close)) {
      str = str.replace(tmp.rgx, tmp.close + tmp.open);
    }
  }
  return beg + str + end;
}
function chain$1(has, keys) {
  let ctx = { has, keys };
  ctx.reset = $$1.reset.bind(ctx);
  ctx.bold = $$1.bold.bind(ctx);
  ctx.dim = $$1.dim.bind(ctx);
  ctx.italic = $$1.italic.bind(ctx);
  ctx.underline = $$1.underline.bind(ctx);
  ctx.inverse = $$1.inverse.bind(ctx);
  ctx.hidden = $$1.hidden.bind(ctx);
  ctx.strikethrough = $$1.strikethrough.bind(ctx);
  ctx.black = $$1.black.bind(ctx);
  ctx.red = $$1.red.bind(ctx);
  ctx.green = $$1.green.bind(ctx);
  ctx.yellow = $$1.yellow.bind(ctx);
  ctx.blue = $$1.blue.bind(ctx);
  ctx.magenta = $$1.magenta.bind(ctx);
  ctx.cyan = $$1.cyan.bind(ctx);
  ctx.white = $$1.white.bind(ctx);
  ctx.gray = $$1.gray.bind(ctx);
  ctx.grey = $$1.grey.bind(ctx);
  ctx.bgBlack = $$1.bgBlack.bind(ctx);
  ctx.bgRed = $$1.bgRed.bind(ctx);
  ctx.bgGreen = $$1.bgGreen.bind(ctx);
  ctx.bgYellow = $$1.bgYellow.bind(ctx);
  ctx.bgBlue = $$1.bgBlue.bind(ctx);
  ctx.bgMagenta = $$1.bgMagenta.bind(ctx);
  ctx.bgCyan = $$1.bgCyan.bind(ctx);
  ctx.bgWhite = $$1.bgWhite.bind(ctx);
  return ctx;
}
function init$1(open, close) {
  let blk = {
    open: `\x1B[${open}m`,
    close: `\x1B[${close}m`,
    rgx: new RegExp(`\\x1b\\[${close}m`, "g")
  };
  return function(txt) {
    if (this !== void 0 && this.has !== void 0) {
      !!~this.has.indexOf(open) || (this.has.push(open), this.keys.push(blk));
      return txt === void 0 ? this : $$1.enabled ? run$2(this.keys, txt + "") : txt + "";
    }
    return txt === void 0 ? chain$1([open], [blk]) : $$1.enabled ? run$2([blk], txt + "") : txt + "";
  };
}
var kleur = $$1;
var action$1 = (key, isSelect) => {
  if (key.meta && key.name !== "escape") return;
  if (key.ctrl) {
    if (key.name === "a") return "first";
    if (key.name === "c") return "abort";
    if (key.name === "d") return "abort";
    if (key.name === "e") return "last";
    if (key.name === "g") return "reset";
    if (key.name === "n") return "down";
    if (key.name === "p") return "up";
    return;
  }
  if (isSelect) {
    if (key.name === "j") return "down";
    if (key.name === "k") return "up";
  }
  if (key.name === "return") return "submit";
  if (key.name === "enter") return "submit";
  if (key.name === "backspace") return "delete";
  if (key.name === "delete") return "deleteForward";
  if (key.name === "abort") return "abort";
  if (key.name === "escape") return "exit";
  if (key.name === "tab") return "next";
  if (key.name === "pagedown") return "nextPage";
  if (key.name === "pageup") return "prevPage";
  if (key.name === "home") return "home";
  if (key.name === "end") return "end";
  if (key.name === "up") return "up";
  if (key.name === "down") return "down";
  if (key.name === "right") return "right";
  if (key.name === "left") return "left";
  return false;
};
var strip$2 = (str) => {
  const pattern = [
    "[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)",
    "(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PRZcf-ntqry=><~]))"
  ].join("|");
  const RGX = new RegExp(pattern, "g");
  return typeof str === "string" ? str.replace(RGX, "") : str;
};
var ESC = "\x1B";
var CSI = `${ESC}[`;
var beep$1 = "\x07";
var cursor$b = {
  to(x, y) {
    if (!y) return `${CSI}${x + 1}G`;
    return `${CSI}${y + 1};${x + 1}H`;
  },
  move(x, y) {
    let ret = "";
    if (x < 0) ret += `${CSI}${-x}D`;
    else if (x > 0) ret += `${CSI}${x}C`;
    if (y < 0) ret += `${CSI}${-y}A`;
    else if (y > 0) ret += `${CSI}${y}B`;
    return ret;
  },
  up: (count = 1) => `${CSI}${count}A`,
  down: (count = 1) => `${CSI}${count}B`,
  forward: (count = 1) => `${CSI}${count}C`,
  backward: (count = 1) => `${CSI}${count}D`,
  nextLine: (count = 1) => `${CSI}E`.repeat(count),
  prevLine: (count = 1) => `${CSI}F`.repeat(count),
  left: `${CSI}G`,
  hide: `${CSI}?25l`,
  show: `${CSI}?25h`,
  save: `${ESC}7`,
  restore: `${ESC}8`
};
var scroll = {
  up: (count = 1) => `${CSI}S`.repeat(count),
  down: (count = 1) => `${CSI}T`.repeat(count)
};
var erase$7 = {
  screen: `${CSI}2J`,
  up: (count = 1) => `${CSI}1J`.repeat(count),
  down: (count = 1) => `${CSI}J`.repeat(count),
  line: `${CSI}2K`,
  lineEnd: `${CSI}K`,
  lineStart: `${CSI}1K`,
  lines(count) {
    let clear2 = "";
    for (let i = 0; i < count; i++)
      clear2 += this.line + (i < count - 1 ? cursor$b.up() : "");
    if (count)
      clear2 += cursor$b.left;
    return clear2;
  }
};
var src = { cursor: cursor$b, scroll, erase: erase$7, beep: beep$1 };
var strip$1 = strip$2;
var { erase: erase$6, cursor: cursor$a } = src;
var width = (str) => [...strip$1(str)].length;
var clear$9 = function(prompt2, perLine) {
  if (!perLine) return erase$6.line + cursor$a.to(0);
  let rows = 0;
  const lines2 = prompt2.split(/\r?\n/);
  for (let line of lines2) {
    rows += 1 + Math.floor(Math.max(width(line) - 1, 0) / perLine);
  }
  return erase$6.lines(rows);
};
var main = {
  arrowUp: "\u2191",
  arrowDown: "\u2193",
  arrowLeft: "\u2190",
  arrowRight: "\u2192",
  radioOn: "\u25C9",
  radioOff: "\u25EF",
  tick: "\u2714",
  cross: "\u2716",
  ellipsis: "\u2026",
  pointerSmall: "\u203A",
  line: "\u2500",
  pointer: "\u276F"
};
var win = {
  arrowUp: main.arrowUp,
  arrowDown: main.arrowDown,
  arrowLeft: main.arrowLeft,
  arrowRight: main.arrowRight,
  radioOn: "(*)",
  radioOff: "( )",
  tick: "\u221A",
  cross: "\xD7",
  ellipsis: "...",
  pointerSmall: "\xBB",
  line: "\u2500",
  pointer: ">"
};
var figures$8 = process.platform === "win32" ? win : main;
var figures_1 = figures$8;
var c = kleur;
var figures$7 = figures_1;
var styles = Object.freeze({
  password: { scale: 1, render: (input) => "*".repeat(input.length) },
  emoji: { scale: 2, render: (input) => "\u{1F603}".repeat(input.length) },
  invisible: { scale: 0, render: (input) => "" },
  default: { scale: 1, render: (input) => `${input}` }
});
var render = (type) => styles[type] || styles.default;
var symbols = Object.freeze({
  aborted: c.red(figures$7.cross),
  done: c.green(figures$7.tick),
  exited: c.yellow(figures$7.cross),
  default: c.cyan("?")
});
var symbol = (done, aborted, exited) => aborted ? symbols.aborted : exited ? symbols.exited : done ? symbols.done : symbols.default;
var delimiter$1 = (completing) => c.gray(completing ? figures$7.ellipsis : figures$7.pointerSmall);
var item = (expandable, expanded) => c.gray(expandable ? expanded ? figures$7.pointerSmall : "+" : figures$7.line);
var style$9 = {
  styles,
  render,
  symbols,
  symbol,
  delimiter: delimiter$1,
  item
};
var strip = strip$2;
var lines$2 = function(msg, perLine) {
  let lines2 = String(strip(msg) || "").split(/\r?\n/);
  if (!perLine) return lines2.length;
  return lines2.map((l) => Math.ceil(l.length / perLine)).reduce((a, b) => a + b);
};
var wrap$3 = (msg, opts = {}) => {
  const tab = Number.isSafeInteger(parseInt(opts.margin)) ? new Array(parseInt(opts.margin)).fill(" ").join("") : opts.margin || "";
  const width2 = opts.width;
  return (msg || "").split(/\r?\n/g).map((line) => line.split(/\s+/g).reduce((arr, w) => {
    if (w.length + tab.length >= width2 || arr[arr.length - 1].length + w.length + 1 < width2)
      arr[arr.length - 1] += ` ${w}`;
    else arr.push(`${tab}${w}`);
    return arr;
  }, [tab]).join("\n")).join("\n");
};
var entriesToDisplay$3 = (cursor2, total, maxVisible) => {
  maxVisible = maxVisible || total;
  let startIndex = Math.min(total - maxVisible, cursor2 - Math.floor(maxVisible / 2));
  if (startIndex < 0) startIndex = 0;
  let endIndex = Math.min(startIndex + maxVisible, total);
  return { startIndex, endIndex };
};
var util = {
  action: action$1,
  clear: clear$9,
  style: style$9,
  strip: strip$2,
  figures: figures_1,
  lines: lines$2,
  wrap: wrap$3,
  entriesToDisplay: entriesToDisplay$3
};
var readline = import_readline.default;
var { action } = util;
var EventEmitter = import_events.default;
var { beep, cursor: cursor$9 } = src;
var color$9 = kleur;
var Prompt$8 = class Prompt extends EventEmitter {
  constructor(opts = {}) {
    super();
    this.firstRender = true;
    this.in = opts.stdin || process.stdin;
    this.out = opts.stdout || process.stdout;
    this.onRender = (opts.onRender || (() => void 0)).bind(this);
    const rl = readline.createInterface({ input: this.in, escapeCodeTimeout: 50 });
    readline.emitKeypressEvents(this.in, rl);
    if (this.in.isTTY) this.in.setRawMode(true);
    const isSelect = ["SelectPrompt", "MultiselectPrompt"].indexOf(this.constructor.name) > -1;
    const keypress = (str, key) => {
      let a = action(key, isSelect);
      if (a === false) {
        this._ && this._(str, key);
      } else if (typeof this[a] === "function") {
        this[a](key);
      } else {
        this.bell();
      }
    };
    this.close = () => {
      this.out.write(cursor$9.show);
      this.in.removeListener("keypress", keypress);
      if (this.in.isTTY) this.in.setRawMode(false);
      rl.close();
      this.emit(this.aborted ? "abort" : this.exited ? "exit" : "submit", this.value);
      this.closed = true;
    };
    this.in.on("keypress", keypress);
  }
  fire() {
    this.emit("state", {
      value: this.value,
      aborted: !!this.aborted,
      exited: !!this.exited
    });
  }
  bell() {
    this.out.write(beep);
  }
  render() {
    this.onRender(color$9);
    if (this.firstRender) this.firstRender = false;
  }
};
var prompt$1 = Prompt$8;
var color$8 = kleur;
var Prompt$7 = prompt$1;
var { erase: erase$5, cursor: cursor$8 } = src;
var { style: style$8, clear: clear$8, lines: lines$1, figures: figures$6 } = util;
var TextPrompt = class extends Prompt$7 {
  constructor(opts = {}) {
    super(opts);
    this.transform = style$8.render(opts.style);
    this.scale = this.transform.scale;
    this.msg = opts.message;
    this.initial = opts.initial || ``;
    this.validator = opts.validate || (() => true);
    this.value = ``;
    this.errorMsg = opts.error || `Please Enter A Valid Value`;
    this.cursor = Number(!!this.initial);
    this.cursorOffset = 0;
    this.clear = clear$8(``, this.out.columns);
    this.render();
  }
  set value(v) {
    if (!v && this.initial) {
      this.placeholder = true;
      this.rendered = color$8.gray(this.transform.render(this.initial));
    } else {
      this.placeholder = false;
      this.rendered = this.transform.render(v);
    }
    this._value = v;
    this.fire();
  }
  get value() {
    return this._value;
  }
  reset() {
    this.value = ``;
    this.cursor = Number(!!this.initial);
    this.cursorOffset = 0;
    this.fire();
    this.render();
  }
  exit() {
    this.abort();
  }
  abort() {
    this.value = this.value || this.initial;
    this.done = this.aborted = true;
    this.error = false;
    this.red = false;
    this.fire();
    this.render();
    this.out.write("\n");
    this.close();
  }
  async validate() {
    let valid = await this.validator(this.value);
    if (typeof valid === `string`) {
      this.errorMsg = valid;
      valid = false;
    }
    this.error = !valid;
  }
  async submit() {
    this.value = this.value || this.initial;
    this.cursorOffset = 0;
    this.cursor = this.rendered.length;
    await this.validate();
    if (this.error) {
      this.red = true;
      this.fire();
      this.render();
      return;
    }
    this.done = true;
    this.aborted = false;
    this.fire();
    this.render();
    this.out.write("\n");
    this.close();
  }
  next() {
    if (!this.placeholder) return this.bell();
    this.value = this.initial;
    this.cursor = this.rendered.length;
    this.fire();
    this.render();
  }
  moveCursor(n) {
    if (this.placeholder) return;
    this.cursor = this.cursor + n;
    this.cursorOffset += n;
  }
  _(c2, key) {
    let s1 = this.value.slice(0, this.cursor);
    let s2 = this.value.slice(this.cursor);
    this.value = `${s1}${c2}${s2}`;
    this.red = false;
    this.cursor = this.placeholder ? 0 : s1.length + 1;
    this.render();
  }
  delete() {
    if (this.isCursorAtStart()) return this.bell();
    let s1 = this.value.slice(0, this.cursor - 1);
    let s2 = this.value.slice(this.cursor);
    this.value = `${s1}${s2}`;
    this.red = false;
    if (this.isCursorAtStart()) {
      this.cursorOffset = 0;
    } else {
      this.cursorOffset++;
      this.moveCursor(-1);
    }
    this.render();
  }
  deleteForward() {
    if (this.cursor * this.scale >= this.rendered.length || this.placeholder) return this.bell();
    let s1 = this.value.slice(0, this.cursor);
    let s2 = this.value.slice(this.cursor + 1);
    this.value = `${s1}${s2}`;
    this.red = false;
    if (this.isCursorAtEnd()) {
      this.cursorOffset = 0;
    } else {
      this.cursorOffset++;
    }
    this.render();
  }
  first() {
    this.cursor = 0;
    this.render();
  }
  last() {
    this.cursor = this.value.length;
    this.render();
  }
  left() {
    if (this.cursor <= 0 || this.placeholder) return this.bell();
    this.moveCursor(-1);
    this.render();
  }
  right() {
    if (this.cursor * this.scale >= this.rendered.length || this.placeholder) return this.bell();
    this.moveCursor(1);
    this.render();
  }
  isCursorAtStart() {
    return this.cursor === 0 || this.placeholder && this.cursor === 1;
  }
  isCursorAtEnd() {
    return this.cursor === this.rendered.length || this.placeholder && this.cursor === this.rendered.length + 1;
  }
  render() {
    if (this.closed) return;
    if (!this.firstRender) {
      if (this.outputError)
        this.out.write(cursor$8.down(lines$1(this.outputError, this.out.columns) - 1) + clear$8(this.outputError, this.out.columns));
      this.out.write(clear$8(this.outputText, this.out.columns));
    }
    super.render();
    this.outputError = "";
    this.outputText = [
      style$8.symbol(this.done, this.aborted),
      color$8.bold(this.msg),
      style$8.delimiter(this.done),
      this.red ? color$8.red(this.rendered) : this.rendered
    ].join(` `);
    if (this.error) {
      this.outputError += this.errorMsg.split(`
`).reduce((a, l, i) => a + `
${i ? " " : figures$6.pointerSmall} ${color$8.red().italic(l)}`, ``);
    }
    this.out.write(erase$5.line + cursor$8.to(0) + this.outputText + cursor$8.save + this.outputError + cursor$8.restore + cursor$8.move(this.cursorOffset, 0));
  }
};
var text = TextPrompt;
var color$7 = kleur;
var Prompt$6 = prompt$1;
var { style: style$7, clear: clear$7, figures: figures$5, wrap: wrap$2, entriesToDisplay: entriesToDisplay$2 } = util;
var { cursor: cursor$7 } = src;
var SelectPrompt = class extends Prompt$6 {
  constructor(opts = {}) {
    super(opts);
    this.msg = opts.message;
    this.hint = opts.hint || "- Use arrow-keys. Return to submit.";
    this.warn = opts.warn || "- This option is disabled";
    this.cursor = opts.initial || 0;
    this.choices = opts.choices.map((ch, idx) => {
      if (typeof ch === "string")
        ch = { title: ch, value: idx };
      return {
        title: ch && (ch.title || ch.value || ch),
        value: ch && (ch.value === void 0 ? idx : ch.value),
        description: ch && ch.description,
        selected: ch && ch.selected,
        disabled: ch && ch.disabled
      };
    });
    this.optionsPerPage = opts.optionsPerPage || 10;
    this.value = (this.choices[this.cursor] || {}).value;
    this.clear = clear$7("", this.out.columns);
    this.render();
  }
  moveCursor(n) {
    this.cursor = n;
    this.value = this.choices[n].value;
    this.fire();
  }
  reset() {
    this.moveCursor(0);
    this.fire();
    this.render();
  }
  exit() {
    this.abort();
  }
  abort() {
    this.done = this.aborted = true;
    this.fire();
    this.render();
    this.out.write("\n");
    this.close();
  }
  submit() {
    if (!this.selection.disabled) {
      this.done = true;
      this.aborted = false;
      this.fire();
      this.render();
      this.out.write("\n");
      this.close();
    } else
      this.bell();
  }
  first() {
    this.moveCursor(0);
    this.render();
  }
  last() {
    this.moveCursor(this.choices.length - 1);
    this.render();
  }
  up() {
    if (this.cursor === 0) {
      this.moveCursor(this.choices.length - 1);
    } else {
      this.moveCursor(this.cursor - 1);
    }
    this.render();
  }
  down() {
    if (this.cursor === this.choices.length - 1) {
      this.moveCursor(0);
    } else {
      this.moveCursor(this.cursor + 1);
    }
    this.render();
  }
  next() {
    this.moveCursor((this.cursor + 1) % this.choices.length);
    this.render();
  }
  _(c2, key) {
    if (c2 === " ") return this.submit();
  }
  get selection() {
    return this.choices[this.cursor];
  }
  render() {
    if (this.closed) return;
    if (this.firstRender) this.out.write(cursor$7.hide);
    else this.out.write(clear$7(this.outputText, this.out.columns));
    super.render();
    let { startIndex, endIndex } = entriesToDisplay$2(this.cursor, this.choices.length, this.optionsPerPage);
    this.outputText = [
      style$7.symbol(this.done, this.aborted),
      color$7.bold(this.msg),
      style$7.delimiter(false),
      this.done ? this.selection.title : this.selection.disabled ? color$7.yellow(this.warn) : color$7.gray(this.hint)
    ].join(" ");
    if (!this.done) {
      this.outputText += "\n";
      for (let i = startIndex; i < endIndex; i++) {
        let title, prefix, desc = "", v = this.choices[i];
        if (i === startIndex && startIndex > 0) {
          prefix = figures$5.arrowUp;
        } else if (i === endIndex - 1 && endIndex < this.choices.length) {
          prefix = figures$5.arrowDown;
        } else {
          prefix = " ";
        }
        if (v.disabled) {
          title = this.cursor === i ? color$7.gray().underline(v.title) : color$7.strikethrough().gray(v.title);
          prefix = (this.cursor === i ? color$7.bold().gray(figures$5.pointer) + " " : "  ") + prefix;
        } else {
          title = this.cursor === i ? color$7.cyan().underline(v.title) : v.title;
          prefix = (this.cursor === i ? color$7.cyan(figures$5.pointer) + " " : "  ") + prefix;
          if (v.description && this.cursor === i) {
            desc = ` - ${v.description}`;
            if (prefix.length + title.length + desc.length >= this.out.columns || v.description.split(/\r?\n/).length > 1) {
              desc = "\n" + wrap$2(v.description, { margin: 3, width: this.out.columns });
            }
          }
        }
        this.outputText += `${prefix} ${title}${color$7.gray(desc)}
`;
      }
    }
    this.out.write(this.outputText);
  }
};
var select = SelectPrompt;
var color$6 = kleur;
var Prompt$5 = prompt$1;
var { style: style$6, clear: clear$6 } = util;
var { cursor: cursor$6, erase: erase$4 } = src;
var TogglePrompt = class extends Prompt$5 {
  constructor(opts = {}) {
    super(opts);
    this.msg = opts.message;
    this.value = !!opts.initial;
    this.active = opts.active || "on";
    this.inactive = opts.inactive || "off";
    this.initialValue = this.value;
    this.render();
  }
  reset() {
    this.value = this.initialValue;
    this.fire();
    this.render();
  }
  exit() {
    this.abort();
  }
  abort() {
    this.done = this.aborted = true;
    this.fire();
    this.render();
    this.out.write("\n");
    this.close();
  }
  submit() {
    this.done = true;
    this.aborted = false;
    this.fire();
    this.render();
    this.out.write("\n");
    this.close();
  }
  deactivate() {
    if (this.value === false) return this.bell();
    this.value = false;
    this.render();
  }
  activate() {
    if (this.value === true) return this.bell();
    this.value = true;
    this.render();
  }
  delete() {
    this.deactivate();
  }
  left() {
    this.deactivate();
  }
  right() {
    this.activate();
  }
  down() {
    this.deactivate();
  }
  up() {
    this.activate();
  }
  next() {
    this.value = !this.value;
    this.fire();
    this.render();
  }
  _(c2, key) {
    if (c2 === " ") {
      this.value = !this.value;
    } else if (c2 === "1") {
      this.value = true;
    } else if (c2 === "0") {
      this.value = false;
    } else return this.bell();
    this.render();
  }
  render() {
    if (this.closed) return;
    if (this.firstRender) this.out.write(cursor$6.hide);
    else this.out.write(clear$6(this.outputText, this.out.columns));
    super.render();
    this.outputText = [
      style$6.symbol(this.done, this.aborted),
      color$6.bold(this.msg),
      style$6.delimiter(this.done),
      this.value ? this.inactive : color$6.cyan().underline(this.inactive),
      color$6.gray("/"),
      this.value ? color$6.cyan().underline(this.active) : this.active
    ].join(" ");
    this.out.write(erase$4.line + cursor$6.to(0) + this.outputText);
  }
};
var toggle = TogglePrompt;
var DatePart$9 = class DatePart {
  constructor({ token, date: date2, parts, locales }) {
    this.token = token;
    this.date = date2 || /* @__PURE__ */ new Date();
    this.parts = parts || [this];
    this.locales = locales || {};
  }
  up() {
  }
  down() {
  }
  next() {
    const currentIdx = this.parts.indexOf(this);
    return this.parts.find((part, idx) => idx > currentIdx && part instanceof DatePart);
  }
  setTo(val) {
  }
  prev() {
    let parts = [].concat(this.parts).reverse();
    const currentIdx = parts.indexOf(this);
    return parts.find((part, idx) => idx > currentIdx && part instanceof DatePart);
  }
  toString() {
    return String(this.date);
  }
};
var datepart = DatePart$9;
var DatePart$8 = datepart;
var Meridiem$1 = class Meridiem extends DatePart$8 {
  constructor(opts = {}) {
    super(opts);
  }
  up() {
    this.date.setHours((this.date.getHours() + 12) % 24);
  }
  down() {
    this.up();
  }
  toString() {
    let meridiem2 = this.date.getHours() > 12 ? "pm" : "am";
    return /\A/.test(this.token) ? meridiem2.toUpperCase() : meridiem2;
  }
};
var meridiem = Meridiem$1;
var DatePart$7 = datepart;
var pos = (n) => {
  n = n % 10;
  return n === 1 ? "st" : n === 2 ? "nd" : n === 3 ? "rd" : "th";
};
var Day$1 = class Day extends DatePart$7 {
  constructor(opts = {}) {
    super(opts);
  }
  up() {
    this.date.setDate(this.date.getDate() + 1);
  }
  down() {
    this.date.setDate(this.date.getDate() - 1);
  }
  setTo(val) {
    this.date.setDate(parseInt(val.substr(-2)));
  }
  toString() {
    let date2 = this.date.getDate();
    let day2 = this.date.getDay();
    return this.token === "DD" ? String(date2).padStart(2, "0") : this.token === "Do" ? date2 + pos(date2) : this.token === "d" ? day2 + 1 : this.token === "ddd" ? this.locales.weekdaysShort[day2] : this.token === "dddd" ? this.locales.weekdays[day2] : date2;
  }
};
var day = Day$1;
var DatePart$6 = datepart;
var Hours$1 = class Hours extends DatePart$6 {
  constructor(opts = {}) {
    super(opts);
  }
  up() {
    this.date.setHours(this.date.getHours() + 1);
  }
  down() {
    this.date.setHours(this.date.getHours() - 1);
  }
  setTo(val) {
    this.date.setHours(parseInt(val.substr(-2)));
  }
  toString() {
    let hours2 = this.date.getHours();
    if (/h/.test(this.token))
      hours2 = hours2 % 12 || 12;
    return this.token.length > 1 ? String(hours2).padStart(2, "0") : hours2;
  }
};
var hours = Hours$1;
var DatePart$5 = datepart;
var Milliseconds$1 = class Milliseconds extends DatePart$5 {
  constructor(opts = {}) {
    super(opts);
  }
  up() {
    this.date.setMilliseconds(this.date.getMilliseconds() + 1);
  }
  down() {
    this.date.setMilliseconds(this.date.getMilliseconds() - 1);
  }
  setTo(val) {
    this.date.setMilliseconds(parseInt(val.substr(-this.token.length)));
  }
  toString() {
    return String(this.date.getMilliseconds()).padStart(4, "0").substr(0, this.token.length);
  }
};
var milliseconds = Milliseconds$1;
var DatePart$4 = datepart;
var Minutes$1 = class Minutes extends DatePart$4 {
  constructor(opts = {}) {
    super(opts);
  }
  up() {
    this.date.setMinutes(this.date.getMinutes() + 1);
  }
  down() {
    this.date.setMinutes(this.date.getMinutes() - 1);
  }
  setTo(val) {
    this.date.setMinutes(parseInt(val.substr(-2)));
  }
  toString() {
    let m = this.date.getMinutes();
    return this.token.length > 1 ? String(m).padStart(2, "0") : m;
  }
};
var minutes = Minutes$1;
var DatePart$3 = datepart;
var Month$1 = class Month extends DatePart$3 {
  constructor(opts = {}) {
    super(opts);
  }
  up() {
    this.date.setMonth(this.date.getMonth() + 1);
  }
  down() {
    this.date.setMonth(this.date.getMonth() - 1);
  }
  setTo(val) {
    val = parseInt(val.substr(-2)) - 1;
    this.date.setMonth(val < 0 ? 0 : val);
  }
  toString() {
    let month2 = this.date.getMonth();
    let tl = this.token.length;
    return tl === 2 ? String(month2 + 1).padStart(2, "0") : tl === 3 ? this.locales.monthsShort[month2] : tl === 4 ? this.locales.months[month2] : String(month2 + 1);
  }
};
var month = Month$1;
var DatePart$2 = datepart;
var Seconds$1 = class Seconds extends DatePart$2 {
  constructor(opts = {}) {
    super(opts);
  }
  up() {
    this.date.setSeconds(this.date.getSeconds() + 1);
  }
  down() {
    this.date.setSeconds(this.date.getSeconds() - 1);
  }
  setTo(val) {
    this.date.setSeconds(parseInt(val.substr(-2)));
  }
  toString() {
    let s = this.date.getSeconds();
    return this.token.length > 1 ? String(s).padStart(2, "0") : s;
  }
};
var seconds = Seconds$1;
var DatePart$1 = datepart;
var Year$1 = class Year extends DatePart$1 {
  constructor(opts = {}) {
    super(opts);
  }
  up() {
    this.date.setFullYear(this.date.getFullYear() + 1);
  }
  down() {
    this.date.setFullYear(this.date.getFullYear() - 1);
  }
  setTo(val) {
    this.date.setFullYear(val.substr(-4));
  }
  toString() {
    let year2 = String(this.date.getFullYear()).padStart(4, "0");
    return this.token.length === 2 ? year2.substr(-2) : year2;
  }
};
var year = Year$1;
var dateparts = {
  DatePart: datepart,
  Meridiem: meridiem,
  Day: day,
  Hours: hours,
  Milliseconds: milliseconds,
  Minutes: minutes,
  Month: month,
  Seconds: seconds,
  Year: year
};
var color$5 = kleur;
var Prompt$4 = prompt$1;
var { style: style$5, clear: clear$5, figures: figures$4 } = util;
var { erase: erase$3, cursor: cursor$5 } = src;
var { DatePart: DatePart2, Meridiem: Meridiem2, Day: Day2, Hours: Hours2, Milliseconds: Milliseconds2, Minutes: Minutes2, Month: Month2, Seconds: Seconds2, Year: Year2 } = dateparts;
var regex = /\\(.)|"((?:\\["\\]|[^"])+)"|(D[Do]?|d{3,4}|d)|(M{1,4})|(YY(?:YY)?)|([aA])|([Hh]{1,2})|(m{1,2})|(s{1,2})|(S{1,4})|./g;
var regexGroups = {
  1: ({ token }) => token.replace(/\\(.)/g, "$1"),
  2: (opts) => new Day2(opts),
  // Day // TODO
  3: (opts) => new Month2(opts),
  // Month
  4: (opts) => new Year2(opts),
  // Year
  5: (opts) => new Meridiem2(opts),
  // AM/PM // TODO (special)
  6: (opts) => new Hours2(opts),
  // Hours
  7: (opts) => new Minutes2(opts),
  // Minutes
  8: (opts) => new Seconds2(opts),
  // Seconds
  9: (opts) => new Milliseconds2(opts)
  // Fractional seconds
};
var dfltLocales = {
  months: "January,February,March,April,May,June,July,August,September,October,November,December".split(","),
  monthsShort: "Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec".split(","),
  weekdays: "Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday".split(","),
  weekdaysShort: "Sun,Mon,Tue,Wed,Thu,Fri,Sat".split(",")
};
var DatePrompt = class extends Prompt$4 {
  constructor(opts = {}) {
    super(opts);
    this.msg = opts.message;
    this.cursor = 0;
    this.typed = "";
    this.locales = Object.assign(dfltLocales, opts.locales);
    this._date = opts.initial || /* @__PURE__ */ new Date();
    this.errorMsg = opts.error || "Please Enter A Valid Value";
    this.validator = opts.validate || (() => true);
    this.mask = opts.mask || "YYYY-MM-DD HH:mm:ss";
    this.clear = clear$5("", this.out.columns);
    this.render();
  }
  get value() {
    return this.date;
  }
  get date() {
    return this._date;
  }
  set date(date2) {
    if (date2) this._date.setTime(date2.getTime());
  }
  set mask(mask) {
    let result;
    this.parts = [];
    while (result = regex.exec(mask)) {
      let match = result.shift();
      let idx = result.findIndex((gr) => gr != null);
      this.parts.push(idx in regexGroups ? regexGroups[idx]({ token: result[idx] || match, date: this.date, parts: this.parts, locales: this.locales }) : result[idx] || match);
    }
    let parts = this.parts.reduce((arr, i) => {
      if (typeof i === "string" && typeof arr[arr.length - 1] === "string")
        arr[arr.length - 1] += i;
      else arr.push(i);
      return arr;
    }, []);
    this.parts.splice(0);
    this.parts.push(...parts);
    this.reset();
  }
  moveCursor(n) {
    this.typed = "";
    this.cursor = n;
    this.fire();
  }
  reset() {
    this.moveCursor(this.parts.findIndex((p) => p instanceof DatePart2));
    this.fire();
    this.render();
  }
  exit() {
    this.abort();
  }
  abort() {
    this.done = this.aborted = true;
    this.error = false;
    this.fire();
    this.render();
    this.out.write("\n");
    this.close();
  }
  async validate() {
    let valid = await this.validator(this.value);
    if (typeof valid === "string") {
      this.errorMsg = valid;
      valid = false;
    }
    this.error = !valid;
  }
  async submit() {
    await this.validate();
    if (this.error) {
      this.color = "red";
      this.fire();
      this.render();
      return;
    }
    this.done = true;
    this.aborted = false;
    this.fire();
    this.render();
    this.out.write("\n");
    this.close();
  }
  up() {
    this.typed = "";
    this.parts[this.cursor].up();
    this.render();
  }
  down() {
    this.typed = "";
    this.parts[this.cursor].down();
    this.render();
  }
  left() {
    let prev = this.parts[this.cursor].prev();
    if (prev == null) return this.bell();
    this.moveCursor(this.parts.indexOf(prev));
    this.render();
  }
  right() {
    let next = this.parts[this.cursor].next();
    if (next == null) return this.bell();
    this.moveCursor(this.parts.indexOf(next));
    this.render();
  }
  next() {
    let next = this.parts[this.cursor].next();
    this.moveCursor(next ? this.parts.indexOf(next) : this.parts.findIndex((part) => part instanceof DatePart2));
    this.render();
  }
  _(c2) {
    if (/\d/.test(c2)) {
      this.typed += c2;
      this.parts[this.cursor].setTo(this.typed);
      this.render();
    }
  }
  render() {
    if (this.closed) return;
    if (this.firstRender) this.out.write(cursor$5.hide);
    else this.out.write(clear$5(this.outputText, this.out.columns));
    super.render();
    this.outputText = [
      style$5.symbol(this.done, this.aborted),
      color$5.bold(this.msg),
      style$5.delimiter(false),
      this.parts.reduce((arr, p, idx) => arr.concat(idx === this.cursor && !this.done ? color$5.cyan().underline(p.toString()) : p), []).join("")
    ].join(" ");
    if (this.error) {
      this.outputText += this.errorMsg.split("\n").reduce(
        (a, l, i) => a + `
${i ? ` ` : figures$4.pointerSmall} ${color$5.red().italic(l)}`,
        ``
      );
    }
    this.out.write(erase$3.line + cursor$5.to(0) + this.outputText);
  }
};
var date = DatePrompt;
var color$4 = kleur;
var Prompt$3 = prompt$1;
var { cursor: cursor$4, erase: erase$2 } = src;
var { style: style$4, figures: figures$3, clear: clear$4, lines } = util;
var isNumber = /[0-9]/;
var isDef = (any) => any !== void 0;
var round = (number2, precision) => {
  let factor = Math.pow(10, precision);
  return Math.round(number2 * factor) / factor;
};
var NumberPrompt = class extends Prompt$3 {
  constructor(opts = {}) {
    super(opts);
    this.transform = style$4.render(opts.style);
    this.msg = opts.message;
    this.initial = isDef(opts.initial) ? opts.initial : "";
    this.float = !!opts.float;
    this.round = opts.round || 2;
    this.inc = opts.increment || 1;
    this.min = isDef(opts.min) ? opts.min : -Infinity;
    this.max = isDef(opts.max) ? opts.max : Infinity;
    this.errorMsg = opts.error || `Please Enter A Valid Value`;
    this.validator = opts.validate || (() => true);
    this.color = `cyan`;
    this.value = ``;
    this.typed = ``;
    this.lastHit = 0;
    this.render();
  }
  set value(v) {
    if (!v && v !== 0) {
      this.placeholder = true;
      this.rendered = color$4.gray(this.transform.render(`${this.initial}`));
      this._value = ``;
    } else {
      this.placeholder = false;
      this.rendered = this.transform.render(`${round(v, this.round)}`);
      this._value = round(v, this.round);
    }
    this.fire();
  }
  get value() {
    return this._value;
  }
  parse(x) {
    return this.float ? parseFloat(x) : parseInt(x);
  }
  valid(c2) {
    return c2 === `-` || c2 === `.` && this.float || isNumber.test(c2);
  }
  reset() {
    this.typed = ``;
    this.value = ``;
    this.fire();
    this.render();
  }
  exit() {
    this.abort();
  }
  abort() {
    let x = this.value;
    this.value = x !== `` ? x : this.initial;
    this.done = this.aborted = true;
    this.error = false;
    this.fire();
    this.render();
    this.out.write(`
`);
    this.close();
  }
  async validate() {
    let valid = await this.validator(this.value);
    if (typeof valid === `string`) {
      this.errorMsg = valid;
      valid = false;
    }
    this.error = !valid;
  }
  async submit() {
    await this.validate();
    if (this.error) {
      this.color = `red`;
      this.fire();
      this.render();
      return;
    }
    let x = this.value;
    this.value = x !== `` ? x : this.initial;
    this.done = true;
    this.aborted = false;
    this.error = false;
    this.fire();
    this.render();
    this.out.write(`
`);
    this.close();
  }
  up() {
    this.typed = ``;
    if (this.value === "") {
      this.value = this.min - this.inc;
    }
    if (this.value >= this.max) return this.bell();
    this.value += this.inc;
    this.color = `cyan`;
    this.fire();
    this.render();
  }
  down() {
    this.typed = ``;
    if (this.value === "") {
      this.value = this.min + this.inc;
    }
    if (this.value <= this.min) return this.bell();
    this.value -= this.inc;
    this.color = `cyan`;
    this.fire();
    this.render();
  }
  delete() {
    let val = this.value.toString();
    if (val.length === 0) return this.bell();
    this.value = this.parse(val = val.slice(0, -1)) || ``;
    if (this.value !== "" && this.value < this.min) {
      this.value = this.min;
    }
    this.color = `cyan`;
    this.fire();
    this.render();
  }
  next() {
    this.value = this.initial;
    this.fire();
    this.render();
  }
  _(c2, key) {
    if (!this.valid(c2)) return this.bell();
    const now = Date.now();
    if (now - this.lastHit > 1e3) this.typed = ``;
    this.typed += c2;
    this.lastHit = now;
    this.color = `cyan`;
    if (c2 === `.`) return this.fire();
    this.value = Math.min(this.parse(this.typed), this.max);
    if (this.value > this.max) this.value = this.max;
    if (this.value < this.min) this.value = this.min;
    this.fire();
    this.render();
  }
  render() {
    if (this.closed) return;
    if (!this.firstRender) {
      if (this.outputError)
        this.out.write(cursor$4.down(lines(this.outputError, this.out.columns) - 1) + clear$4(this.outputError, this.out.columns));
      this.out.write(clear$4(this.outputText, this.out.columns));
    }
    super.render();
    this.outputError = "";
    this.outputText = [
      style$4.symbol(this.done, this.aborted),
      color$4.bold(this.msg),
      style$4.delimiter(this.done),
      !this.done || !this.done && !this.placeholder ? color$4[this.color]().underline(this.rendered) : this.rendered
    ].join(` `);
    if (this.error) {
      this.outputError += this.errorMsg.split(`
`).reduce((a, l, i) => a + `
${i ? ` ` : figures$3.pointerSmall} ${color$4.red().italic(l)}`, ``);
    }
    this.out.write(erase$2.line + cursor$4.to(0) + this.outputText + cursor$4.save + this.outputError + cursor$4.restore);
  }
};
var number = NumberPrompt;
var color$3 = kleur;
var { cursor: cursor$3 } = src;
var Prompt$2 = prompt$1;
var { clear: clear$3, figures: figures$2, style: style$3, wrap: wrap$1, entriesToDisplay: entriesToDisplay$1 } = util;
var MultiselectPrompt$1 = class MultiselectPrompt extends Prompt$2 {
  constructor(opts = {}) {
    super(opts);
    this.msg = opts.message;
    this.cursor = opts.cursor || 0;
    this.scrollIndex = opts.cursor || 0;
    this.hint = opts.hint || "";
    this.warn = opts.warn || "- This option is disabled -";
    this.minSelected = opts.min;
    this.showMinError = false;
    this.maxChoices = opts.max;
    this.instructions = opts.instructions;
    this.optionsPerPage = opts.optionsPerPage || 10;
    this.value = opts.choices.map((ch, idx) => {
      if (typeof ch === "string")
        ch = { title: ch, value: idx };
      return {
        title: ch && (ch.title || ch.value || ch),
        description: ch && ch.description,
        value: ch && (ch.value === void 0 ? idx : ch.value),
        selected: ch && ch.selected,
        disabled: ch && ch.disabled
      };
    });
    this.clear = clear$3("", this.out.columns);
    if (!opts.overrideRender) {
      this.render();
    }
  }
  reset() {
    this.value.map((v) => !v.selected);
    this.cursor = 0;
    this.fire();
    this.render();
  }
  selected() {
    return this.value.filter((v) => v.selected);
  }
  exit() {
    this.abort();
  }
  abort() {
    this.done = this.aborted = true;
    this.fire();
    this.render();
    this.out.write("\n");
    this.close();
  }
  submit() {
    const selected = this.value.filter((e) => e.selected);
    if (this.minSelected && selected.length < this.minSelected) {
      this.showMinError = true;
      this.render();
    } else {
      this.done = true;
      this.aborted = false;
      this.fire();
      this.render();
      this.out.write("\n");
      this.close();
    }
  }
  first() {
    this.cursor = 0;
    this.render();
  }
  last() {
    this.cursor = this.value.length - 1;
    this.render();
  }
  next() {
    this.cursor = (this.cursor + 1) % this.value.length;
    this.render();
  }
  up() {
    if (this.cursor === 0) {
      this.cursor = this.value.length - 1;
    } else {
      this.cursor--;
    }
    this.render();
  }
  down() {
    if (this.cursor === this.value.length - 1) {
      this.cursor = 0;
    } else {
      this.cursor++;
    }
    this.render();
  }
  left() {
    this.value[this.cursor].selected = false;
    this.render();
  }
  right() {
    if (this.value.filter((e) => e.selected).length >= this.maxChoices) return this.bell();
    this.value[this.cursor].selected = true;
    this.render();
  }
  handleSpaceToggle() {
    const v = this.value[this.cursor];
    if (v.selected) {
      v.selected = false;
      this.render();
    } else if (v.disabled || this.value.filter((e) => e.selected).length >= this.maxChoices) {
      return this.bell();
    } else {
      v.selected = true;
      this.render();
    }
  }
  toggleAll() {
    if (this.maxChoices !== void 0 || this.value[this.cursor].disabled) {
      return this.bell();
    }
    const newSelected = !this.value[this.cursor].selected;
    this.value.filter((v) => !v.disabled).forEach((v) => v.selected = newSelected);
    this.render();
  }
  _(c2, key) {
    if (c2 === " ") {
      this.handleSpaceToggle();
    } else if (c2 === "a") {
      this.toggleAll();
    } else {
      return this.bell();
    }
  }
  renderInstructions() {
    if (this.instructions === void 0 || this.instructions) {
      if (typeof this.instructions === "string") {
        return this.instructions;
      }
      return `
Instructions:
    ${figures$2.arrowUp}/${figures$2.arrowDown}: Highlight option
    ${figures$2.arrowLeft}/${figures$2.arrowRight}/[space]: Toggle selection
` + (this.maxChoices === void 0 ? `    a: Toggle all
` : "") + `    enter/return: Complete answer`;
    }
    return "";
  }
  renderOption(cursor2, v, i, arrowIndicator) {
    const prefix = (v.selected ? color$3.green(figures$2.radioOn) : figures$2.radioOff) + " " + arrowIndicator + " ";
    let title, desc;
    if (v.disabled) {
      title = cursor2 === i ? color$3.gray().underline(v.title) : color$3.strikethrough().gray(v.title);
    } else {
      title = cursor2 === i ? color$3.cyan().underline(v.title) : v.title;
      if (cursor2 === i && v.description) {
        desc = ` - ${v.description}`;
        if (prefix.length + title.length + desc.length >= this.out.columns || v.description.split(/\r?\n/).length > 1) {
          desc = "\n" + wrap$1(v.description, { margin: prefix.length, width: this.out.columns });
        }
      }
    }
    return prefix + title + color$3.gray(desc || "");
  }
  // shared with autocompleteMultiselect
  paginateOptions(options2) {
    if (options2.length === 0) {
      return color$3.red("No matches for this query.");
    }
    let { startIndex, endIndex } = entriesToDisplay$1(this.cursor, options2.length, this.optionsPerPage);
    let prefix, styledOptions = [];
    for (let i = startIndex; i < endIndex; i++) {
      if (i === startIndex && startIndex > 0) {
        prefix = figures$2.arrowUp;
      } else if (i === endIndex - 1 && endIndex < options2.length) {
        prefix = figures$2.arrowDown;
      } else {
        prefix = " ";
      }
      styledOptions.push(this.renderOption(this.cursor, options2[i], i, prefix));
    }
    return "\n" + styledOptions.join("\n");
  }
  // shared with autocomleteMultiselect
  renderOptions(options2) {
    if (!this.done) {
      return this.paginateOptions(options2);
    }
    return "";
  }
  renderDoneOrInstructions() {
    if (this.done) {
      return this.value.filter((e) => e.selected).map((v) => v.title).join(", ");
    }
    const output = [color$3.gray(this.hint), this.renderInstructions()];
    if (this.value[this.cursor].disabled) {
      output.push(color$3.yellow(this.warn));
    }
    return output.join(" ");
  }
  render() {
    if (this.closed) return;
    if (this.firstRender) this.out.write(cursor$3.hide);
    super.render();
    let prompt2 = [
      style$3.symbol(this.done, this.aborted),
      color$3.bold(this.msg),
      style$3.delimiter(false),
      this.renderDoneOrInstructions()
    ].join(" ");
    if (this.showMinError) {
      prompt2 += color$3.red(`You must select a minimum of ${this.minSelected} choices.`);
      this.showMinError = false;
    }
    prompt2 += this.renderOptions(this.value);
    this.out.write(this.clear + prompt2);
    this.clear = clear$3(prompt2, this.out.columns);
  }
};
var multiselect = MultiselectPrompt$1;
var color$2 = kleur;
var Prompt$1 = prompt$1;
var { erase: erase$1, cursor: cursor$2 } = src;
var { style: style$2, clear: clear$2, figures: figures$1, wrap, entriesToDisplay } = util;
var getVal = (arr, i) => arr[i] && (arr[i].value || arr[i].title || arr[i]);
var getTitle = (arr, i) => arr[i] && (arr[i].title || arr[i].value || arr[i]);
var getIndex = (arr, valOrTitle) => {
  const index = arr.findIndex((el) => el.value === valOrTitle || el.title === valOrTitle);
  return index > -1 ? index : void 0;
};
var AutocompletePrompt = class extends Prompt$1 {
  constructor(opts = {}) {
    super(opts);
    this.msg = opts.message;
    this.suggest = opts.suggest;
    this.choices = opts.choices;
    this.initial = typeof opts.initial === "number" ? opts.initial : getIndex(opts.choices, opts.initial);
    this.select = this.initial || opts.cursor || 0;
    this.i18n = { noMatches: opts.noMatches || "no matches found" };
    this.fallback = opts.fallback || this.initial;
    this.clearFirst = opts.clearFirst || false;
    this.suggestions = [];
    this.input = "";
    this.limit = opts.limit || 10;
    this.cursor = 0;
    this.transform = style$2.render(opts.style);
    this.scale = this.transform.scale;
    this.render = this.render.bind(this);
    this.complete = this.complete.bind(this);
    this.clear = clear$2("", this.out.columns);
    this.complete(this.render);
    this.render();
  }
  set fallback(fb) {
    this._fb = Number.isSafeInteger(parseInt(fb)) ? parseInt(fb) : fb;
  }
  get fallback() {
    let choice;
    if (typeof this._fb === "number")
      choice = this.choices[this._fb];
    else if (typeof this._fb === "string")
      choice = { title: this._fb };
    return choice || this._fb || { title: this.i18n.noMatches };
  }
  moveSelect(i) {
    this.select = i;
    if (this.suggestions.length > 0)
      this.value = getVal(this.suggestions, i);
    else this.value = this.fallback.value;
    this.fire();
  }
  async complete(cb) {
    const p = this.completing = this.suggest(this.input, this.choices);
    const suggestions = await p;
    if (this.completing !== p) return;
    this.suggestions = suggestions.map((s, i, arr) => ({ title: getTitle(arr, i), value: getVal(arr, i), description: s.description }));
    this.completing = false;
    const l = Math.max(suggestions.length - 1, 0);
    this.moveSelect(Math.min(l, this.select));
    cb && cb();
  }
  reset() {
    this.input = "";
    this.complete(() => {
      this.moveSelect(this.initial !== void 0 ? this.initial : 0);
      this.render();
    });
    this.render();
  }
  exit() {
    if (this.clearFirst && this.input.length > 0) {
      this.reset();
    } else {
      this.done = this.exited = true;
      this.aborted = false;
      this.fire();
      this.render();
      this.out.write("\n");
      this.close();
    }
  }
  abort() {
    this.done = this.aborted = true;
    this.exited = false;
    this.fire();
    this.render();
    this.out.write("\n");
    this.close();
  }
  submit() {
    this.done = true;
    this.aborted = this.exited = false;
    this.fire();
    this.render();
    this.out.write("\n");
    this.close();
  }
  _(c2, key) {
    let s1 = this.input.slice(0, this.cursor);
    let s2 = this.input.slice(this.cursor);
    this.input = `${s1}${c2}${s2}`;
    this.cursor = s1.length + 1;
    this.complete(this.render);
    this.render();
  }
  delete() {
    if (this.cursor === 0) return this.bell();
    let s1 = this.input.slice(0, this.cursor - 1);
    let s2 = this.input.slice(this.cursor);
    this.input = `${s1}${s2}`;
    this.complete(this.render);
    this.cursor = this.cursor - 1;
    this.render();
  }
  deleteForward() {
    if (this.cursor * this.scale >= this.rendered.length) return this.bell();
    let s1 = this.input.slice(0, this.cursor);
    let s2 = this.input.slice(this.cursor + 1);
    this.input = `${s1}${s2}`;
    this.complete(this.render);
    this.render();
  }
  first() {
    this.moveSelect(0);
    this.render();
  }
  last() {
    this.moveSelect(this.suggestions.length - 1);
    this.render();
  }
  up() {
    if (this.select === 0) {
      this.moveSelect(this.suggestions.length - 1);
    } else {
      this.moveSelect(this.select - 1);
    }
    this.render();
  }
  down() {
    if (this.select === this.suggestions.length - 1) {
      this.moveSelect(0);
    } else {
      this.moveSelect(this.select + 1);
    }
    this.render();
  }
  next() {
    if (this.select === this.suggestions.length - 1) {
      this.moveSelect(0);
    } else this.moveSelect(this.select + 1);
    this.render();
  }
  nextPage() {
    this.moveSelect(Math.min(this.select + this.limit, this.suggestions.length - 1));
    this.render();
  }
  prevPage() {
    this.moveSelect(Math.max(this.select - this.limit, 0));
    this.render();
  }
  left() {
    if (this.cursor <= 0) return this.bell();
    this.cursor = this.cursor - 1;
    this.render();
  }
  right() {
    if (this.cursor * this.scale >= this.rendered.length) return this.bell();
    this.cursor = this.cursor + 1;
    this.render();
  }
  renderOption(v, hovered, isStart, isEnd) {
    let desc;
    let prefix = isStart ? figures$1.arrowUp : isEnd ? figures$1.arrowDown : " ";
    let title = hovered ? color$2.cyan().underline(v.title) : v.title;
    prefix = (hovered ? color$2.cyan(figures$1.pointer) + " " : "  ") + prefix;
    if (v.description) {
      desc = ` - ${v.description}`;
      if (prefix.length + title.length + desc.length >= this.out.columns || v.description.split(/\r?\n/).length > 1) {
        desc = "\n" + wrap(v.description, { margin: 3, width: this.out.columns });
      }
    }
    return prefix + " " + title + color$2.gray(desc || "");
  }
  render() {
    if (this.closed) return;
    if (this.firstRender) this.out.write(cursor$2.hide);
    else this.out.write(clear$2(this.outputText, this.out.columns));
    super.render();
    let { startIndex, endIndex } = entriesToDisplay(this.select, this.choices.length, this.limit);
    this.outputText = [
      style$2.symbol(this.done, this.aborted, this.exited),
      color$2.bold(this.msg),
      style$2.delimiter(this.completing),
      this.done && this.suggestions[this.select] ? this.suggestions[this.select].title : this.rendered = this.transform.render(this.input)
    ].join(" ");
    if (!this.done) {
      const suggestions = this.suggestions.slice(startIndex, endIndex).map((item2, i) => this.renderOption(
        item2,
        this.select === i + startIndex,
        i === 0 && startIndex > 0,
        i + startIndex === endIndex - 1 && endIndex < this.choices.length
      )).join("\n");
      this.outputText += `
` + (suggestions || color$2.gray(this.fallback.title));
    }
    this.out.write(erase$1.line + cursor$2.to(0) + this.outputText);
  }
};
var autocomplete = AutocompletePrompt;
var color$1 = kleur;
var { cursor: cursor$1 } = src;
var MultiselectPrompt2 = multiselect;
var { clear: clear$1, style: style$1, figures } = util;
var AutocompleteMultiselectPrompt = class extends MultiselectPrompt2 {
  constructor(opts = {}) {
    opts.overrideRender = true;
    super(opts);
    this.inputValue = "";
    this.clear = clear$1("", this.out.columns);
    this.filteredOptions = this.value;
    this.render();
  }
  last() {
    this.cursor = this.filteredOptions.length - 1;
    this.render();
  }
  next() {
    this.cursor = (this.cursor + 1) % this.filteredOptions.length;
    this.render();
  }
  up() {
    if (this.cursor === 0) {
      this.cursor = this.filteredOptions.length - 1;
    } else {
      this.cursor--;
    }
    this.render();
  }
  down() {
    if (this.cursor === this.filteredOptions.length - 1) {
      this.cursor = 0;
    } else {
      this.cursor++;
    }
    this.render();
  }
  left() {
    this.filteredOptions[this.cursor].selected = false;
    this.render();
  }
  right() {
    if (this.value.filter((e) => e.selected).length >= this.maxChoices) return this.bell();
    this.filteredOptions[this.cursor].selected = true;
    this.render();
  }
  delete() {
    if (this.inputValue.length) {
      this.inputValue = this.inputValue.substr(0, this.inputValue.length - 1);
      this.updateFilteredOptions();
    }
  }
  updateFilteredOptions() {
    const currentHighlight = this.filteredOptions[this.cursor];
    this.filteredOptions = this.value.filter((v) => {
      if (this.inputValue) {
        if (typeof v.title === "string") {
          if (v.title.toLowerCase().includes(this.inputValue.toLowerCase())) {
            return true;
          }
        }
        if (typeof v.value === "string") {
          if (v.value.toLowerCase().includes(this.inputValue.toLowerCase())) {
            return true;
          }
        }
        return false;
      }
      return true;
    });
    const newHighlightIndex = this.filteredOptions.findIndex((v) => v === currentHighlight);
    this.cursor = newHighlightIndex < 0 ? 0 : newHighlightIndex;
    this.render();
  }
  handleSpaceToggle() {
    const v = this.filteredOptions[this.cursor];
    if (v.selected) {
      v.selected = false;
      this.render();
    } else if (v.disabled || this.value.filter((e) => e.selected).length >= this.maxChoices) {
      return this.bell();
    } else {
      v.selected = true;
      this.render();
    }
  }
  handleInputChange(c2) {
    this.inputValue = this.inputValue + c2;
    this.updateFilteredOptions();
  }
  _(c2, key) {
    if (c2 === " ") {
      this.handleSpaceToggle();
    } else {
      this.handleInputChange(c2);
    }
  }
  renderInstructions() {
    if (this.instructions === void 0 || this.instructions) {
      if (typeof this.instructions === "string") {
        return this.instructions;
      }
      return `
Instructions:
    ${figures.arrowUp}/${figures.arrowDown}: Highlight option
    ${figures.arrowLeft}/${figures.arrowRight}/[space]: Toggle selection
    [a,b,c]/delete: Filter choices
    enter/return: Complete answer
`;
    }
    return "";
  }
  renderCurrentInput() {
    return `
Filtered results for: ${this.inputValue ? this.inputValue : color$1.gray("Enter something to filter")}
`;
  }
  renderOption(cursor2, v, i, arrowIndicator) {
    const prefix = (v.selected ? color$1.green(figures.radioOn) : figures.radioOff) + " " + arrowIndicator + " ";
    let title;
    if (v.disabled) title = cursor2 === i ? color$1.gray().underline(v.title) : color$1.strikethrough().gray(v.title);
    else title = cursor2 === i ? color$1.cyan().underline(v.title) : v.title;
    return prefix + title;
  }
  renderDoneOrInstructions() {
    if (this.done) {
      return this.value.filter((e) => e.selected).map((v) => v.title).join(", ");
    }
    const output = [color$1.gray(this.hint), this.renderInstructions(), this.renderCurrentInput()];
    if (this.filteredOptions.length && this.filteredOptions[this.cursor].disabled) {
      output.push(color$1.yellow(this.warn));
    }
    return output.join(" ");
  }
  render() {
    if (this.closed) return;
    if (this.firstRender) this.out.write(cursor$1.hide);
    super.render();
    let prompt2 = [
      style$1.symbol(this.done, this.aborted),
      color$1.bold(this.msg),
      style$1.delimiter(false),
      this.renderDoneOrInstructions()
    ].join(" ");
    if (this.showMinError) {
      prompt2 += color$1.red(`You must select a minimum of ${this.minSelected} choices.`);
      this.showMinError = false;
    }
    prompt2 += this.renderOptions(this.filteredOptions);
    this.out.write(this.clear + prompt2);
    this.clear = clear$1(prompt2, this.out.columns);
  }
};
var autocompleteMultiselect = AutocompleteMultiselectPrompt;
var color = kleur;
var Prompt2 = prompt$1;
var { style, clear } = util;
var { erase, cursor } = src;
var ConfirmPrompt = class extends Prompt2 {
  constructor(opts = {}) {
    super(opts);
    this.msg = opts.message;
    this.value = opts.initial;
    this.initialValue = !!opts.initial;
    this.yesMsg = opts.yes || "yes";
    this.yesOption = opts.yesOption || "(Y/n)";
    this.noMsg = opts.no || "no";
    this.noOption = opts.noOption || "(y/N)";
    this.render();
  }
  reset() {
    this.value = this.initialValue;
    this.fire();
    this.render();
  }
  exit() {
    this.abort();
  }
  abort() {
    this.done = this.aborted = true;
    this.fire();
    this.render();
    this.out.write("\n");
    this.close();
  }
  submit() {
    this.value = this.value || false;
    this.done = true;
    this.aborted = false;
    this.fire();
    this.render();
    this.out.write("\n");
    this.close();
  }
  _(c2, key) {
    if (c2.toLowerCase() === "y") {
      this.value = true;
      return this.submit();
    }
    if (c2.toLowerCase() === "n") {
      this.value = false;
      return this.submit();
    }
    return this.bell();
  }
  render() {
    if (this.closed) return;
    if (this.firstRender) this.out.write(cursor.hide);
    else this.out.write(clear(this.outputText, this.out.columns));
    super.render();
    this.outputText = [
      style.symbol(this.done, this.aborted),
      color.bold(this.msg),
      style.delimiter(this.done),
      this.done ? this.value ? this.yesMsg : this.noMsg : color.gray(this.initialValue ? this.yesOption : this.noOption)
    ].join(" ");
    this.out.write(erase.line + cursor.to(0) + this.outputText);
  }
};
var confirm = ConfirmPrompt;
var elements = {
  TextPrompt: text,
  SelectPrompt: select,
  TogglePrompt: toggle,
  DatePrompt: date,
  NumberPrompt: number,
  MultiselectPrompt: multiselect,
  AutocompletePrompt: autocomplete,
  AutocompleteMultiselectPrompt: autocompleteMultiselect,
  ConfirmPrompt: confirm
};
(function(exports) {
  const $2 = exports;
  const el = elements;
  const noop2 = (v) => v;
  function toPrompt(type, args, opts = {}) {
    return new Promise((res, rej) => {
      const p = new el[type](args);
      const onAbort = opts.onAbort || noop2;
      const onSubmit = opts.onSubmit || noop2;
      const onExit2 = opts.onExit || noop2;
      p.on("state", args.onState || noop2);
      p.on("submit", (x) => res(onSubmit(x)));
      p.on("exit", (x) => res(onExit2(x)));
      p.on("abort", (x) => rej(onAbort(x)));
    });
  }
  $2.text = (args) => toPrompt("TextPrompt", args);
  $2.password = (args) => {
    args.style = "password";
    return $2.text(args);
  };
  $2.invisible = (args) => {
    args.style = "invisible";
    return $2.text(args);
  };
  $2.number = (args) => toPrompt("NumberPrompt", args);
  $2.date = (args) => toPrompt("DatePrompt", args);
  $2.confirm = (args) => toPrompt("ConfirmPrompt", args);
  $2.list = (args) => {
    const sep2 = args.separator || ",";
    return toPrompt("TextPrompt", args, {
      onSubmit: (str) => str.split(sep2).map((s) => s.trim())
    });
  };
  $2.toggle = (args) => toPrompt("TogglePrompt", args);
  $2.select = (args) => toPrompt("SelectPrompt", args);
  $2.multiselect = (args) => {
    args.choices = [].concat(args.choices || []);
    const toSelected = (items) => items.filter((item2) => item2.selected).map((item2) => item2.value);
    return toPrompt("MultiselectPrompt", args, {
      onAbort: toSelected,
      onSubmit: toSelected
    });
  };
  $2.autocompleteMultiselect = (args) => {
    args.choices = [].concat(args.choices || []);
    const toSelected = (items) => items.filter((item2) => item2.selected).map((item2) => item2.value);
    return toPrompt("AutocompleteMultiselectPrompt", args, {
      onAbort: toSelected,
      onSubmit: toSelected
    });
  };
  const byTitle = (input, choices) => Promise.resolve(
    choices.filter((item2) => item2.title.slice(0, input.length).toLowerCase() === input.toLowerCase())
  );
  $2.autocomplete = (args) => {
    args.suggest = args.suggest || byTitle;
    args.choices = [].concat(args.choices || []);
    return toPrompt("AutocompletePrompt", args);
  };
})(prompts$3);
var prompts$2 = prompts$3;
var passOn = ["suggest", "format", "onState", "validate", "onRender", "type"];
var noop = () => {
};
async function prompt(questions = [], { onSubmit = noop, onCancel = noop } = {}) {
  const answers = {};
  const override2 = prompt._override || {};
  questions = [].concat(questions);
  let answer, question, quit, name, type, lastPrompt;
  const getFormattedAnswer = async (question2, answer2, skipValidation = false) => {
    if (!skipValidation && question2.validate && question2.validate(answer2) !== true) {
      return;
    }
    return question2.format ? await question2.format(answer2, answers) : answer2;
  };
  for (question of questions) {
    ({ name, type } = question);
    if (typeof type === "function") {
      type = await type(answer, { ...answers }, question);
      question["type"] = type;
    }
    if (!type) continue;
    for (let key in question) {
      if (passOn.includes(key)) continue;
      let value = question[key];
      question[key] = typeof value === "function" ? await value(answer, { ...answers }, lastPrompt) : value;
    }
    lastPrompt = question;
    if (typeof question.message !== "string") {
      throw new Error("prompt message is required");
    }
    ({ name, type } = question);
    if (prompts$2[type] === void 0) {
      throw new Error(`prompt type (${type}) is not defined`);
    }
    if (override2[question.name] !== void 0) {
      answer = await getFormattedAnswer(question, override2[question.name]);
      if (answer !== void 0) {
        answers[name] = answer;
        continue;
      }
    }
    try {
      answer = prompt._injected ? getInjectedAnswer(prompt._injected, question.initial) : await prompts$2[type](question);
      answers[name] = answer = await getFormattedAnswer(question, answer, true);
      quit = await onSubmit(question, answer, answers);
    } catch (err) {
      quit = !await onCancel(question, answers);
    }
    if (quit) return answers;
  }
  return answers;
}
function getInjectedAnswer(injected, deafultValue) {
  const answer = injected.shift();
  if (answer instanceof Error) {
    throw answer;
  }
  return answer === void 0 ? deafultValue : answer;
}
function inject(answers) {
  prompt._injected = (prompt._injected || []).concat(answers);
}
function override(answers) {
  prompt._override = Object.assign({}, answers);
}
var lib$1 = Object.assign(prompt, { prompt, prompts: prompts$2, inject, override });
var prompts = lib$1;
var prompts$1 = /* @__PURE__ */ getDefaultExportFromCjs(prompts);
var cjs = {};
var posix$1 = {};
Object.defineProperty(posix$1, "__esModule", { value: true });
posix$1.sync = posix$1.isexe = void 0;
var fs_1$1 = import_fs2.default;
var promises_1$1 = import_promises2.default;
var isexe$2 = async (path2, options2 = {}) => {
  const { ignoreErrors = false } = options2;
  try {
    return checkStat$1(await (0, promises_1$1.stat)(path2), options2);
  } catch (e) {
    const er = e;
    if (ignoreErrors || er.code === "EACCES")
      return false;
    throw er;
  }
};
posix$1.isexe = isexe$2;
var sync$1 = (path2, options2 = {}) => {
  const { ignoreErrors = false } = options2;
  try {
    return checkStat$1((0, fs_1$1.statSync)(path2), options2);
  } catch (e) {
    const er = e;
    if (ignoreErrors || er.code === "EACCES")
      return false;
    throw er;
  }
};
posix$1.sync = sync$1;
var checkStat$1 = (stat, options2) => stat.isFile() && checkMode(stat, options2);
var checkMode = (stat, options2) => {
  const myUid = options2.uid ?? process.getuid?.();
  const myGroups = options2.groups ?? process.getgroups?.() ?? [];
  const myGid = options2.gid ?? process.getgid?.() ?? myGroups[0];
  if (myUid === void 0 || myGid === void 0) {
    throw new Error("cannot get uid or gid");
  }
  const groups = /* @__PURE__ */ new Set([myGid, ...myGroups]);
  const mod = stat.mode;
  const uid = stat.uid;
  const gid = stat.gid;
  const u = parseInt("100", 8);
  const g = parseInt("010", 8);
  const o = parseInt("001", 8);
  const ug = u | g;
  return !!(mod & o || mod & g && groups.has(gid) || mod & u && uid === myUid || mod & ug && myUid === 0);
};
var win32 = {};
Object.defineProperty(win32, "__esModule", { value: true });
win32.sync = win32.isexe = void 0;
var fs_1 = import_fs2.default;
var promises_1 = import_promises2.default;
var isexe$1 = async (path2, options2 = {}) => {
  const { ignoreErrors = false } = options2;
  try {
    return checkStat(await (0, promises_1.stat)(path2), path2, options2);
  } catch (e) {
    const er = e;
    if (ignoreErrors || er.code === "EACCES")
      return false;
    throw er;
  }
};
win32.isexe = isexe$1;
var sync = (path2, options2 = {}) => {
  const { ignoreErrors = false } = options2;
  try {
    return checkStat((0, fs_1.statSync)(path2), path2, options2);
  } catch (e) {
    const er = e;
    if (ignoreErrors || er.code === "EACCES")
      return false;
    throw er;
  }
};
win32.sync = sync;
var checkPathExt = (path2, options2) => {
  const { pathExt = process.env.PATHEXT || "" } = options2;
  const peSplit = pathExt.split(";");
  if (peSplit.indexOf("") !== -1) {
    return true;
  }
  for (let i = 0; i < peSplit.length; i++) {
    const p = peSplit[i].toLowerCase();
    const ext = path2.substring(path2.length - p.length).toLowerCase();
    if (p && ext === p) {
      return true;
    }
  }
  return false;
};
var checkStat = (stat, path2, options2) => stat.isFile() && checkPathExt(path2, options2);
var options = {};
Object.defineProperty(options, "__esModule", { value: true });
(function(exports) {
  var __createBinding = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === void 0) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() {
        return m[k];
      } };
    }
    Object.defineProperty(o, k2, desc);
  } : function(o, m, k, k2) {
    if (k2 === void 0) k2 = k;
    o[k2] = m[k];
  });
  var __setModuleDefault = commonjsGlobal && commonjsGlobal.__setModuleDefault || (Object.create ? function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
  } : function(o, v) {
    o["default"] = v;
  });
  var __importStar = commonjsGlobal && commonjsGlobal.__importStar || function(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) {
      for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    }
    __setModuleDefault(result, mod);
    return result;
  };
  var __exportStar = commonjsGlobal && commonjsGlobal.__exportStar || function(m, exports2) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p)) __createBinding(exports2, m, p);
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.sync = exports.isexe = exports.posix = exports.win32 = void 0;
  const posix2 = __importStar(posix$1);
  exports.posix = posix2;
  const win32$1 = __importStar(win32);
  exports.win32 = win32$1;
  __exportStar(options, exports);
  const platform = process.env._ISEXE_TEST_PLATFORM_ || process.platform;
  const impl = platform === "win32" ? win32$1 : posix2;
  exports.isexe = impl.isexe;
  exports.sync = impl.sync;
})(cjs);
var { isexe, sync: isexeSync } = cjs;
var { join, delimiter, sep, posix } = import_path2.default;
var isWindows = process.platform === "win32";
var rSlash = new RegExp(`[${posix.sep}${sep === posix.sep ? "" : sep}]`.replace(/(\\)/g, "\\$1"));
var rRel = new RegExp(`^\\.${rSlash.source}`);
var getNotFoundError = (cmd) => Object.assign(new Error(`not found: ${cmd}`), { code: "ENOENT" });
var getPathInfo = (cmd, {
  path: optPath = process.env.PATH,
  pathExt: optPathExt = process.env.PATHEXT,
  delimiter: optDelimiter = delimiter
}) => {
  const pathEnv = cmd.match(rSlash) ? [""] : [
    // windows always checks the cwd first
    ...isWindows ? [process.cwd()] : [],
    ...(optPath || /* istanbul ignore next: very unusual */
    "").split(optDelimiter)
  ];
  if (isWindows) {
    const pathExtExe = optPathExt || [".EXE", ".CMD", ".BAT", ".COM"].join(optDelimiter);
    const pathExt = pathExtExe.split(optDelimiter).flatMap((item2) => [item2, item2.toLowerCase()]);
    if (cmd.includes(".") && pathExt[0] !== "") {
      pathExt.unshift("");
    }
    return { pathEnv, pathExt, pathExtExe };
  }
  return { pathEnv, pathExt: [""] };
};
var getPathPart = (raw, cmd) => {
  const pathPart = /^".*"$/.test(raw) ? raw.slice(1, -1) : raw;
  const prefix = !pathPart && rRel.test(cmd) ? cmd.slice(0, 2) : "";
  return prefix + join(pathPart, cmd);
};
var which = async (cmd, opt = {}) => {
  const { pathEnv, pathExt, pathExtExe } = getPathInfo(cmd, opt);
  const found = [];
  for (const envPart of pathEnv) {
    const p = getPathPart(envPart, cmd);
    for (const ext of pathExt) {
      const withExt = p + ext;
      const is = await isexe(withExt, { pathExt: pathExtExe, ignoreErrors: true });
      if (is) {
        if (!opt.all) {
          return withExt;
        }
        found.push(withExt);
      }
    }
  }
  if (opt.all && found.length) {
    return found;
  }
  if (opt.nothrow) {
    return null;
  }
  throw getNotFoundError(cmd);
};
var whichSync = (cmd, opt = {}) => {
  const { pathEnv, pathExt, pathExtExe } = getPathInfo(cmd, opt);
  const found = [];
  for (const pathEnvPart of pathEnv) {
    const p = getPathPart(pathEnvPart, cmd);
    for (const ext of pathExt) {
      const withExt = p + ext;
      const is = isexeSync(withExt, { pathExt: pathExtExe, ignoreErrors: true });
      if (is) {
        if (!opt.all) {
          return withExt;
        }
        found.push(withExt);
      }
    }
  }
  if (opt.all && found.length) {
    return found;
  }
  if (opt.nothrow) {
    return null;
  }
  throw getNotFoundError(cmd);
};
var lib = which;
which.sync = whichSync;
var which$1 = /* @__PURE__ */ getDefaultExportFromCjs(lib);
var CLI_TEMP_DIR = (0, import_path.join)(import_os.default.tmpdir(), "antfu-ni");
function cmdExists(cmd) {
  return which$1.sync(cmd, { nothrow: true }) !== null;
}
async function detect({ autoInstall, programmatic, cwd } = {}) {
  let agent = null;
  let version = null;
  const lockPath = await findUp(Object.keys(LOCKS), { cwd });
  let packageJsonPath;
  if (lockPath)
    packageJsonPath = import_path.default.resolve(lockPath, "../package.json");
  else
    packageJsonPath = await findUp("package.json", { cwd });
  if (packageJsonPath && import_fs.default.existsSync(packageJsonPath)) {
    try {
      const pkg = JSON.parse(import_fs.default.readFileSync(packageJsonPath, "utf8"));
      if (typeof pkg.packageManager === "string") {
        const [name, ver] = pkg.packageManager.replace(/^\^/, "").split("@");
        version = ver;
        if (name === "yarn" && Number.parseInt(ver) > 1) {
          agent = "yarn@berry";
          version = "berry";
        } else if (name === "pnpm" && Number.parseInt(ver) < 7) {
          agent = "pnpm@6";
        } else if (name in AGENTS) {
          agent = name;
        } else if (!programmatic) {
          console.warn("[ni] Unknown packageManager:", pkg.packageManager);
        }
      }
    } catch {
    }
  }
  if (!agent && lockPath)
    agent = LOCKS[import_path.default.basename(lockPath)];
  if (agent && !cmdExists(agent.split("@")[0]) && !programmatic) {
    if (!autoInstall) {
      console.warn(`[ni] Detected ${agent} but it doesn't seem to be installed.
`);
      if (import_process.default.env.CI)
        import_process.default.exit(1);
      const link = terminalLink(agent, INSTALL_PAGE[agent]);
      const { tryInstall } = await prompts$1({
        name: "tryInstall",
        type: "confirm",
        message: `Would you like to globally install ${link}?`
      });
      if (!tryInstall)
        import_process.default.exit(1);
    }
    await execaCommand(`npm i -g ${agent.split("@")[0]}${version ? `@${version}` : ""}`, { stdio: "inherit", cwd });
  }
  return agent;
}
var customRcPath = import_process.default.env.NI_CONFIG_FILE;
var home = import_process.default.platform === "win32" ? import_process.default.env.USERPROFILE : import_process.default.env.HOME;
var defaultRcPath = import_path.default.join(home || "~/", ".nirc");
var UnsupportedCommand = class extends Error {
  constructor({ agent, command }) {
    super(`Command "${command}" is not support by agent "${agent}"`);
  }
};
function getCommand(agent, command, args = []) {
  if (!(agent in AGENTS))
    throw new Error(`Unsupported agent "${agent}"`);
  const c2 = AGENTS[agent][command];
  if (typeof c2 === "function")
    return c2(args);
  if (!c2)
    throw new UnsupportedCommand({ agent, command });
  const quote = (arg) => !arg.startsWith("--") && arg.includes(" ") ? JSON.stringify(arg) : arg;
  return c2.replace("{0}", args.map(quote).join(" ")).trim();
}
var FORCE_COLOR;
var NODE_DISABLE_COLORS;
var NO_COLOR;
var TERM;
var isTTY = true;
if (typeof process !== "undefined") {
  ({ FORCE_COLOR, NODE_DISABLE_COLORS, NO_COLOR, TERM } = process.env || {});
  isTTY = process.stdout && process.stdout.isTTY;
}
var $ = {
  enabled: !NODE_DISABLE_COLORS && NO_COLOR == null && TERM !== "dumb" && (FORCE_COLOR != null && FORCE_COLOR !== "0" || isTTY),
  // modifiers
  reset: init(0, 0),
  bold: init(1, 22),
  dim: init(2, 22),
  italic: init(3, 23),
  underline: init(4, 24),
  inverse: init(7, 27),
  hidden: init(8, 28),
  strikethrough: init(9, 29),
  // colors
  black: init(30, 39),
  red: init(31, 39),
  green: init(32, 39),
  yellow: init(33, 39),
  blue: init(34, 39),
  magenta: init(35, 39),
  cyan: init(36, 39),
  white: init(37, 39),
  gray: init(90, 39),
  grey: init(90, 39),
  // background colors
  bgBlack: init(40, 49),
  bgRed: init(41, 49),
  bgGreen: init(42, 49),
  bgYellow: init(43, 49),
  bgBlue: init(44, 49),
  bgMagenta: init(45, 49),
  bgCyan: init(46, 49),
  bgWhite: init(47, 49)
};
function run$1(arr, str) {
  let i = 0, tmp, beg = "", end = "";
  for (; i < arr.length; i++) {
    tmp = arr[i];
    beg += tmp.open;
    end += tmp.close;
    if (!!~str.indexOf(tmp.close)) {
      str = str.replace(tmp.rgx, tmp.close + tmp.open);
    }
  }
  return beg + str + end;
}
function chain(has, keys) {
  let ctx = { has, keys };
  ctx.reset = $.reset.bind(ctx);
  ctx.bold = $.bold.bind(ctx);
  ctx.dim = $.dim.bind(ctx);
  ctx.italic = $.italic.bind(ctx);
  ctx.underline = $.underline.bind(ctx);
  ctx.inverse = $.inverse.bind(ctx);
  ctx.hidden = $.hidden.bind(ctx);
  ctx.strikethrough = $.strikethrough.bind(ctx);
  ctx.black = $.black.bind(ctx);
  ctx.red = $.red.bind(ctx);
  ctx.green = $.green.bind(ctx);
  ctx.yellow = $.yellow.bind(ctx);
  ctx.blue = $.blue.bind(ctx);
  ctx.magenta = $.magenta.bind(ctx);
  ctx.cyan = $.cyan.bind(ctx);
  ctx.white = $.white.bind(ctx);
  ctx.gray = $.gray.bind(ctx);
  ctx.grey = $.grey.bind(ctx);
  ctx.bgBlack = $.bgBlack.bind(ctx);
  ctx.bgRed = $.bgRed.bind(ctx);
  ctx.bgGreen = $.bgGreen.bind(ctx);
  ctx.bgYellow = $.bgYellow.bind(ctx);
  ctx.bgBlue = $.bgBlue.bind(ctx);
  ctx.bgMagenta = $.bgMagenta.bind(ctx);
  ctx.bgCyan = $.bgCyan.bind(ctx);
  ctx.bgWhite = $.bgWhite.bind(ctx);
  return ctx;
}
function init(open, close) {
  let blk = {
    open: `\x1B[${open}m`,
    close: `\x1B[${close}m`,
    rgx: new RegExp(`\\x1b\\[${close}m`, "g")
  };
  return function(txt) {
    if (this !== void 0 && this.has !== void 0) {
      !!~this.has.indexOf(open) || (this.has.push(open), this.keys.push(blk));
      return txt === void 0 ? this : $.enabled ? run$1(this.keys, txt + "") : txt + "";
    }
    return txt === void 0 ? chain([open], [blk]) : $.enabled ? run$1([blk], txt + "") : txt + "";
  };
}
