"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var chunk_YRBRUREX_exports = {};
__export(chunk_YRBRUREX_exports, {
  debugMultipleSchemaPaths: () => debugMultipleSchemaPaths,
  debugMultipleSchemas: () => debugMultipleSchemas,
  extractSchemaContent: () => extractSchemaContent,
  schemaToStringDebug: () => schemaToStringDebug,
  toMultipleSchemas: () => toMultipleSchemas
});
module.exports = __toCommonJS(chunk_YRBRUREX_exports);
var schemaToStringDebug = (schemaFileInput) => {
  if (schemaFileInput === void 0) {
    return void 0;
  }
  if (typeof schemaFileInput === "string") {
    return schemaFileInput;
  }
  if (Array.isArray(schemaFileInput)) {
    return debugMultipleSchemas(schemaFileInput);
  }
  return String(schemaFileInput);
};
function toMultipleSchemas(input) {
  if (typeof input === "undefined") {
    return void 0;
  }
  if (typeof input === "string") {
    return [["schema.prisma", input]];
  }
  return input;
}
function debugMultipleSchemas(multipleSchemas) {
  return multipleSchemas.map(([, content]) => content).join("\n/* - newfile - */");
}
function debugMultipleSchemaPaths(multipleSchemas) {
  return multipleSchemas.map(([filename]) => filename).join(",\n");
}
function extractSchemaContent(multipleSchemas) {
  return multipleSchemas.map(([, content]) => content);
}
