"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM2 = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var chunk_Z2NHAREC_exports = {};
__export(chunk_Z2NHAREC_exports, {
  BinaryType: () => import_fetch_engine.BinaryType,
  engineEnvVarMap: () => import_fetch_engine.engineEnvVarMap,
  maybeCopyToTmp: () => maybeCopyToTmp,
  resolveBinary: () => resolveBinary,
  safeResolveBinary: () => safeResolveBinary
});
module.exports = __toCommonJS(chunk_Z2NHAREC_exports);
var import_chunk_RQPDQSHK = require("./chunk-RQPDQSHK.js");
var import_chunk_M3GBKLGE = require("./chunk-M3GBKLGE.js");
var import_chunk_TWSLDIFL = require("./chunk-TWSLDIFL.js");
var import_chunk_JM6ICT4D = require("./chunk-JM6ICT4D.js");
var import_chunk_TZCE3PWZ = require("./chunk-TZCE3PWZ.js");
var import_chunk_WWAWV7DQ = require("./chunk-WWAWV7DQ.js");
var import_engines = require("@prisma/engines");
var import_fetch_engine = require("@prisma/fetch-engine");
var import_get_platform = require("@prisma/get-platform");
var import_fs = __toESM2(require("fs"));
var import_path = __toESM2(require("path"));
var import_fs_extra = (0, import_chunk_WWAWV7DQ.__toESM)((0, import_chunk_RQPDQSHK.require_lib)());
var import_temp_dir = (0, import_chunk_WWAWV7DQ.__toESM)((0, import_chunk_TZCE3PWZ.require_temp_dir)());
async function getBinaryName(name) {
  const binaryTarget = await (0, import_get_platform.getBinaryTargetForCurrentPlatform)();
  const extension = binaryTarget === "windows" ? ".exe" : "";
  if (name === import_fetch_engine.BinaryType.QueryEngineLibrary) {
    return (0, import_get_platform.getNodeAPIName)(binaryTarget, "fs");
  }
  return `${name}-${binaryTarget}${extension}`;
}
async function resolveBinary(name, proposedPath) {
  if (proposedPath && !proposedPath.match(import_chunk_M3GBKLGE.vercelPkgPathRegex) && import_fs.default.existsSync(proposedPath)) {
    return proposedPath;
  }
  const pathFromEnvVar = (0, import_fetch_engine.getBinaryEnvVarPath)(name);
  if (pathFromEnvVar !== null) {
    return pathFromEnvVar.path;
  }
  const binaryName = await getBinaryName(name);
  const prismaPath = import_path.default.join((0, import_engines.getEnginesPath)(), binaryName);
  if (import_fs.default.existsSync(prismaPath)) {
    return maybeCopyToTmp(prismaPath);
  }
  const prismaPath2 = import_path.default.join(__dirname, "..", binaryName);
  if (import_fs.default.existsSync(prismaPath2)) {
    return maybeCopyToTmp(prismaPath2);
  }
  const prismaPath3 = import_path.default.join(__dirname, "../..", binaryName);
  if (import_fs.default.existsSync(prismaPath3)) {
    return maybeCopyToTmp(prismaPath3);
  }
  const prismaPath4 = import_path.default.join(__dirname, "../runtime", binaryName);
  if (import_fs.default.existsSync(prismaPath4)) {
    return maybeCopyToTmp(prismaPath4);
  }
  throw new Error(
    `Could not find ${name} binary. Searched in:
- ${prismaPath}
- ${prismaPath2}
- ${prismaPath3}
- ${prismaPath4}`
  );
}
function safeResolveBinary(name, proposedPath) {
  return (0, import_chunk_JM6ICT4D.tryCatch2)(
    () => resolveBinary(name, proposedPath),
    (error) => error
  );
}
async function maybeCopyToTmp(file) {
  const dir = eval("__dirname");
  if (dir.match(import_chunk_M3GBKLGE.vercelPkgPathRegex)) {
    const targetDir = import_path.default.join(import_temp_dir.default, "prisma-binaries");
    await (0, import_fs_extra.ensureDir)(targetDir);
    const target = import_path.default.join(targetDir, import_path.default.basename(file));
    const data = await import_fs.default.promises.readFile(file);
    await import_fs.default.promises.writeFile(target, data);
    (0, import_chunk_TWSLDIFL.chmodPlusX)(target);
    return target;
  }
  return file;
}
