import { type MultipleSchemas } from '../utils/schemaFileInput';
type FormatSchemaParams = {
    schemas: MultipleSchemas;
};
export declare function formatSchema({ schemas }: FormatSchemaParams, inputFormattingOptions?: Partial<DocumentFormattingParams['options']>): Promise<MultipleSchemas>;
type DocumentUri = string;
type TextDocument = {
    /**
     * The associated URI for this document. Most documents have the __file__-scheme, indicating that they
     * represent files on disk. However, some documents may have other schemes indicating that they are not
     * available on disk.
     */
    readonly uri: DocumentUri;
};
type DocumentFormattingParams = {
    textDocument: TextDocument;
    options: {
        tabSize: number;
        insertSpaces: boolean;
    };
};
export {};
