import { BinaryType } from '@prisma/fetch-engine';
import * as E from 'fp-ts/Either';
import * as O from 'fp-ts/Option';
/**
 * Both an engine binary and a library might be resolved from and environment variable indicating a path.
 * We first try to retrieve the engines' path from an env var; if it fails, we fall back to `safeResolveBinary`.
 * If both fail, we return an error.
 * Even if we resolve a path, retrieving the version might fail.
 */
export type EngineInfo = {
    fromEnvVar: O.Option<string>;
    path: E.Either<Error, string>;
    version: E.Either<Error, string>;
};
export type BinaryMatrix<T> = {
    'query-engine': T;
    'schema-engine': T;
};
export type BinaryInfoMatrix = BinaryMatrix<EngineInfo>;
export declare function getEnginesMetaInfo(): Promise<readonly [{
    'query-engine': string;
    'schema-engine': string;
}[], Error[]]>;
export declare function getEnginesInfo(enginesInfo: EngineInfo): readonly [string, Error[]];
export declare function resolveEngine(binaryName: BinaryType): Promise<EngineInfo>;
