import { type MultipleSchemas } from '../utils/schemaFileInput';
type LintSchemaParams = {
    schemas: MultipleSchemas;
};
type LintDiagnosticBase = {
    start: number;
    end: number;
    text: string;
};
export type LintWarning = {
    is_warning: true;
} & LintDiagnosticBase;
export type LintError = {
    is_warning: false;
} & LintDiagnosticBase;
export type LintDiagnostic = LintWarning | LintError;
/**
 * Diagnose the given schema, returning a list either errors or warnings.
 * This function may panic, but it won't throw any standard error.
 */
export declare function lintSchema({ schemas }: LintSchemaParams): LintDiagnostic[];
export declare function handleLintPanic<T>(tryCb: () => T, { schemas }: LintSchemaParams): T;
export declare function getLintWarnings(lintDiagnostics: LintDiagnostic[]): LintWarning[];
export declare function getLintWarningsAsText(lintDiagnostics: LintDiagnostic[]): string;
export declare function warningToString(warning: LintDiagnostic): string;
export {};
