export declare namespace MigrateTypes {
    type SchemaContainer = {
        path: string;
        content: string;
    };
    type SchemasContainer = {
        files: SchemaContainer[];
    };
    type SchemasWithConfigDir = {
        files: SchemaContainer[];
        configDir: string;
    };
    type UrlContainer = {
        url: string;
    };
    type DatasourceParam = Tagged<'ConnectionString', UrlContainer> | Tagged<'Schema', SchemasContainer>;
    type GetDatabaseVersionParams = {
        datasource: MigrateTypes.DatasourceParam;
    };
    type Tagged<Tag extends string, T> = Display<{
        tag: Tag;
    } & T>;
    type Display<T> = {
        [K in keyof T]: T[K];
    } & unknown;
}
