"use strict";
var import_chunk_ICFLO5JW = require("../../chunk-ICFLO5JW.js");
var import_chunk_WWAWV7DQ = require("../../chunk-WWAWV7DQ.js");
var originalEnv = { ...process.env };
describe("isInteractive", () => {
  beforeEach(() => {
    process.env = { ...originalEnv };
  });
  afterAll(() => {
    process.env = { ...originalEnv };
  });
  describe("in non TTY environment", () => {
    const mockedValue = { isTTY: false };
    test("isInteractive should be false", () => {
      expect((0, import_chunk_ICFLO5JW.isInteractive)({ stream: mockedValue })).toBe(false);
    });
    test("isInteractive should be false if TERM = dumb", () => {
      process.env.TERM = "dumb";
      expect((0, import_chunk_ICFLO5JW.isInteractive)({ stream: mockedValue })).toBe(false);
    });
  });
  describe("in TTY environment", () => {
    const mockedValue = { isTTY: true };
    test("isInteractive should be true", () => {
      expect((0, import_chunk_ICFLO5JW.isInteractive)({ stream: mockedValue })).toBe(true);
    });
    test("isInteractive should be false if TERM = dumb", () => {
      process.env.TERM = "dumb";
      expect((0, import_chunk_ICFLO5JW.isInteractive)({ stream: mockedValue })).toBe(false);
    });
  });
});
