"use strict";
var import_chunk_KDHESRKE = require("../../chunk-KDHESRKE.js");
var import_chunk_WWAWV7DQ = require("../../chunk-WWAWV7DQ.js");
test("maskSchema", () => {
  const schema = `datasource db {
    url = "mysql:secret-db"
  }`;
  expect((0, import_chunk_KDHESRKE.maskSchema)(schema)).toMatchInlineSnapshot(`
    "datasource db {
        url = "***"
      }"
  `);
  const schema2 = `datasource db {
    provider = "mysql"
    url = env("SOME_ENV")
  }`;
  expect((0, import_chunk_KDHESRKE.maskSchema)(schema2)).toMatchInlineSnapshot(`
    "datasource db {
        provider = "mysql"
        url = "***"
      }"
  `);
});
