"use strict";
var import_chunk_CGFNDGGI = require("../chunk-CGFNDGGI.js");
var import_chunk_WWAWV7DQ = require("../chunk-WWAWV7DQ.js");
describe("maxWithComparator", () => {
  test("empty array", () => {
    expect((0, import_chunk_CGFNDGGI.maxWithComparator)([], () => 0)).toBe(void 0);
  });
  test("with items", () => {
    const items = [{ count: 1 }, { count: 10 }, { count: 5 }];
    expect((0, import_chunk_CGFNDGGI.maxWithComparator)(items, (a, b) => a.count - b.count)).toBe(items[1]);
  });
});
describe("maxBy", () => {
  test("empty array", () => {
    expect((0, import_chunk_CGFNDGGI.maxBy)([], () => 1)).toBe(void 0);
  });
  test("with items", () => {
    const items = [{ count: 1 }, { count: 10 }, { count: 5 }];
    expect((0, import_chunk_CGFNDGGI.maxBy)(items, (item) => item.count)).toBe(items[1]);
  });
});
