import type { BinaryTargetsEnvValue, EnvValue } from '@prisma/generator-helper';
/**
 * Parses an EnvValue (example: Provider) and return the string value
 *
 * - If there is no env var just return the value
 * - If there is an env var it will be resolve and returned.
 * - If there is an env var is present but can't be resolved an error will be thrown
 */
export declare function parseEnvValue(object: EnvValue): string;
/**
 * Parses the BinaryTargetsEnvValue and return the string value
 *
 * - If there is no env var just return the value
 * - If there is an env var it will be resolve and returned.
 * - If there is an env var is present but can't be resolved an error will be thrown
 */
export declare function parseBinaryTargetsEnvValue(object: BinaryTargetsEnvValue): string[] | string;
