"use strict";
var import_chunk_J77ZIDXB = require("../chunk-J77ZIDXB.js");
var import_chunk_WWAWV7DQ = require("../chunk-WWAWV7DQ.js");
var testIf = (condition) => condition ? test : test.skip;
var describeIf = (condition) => condition ? describe : describe.skip;
describe("pathToPosix", () => {
  test("forward slashes", () => {
    expect((0, import_chunk_J77ZIDXB.pathToPosix)("a/b/c")).toBe("a/b/c");
  });
  testIf(process.platform === "win32")("backslashes on windows", () => {
    expect((0, import_chunk_J77ZIDXB.pathToPosix)("a\\b\\c")).toBe("a/b/c");
  });
  testIf(process.platform !== "win32")("backslashes on posix", () => {
    expect((0, import_chunk_J77ZIDXB.pathToPosix)("a\\b\\c")).toBe("a\\b\\c");
  });
});
describe("longestCommonPathPrefix", () => {
  describeIf(process.platform !== "win32")("posix", () => {
    test("common ancestor directory", () => {
      expect((0, import_chunk_J77ZIDXB.longestCommonPathPrefix)("/usr/lib/libprisma.so", "/usr/bin/prisma")).toBe("/usr");
    });
    test("common ancestor is root", () => {
      expect((0, import_chunk_J77ZIDXB.longestCommonPathPrefix)("/usr/bin/prisma", "/home/prisma")).toBe("/");
    });
    test("common ancestor is the path itself", () => {
      expect((0, import_chunk_J77ZIDXB.longestCommonPathPrefix)("/home/prisma", "/home/prisma")).toBe("/home/prisma");
    });
    test("substring is not treated as a path component", () => {
      expect((0, import_chunk_J77ZIDXB.longestCommonPathPrefix)("/prisma", "/pri")).toBe("/");
    });
  });
  describeIf(process.platform === "win32")("windows", () => {
    test("common ancestor directory", () => {
      expect((0, import_chunk_J77ZIDXB.longestCommonPathPrefix)("C:\\Common\\A\\Prisma", "C:\\Common\\B\\Prisma")).toBe("C:\\Common");
    });
    test("common ancestor is disk", () => {
      expect((0, import_chunk_J77ZIDXB.longestCommonPathPrefix)("C:\\A\\Prisma", "C:\\B\\Prisma")).toBe("C:\\");
    });
    test("substring is not treated as a path component", () => {
      expect((0, import_chunk_J77ZIDXB.longestCommonPathPrefix)("C:\\Prisma", "C:\\Pri")).toBe("C:\\");
    });
    test("namespaced path works", () => {
      expect((0, import_chunk_J77ZIDXB.longestCommonPathPrefix)("C:\\Common\\A\\Prisma", "\\\\?\\C:\\Common\\B\\Prisma")).toBe("\\\\?\\C:\\Common");
    });
    test("different disks", () => {
      expect((0, import_chunk_J77ZIDXB.longestCommonPathPrefix)("C:\\Prisma", "D:\\Prisma")).toBeUndefined();
      expect((0, import_chunk_J77ZIDXB.longestCommonPathPrefix)("\\\\?\\C:\\Prisma", "\\\\?\\D:\\Prisma")).toBeUndefined();
    });
    test("different namespaces", () => {
      expect((0, import_chunk_J77ZIDXB.longestCommonPathPrefix)("\\\\?\\C:\\Prisma", "\\\\.\\COM1")).toBeUndefined();
    });
  });
});
