"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystemStoredFile = void 0;
const StoredFile_1 = require("./StoredFile");
const mkdirp_1 = __importDefault(require("mkdirp"));
const path_1 = __importDefault(require("path"));
const fs = __importStar(require("fs"));
const uid_1 = require("uid");
const class_transformer_1 = require("class-transformer");
class FileSystemStoredFile extends StoredFile_1.StoredFile {
    static async create(busboyFileMeta, stream, config) {
        await mkdirp_1.default.native(config.fileSystemStoragePath);
        const filePath = path_1.default.resolve(config.fileSystemStoragePath, FileSystemStoredFile.makeFileNameWithSalt(busboyFileMeta.originalName));
        return new Promise((res, rej) => {
            const outStream = fs.createWriteStream(filePath);
            let size = 0;
            stream.on('data', (chunk) => size += chunk.length);
            outStream.on('error', rej);
            outStream.on('finish', () => {
                const file = (0, class_transformer_1.plainToClass)(FileSystemStoredFile, {
                    originalName: busboyFileMeta.originalName,
                    encoding: busboyFileMeta.encoding,
                    busBoyMimeType: busboyFileMeta.mimetype,
                    path: filePath,
                    size,
                });
                res(file);
            });
            stream.pipe(outStream);
        });
    }
    static makeFileNameWithSalt(originalName) {
        const parsed = path_1.default.parse(originalName);
        return `${parsed.name}-${(0, uid_1.uid)(6)}${parsed.ext}`;
    }
    delete() {
        return new Promise((resolve, reject) => {
            fs.unlink(this.path, (err) => {
                if (err && err.code !== 'ENOENT') {
                    return reject(err);
                }
                resolve();
            });
        });
    }
}
exports.FileSystemStoredFile = FileSystemStoredFile;
//# sourceMappingURL=FileSystemStoredFile.js.map