"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoryStoredFile = void 0;
const StoredFile_1 = require("./StoredFile");
const concat_stream_1 = __importDefault(require("concat-stream"));
const class_transformer_1 = require("class-transformer");
class MemoryStoredFile extends StoredFile_1.StoredFile {
    static create(busboyFileMeta, stream, config) {
        return new Promise((res, rej) => {
            stream.pipe((0, concat_stream_1.default)({ encoding: 'buffer' }, (buffer) => {
                const file = (0, class_transformer_1.plainToClass)(MemoryStoredFile, {
                    originalName: busboyFileMeta.originalName,
                    encoding: busboyFileMeta.encoding,
                    busBoyMimeType: busboyFileMeta.mimetype,
                    buffer,
                    size: buffer.length,
                });
                res(file);
            }));
        });
    }
    delete() {
        return Promise.resolve(undefined);
    }
}
exports.MemoryStoredFile = MemoryStoredFile;
//# sourceMappingURL=MemoryStoredFile.js.map