/// <reference types="node" />
import { ParticleStoredFile } from '../../interfaces/ParticleStoredFile';
import { FormDataInterceptorConfig, MetaFieldSource } from '../../interfaces';
import { Readable as ReadableStream } from 'stream';
import { FileTypeResult } from 'file-type/core';
export declare abstract class StoredFile implements ParticleStoredFile {
    encoding: string;
    originalName: string;
    abstract size: number;
    protected busBoyMimeType: string;
    protected fileType: FileTypeResult;
    static create(busboyFileMeta: ParticleStoredFile, stream: ReadableStream, config: FormDataInterceptorConfig): Promise<StoredFile>;
    setFileTypeResult(fileType: FileTypeResult): void;
    get mimeType(): string;
    get mimetype(): string;
    get extension(): string;
    get mimeTypeWithSource(): MetaFieldSource;
    get extensionWithSource(): MetaFieldSource;
    abstract delete(): Promise<void>;
}
//# sourceMappingURL=StoredFile.d.ts.map