"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoredFile = void 0;
const interfaces_1 = require("../../interfaces");
const path_1 = __importDefault(require("path"));
class StoredFile {
    static create(busboyFileMeta, stream, config) {
        throw new Error(`Static method create must be implemented`);
    }
    ;
    setFileTypeResult(fileType) {
        this.fileType = fileType;
    }
    get mimeType() {
        var _a;
        return ((_a = this.fileType) === null || _a === void 0 ? void 0 : _a.mime) || this.busBoyMimeType;
    }
    // Compatibility with previous versions
    get mimetype() {
        return this.mimeType;
    }
    get extension() {
        var _a;
        return ((_a = this.fileType) === null || _a === void 0 ? void 0 : _a.ext) || (path_1.default.parse(this.originalName).ext || '').replace('.', '');
    }
    get mimeTypeWithSource() {
        var _a;
        const value = this.mimeType;
        const source = (!!((_a = this.fileType) === null || _a === void 0 ? void 0 : _a.mime)) ? interfaces_1.MetaSource.bufferMagicNumber : interfaces_1.MetaSource.contentType;
        return { value, source };
    }
    get extensionWithSource() {
        var _a;
        const value = this.extension;
        const source = (!!((_a = this.fileType) === null || _a === void 0 ? void 0 : _a.ext)) ? interfaces_1.MetaSource.bufferMagicNumber : interfaces_1.MetaSource.contentType;
        return { value, source };
    }
}
exports.StoredFile = StoredFile;
//# sourceMappingURL=StoredFile.js.map