"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HasExtension = void 0;
const class_validator_1 = require("class-validator");
const is_file_validator_1 = require("./is-file.validator");
const toArray_1 = require("../../helpers/toArray");
function HasExtension(allowedExtensions, strictSource, validationOptions) {
    return (0, class_validator_1.ValidateBy)({
        name: 'HasExtension',
        constraints: [allowedExtensions, strictSource],
        validator: {
            validate(value, args) {
                const allowedExtensions = (0, toArray_1.toArray)(args.constraints[0]);
                const strictSource = (typeof args.constraints[1] === 'string')
                    ? args.constraints[1]
                    : undefined;
                if ((0, is_file_validator_1.isFile)(value)) {
                    const ext = value.extensionWithSource;
                    return allowedExtensions.includes(ext.value) && (!strictSource || strictSource === ext.source);
                }
                return false;
            },
            defaultMessage(validationArguments) {
                const allowedExtensions = (0, toArray_1.toArray)(validationArguments.constraints[0]);
                return `File must be of one of the extensions ${allowedExtensions.join(', ')}`;
            },
        },
    }, validationOptions || ((typeof strictSource === 'object') ? strictSource : null));
}
exports.HasExtension = HasExtension;
//# sourceMappingURL=has-extension.validator.js.map