"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IsFile = exports.isFile = void 0;
const class_validator_1 = require("class-validator");
const StoredFile_1 = require("../../classes/storage/StoredFile");
const common_1 = require("@nestjs/common");
const class_transformer_1 = require("class-transformer");
function isFile(value) {
    return value && value instanceof StoredFile_1.StoredFile;
}
exports.isFile = isFile;
function IsFile(validationOptions) {
    const isFileValidator = (0, class_validator_1.ValidateBy)({
        name: 'IsFile',
        constraints: [],
        validator: {
            validate(value, args) {
                debugger;
                return isFile(value);
            },
            defaultMessage(validationArguments) {
                return `Field "${validationArguments.property}" does not contain file`;
            },
        },
    }, validationOptions);
    const transformEnableImplicitConversion = (0, class_transformer_1.Transform)(params => {
        return params.obj[params.key];
    });
    if (validationOptions === null || validationOptions === void 0 ? void 0 : validationOptions.each) {
        return (0, common_1.applyDecorators)(
        // Force transform to an array of files then we have each mode and only one file in the field
        (0, class_transformer_1.Transform)((params) => {
            // If value isn't array and isn't empty, arraying it
            // We can get empty value, do nothing in this case
            if (!Array.isArray(params.value) && params.value) {
                return [params.value];
            }
            return params.value;
        }), transformEnableImplicitConversion, isFileValidator, (0, class_validator_1.IsArray)(Object.assign({}, validationOptions || {}, { each: false })));
    }
    return (0, common_1.applyDecorators)(transformEnableImplicitConversion, isFileValidator);
}
exports.IsFile = IsFile;
//# sourceMappingURL=is-file.validator.js.map