"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MaxFileSize = void 0;
const class_validator_1 = require("class-validator");
const is_file_validator_1 = require("./is-file.validator");
function MaxFileSize(maxSizeBytes, validationOptions) {
    return (0, class_validator_1.ValidateBy)({
        name: 'MaxFileSize',
        constraints: [maxSizeBytes],
        validator: {
            validate(value, args) {
                const size = args.constraints[0];
                if ((0, is_file_validator_1.isFile)(value)) {
                    return value.size <= size;
                }
                return false;
            },
            defaultMessage(validationArguments) {
                return `Maximum file size is ${validationArguments.constraints[0]}`;
            },
        },
    }, validationOptions);
}
exports.MaxFileSize = MaxFileSize;
//# sourceMappingURL=max-file-size.validator.js.map