"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MinFileSize = void 0;
const class_validator_1 = require("class-validator");
const is_file_validator_1 = require("./is-file.validator");
function MinFileSize(minSizeBytes, validationOptions) {
    return (0, class_validator_1.ValidateBy)({
        name: 'MinFileSize',
        constraints: [minSizeBytes],
        validator: {
            validate(value, args) {
                const size = args.constraints[0];
                if ((0, is_file_validator_1.isFile)(value)) {
                    return value.size >= size;
                }
                return false;
            },
            defaultMessage(validationArguments) {
                return `Maximum file size is ${validationArguments.constraints[0]}`;
            },
        },
    }, validationOptions);
}
exports.MinFileSize = MinFileSize;
//# sourceMappingURL=min-file-size.validator.js.map