"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkConfig = void 0;
const default_config_1 = require("../config/default.config");
function checkConfig(config, defaults = default_config_1.DEFAULT_CONFIG) {
    config = Object.assign({}, config);
    if (!config.storage)
        config.storage = defaults.storage;
    if (config.cleanupAfterSuccessHandle === undefined) {
        config.cleanupAfterSuccessHandle = defaults.cleanupAfterSuccessHandle;
    }
    if (config.cleanupAfterFailedHandle === undefined) {
        config.cleanupAfterFailedHandle = defaults.cleanupAfterFailedHandle;
    }
    if (!config.fileSystemStoragePath)
        config.fileSystemStoragePath = defaults.fileSystemStoragePath;
    return Object.assign({}, defaults, config);
}
exports.checkConfig = checkConfig;
//# sourceMappingURL=check-config.js.map