"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormDataInterceptor = void 0;
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const form_data_1 = require("../decorators/form-data");
const FormReader_1 = require("../classes/FormReader");
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
const global_config_inject_token_config_1 = require("../config/global-config-inject-token.config");
const check_config_1 = require("../helpers/check-config");
const type_is_1 = require("type-is");
let FormDataInterceptor = class FormDataInterceptor {
    constructor(globalConfig) {
        this.globalConfig = globalConfig;
        this.reflector = new core_1.Reflector();
    }
    async intercept(context, next) {
        const httpRequest = context.switchToHttp().getRequest();
        /**
         * fastify always have raw property in the request
         */
        const isFastify = !!httpRequest.raw;
        const req = isFastify ? httpRequest.raw : httpRequest;
        /** if the request is not multipart, skip **/
        if (!(0, type_is_1.is)(httpRequest, ['multipart']))
            return next.handle();
        /** merge global config with method level config **/
        const config = (0, check_config_1.checkConfig)(this.reflector.get(form_data_1.FORM_DATA_REQUEST_METADATA_KEY, context.getHandler()) || {}, this.globalConfig);
        const formReader = new FormReader_1.FormReader(req, config);
        return (0, rxjs_1.from)(formReader.handle()).pipe((0, rxjs_1.mergeMap)((formReaderResult) => {
            httpRequest.body = formReaderResult;
            return next.handle();
        }), (0, rxjs_1.catchError)((err) => {
            if (config.cleanupAfterFailedHandle || config.autoDeleteFile)
                formReader.deleteFiles();
            return (0, rxjs_1.throwError)(err);
        }), (0, operators_1.tap)(() => {
            if (config.cleanupAfterSuccessHandle || config.autoDeleteFile)
                formReader.deleteFiles();
        }));
    }
};
FormDataInterceptor = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)(global_config_inject_token_config_1.GLOBAL_CONFIG_INJECT_TOKEN)),
    __metadata("design:paramtypes", [Object])
], FormDataInterceptor);
exports.FormDataInterceptor = FormDataInterceptor;
//# sourceMappingURL=FormData.interceptor.js.map