"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var NestjsFormDataModule_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestjsFormDataModule = void 0;
const common_1 = require("@nestjs/common");
const FormData_interceptor_1 = require("./interceptors/FormData.interceptor");
const global_config_inject_token_config_1 = require("./config/global-config-inject-token.config");
const default_config_1 = require("./config/default.config");
const check_config_1 = require("./helpers/check-config");
let NestjsFormDataModule = NestjsFormDataModule_1 = class NestjsFormDataModule {
    static config(config) {
        return {
            global: !!config.isGlobal,
            module: NestjsFormDataModule_1,
            providers: [
                {
                    provide: global_config_inject_token_config_1.GLOBAL_CONFIG_INJECT_TOKEN,
                    useValue: (0, check_config_1.checkConfig)(config),
                },
            ],
        };
    }
    static configAsync(options) {
        return {
            global: !!options.isGlobal,
            module: NestjsFormDataModule_1,
            imports: options.imports || [],
            providers: this.createAsyncProviders(options),
        };
    }
    static createAsyncProviders(options) {
        if (options.useExisting || options.useFactory) {
            return [this.createAsyncOptionsProvider(options)];
        }
        return [
            this.createAsyncOptionsProvider(options),
            {
                provide: options.useClass,
                useClass: options.useClass,
            },
        ];
    }
    static createAsyncOptionsProvider(options) {
        if (options.useFactory) {
            return {
                provide: global_config_inject_token_config_1.GLOBAL_CONFIG_INJECT_TOKEN,
                useFactory: async (...args) => {
                    return (0, check_config_1.checkConfig)(await options.useFactory(...args));
                },
                inject: options.inject || [],
            };
        }
        return {
            provide: global_config_inject_token_config_1.GLOBAL_CONFIG_INJECT_TOKEN,
            useFactory: async (optionsFactory) => {
                const config = await optionsFactory.configAsync();
                return (0, check_config_1.checkConfig)(config);
            },
            inject: [options.useExisting || options.useClass],
        };
    }
};
NestjsFormDataModule = NestjsFormDataModule_1 = __decorate([
    (0, common_1.Module)({
        providers: [
            FormData_interceptor_1.FormDataInterceptor,
            {
                provide: global_config_inject_token_config_1.GLOBAL_CONFIG_INJECT_TOKEN,
                useValue: default_config_1.DEFAULT_CONFIG,
            },
        ],
        exports: [
            FormData_interceptor_1.FormDataInterceptor,
            global_config_inject_token_config_1.GLOBAL_CONFIG_INJECT_TOKEN,
        ],
    })
], NestjsFormDataModule);
exports.NestjsFormDataModule = NestjsFormDataModule;
//# sourceMappingURL=nestjs-form-data.module.js.map