import { DMMF, DMMFClass } from "@prisma/client/runtime";
export declare type PrismaField = {
    swaggerOption?: Record<string, any>;
    name: string;
    type?: any;
};
export declare type PrismaClass = {
    name: string;
    fields?: PrismaField[];
    relationTypes?: string[];
    enumTypes?: string[];
};
export declare const convertField: (field: DMMF.Field) => PrismaField;
export declare const convertDMMFModelToClass: (model: DMMF.Model) => PrismaClass;
export declare const swaggerOptionToTemplate: (input: Record<string, any>) => string;
export declare const makeOutputFromPrismaClass: (pClass: PrismaClass, useSwagger?: boolean) => string;
export declare const makeRootOutputFromClasses: (classes: PrismaClass[]) => string;
export declare type writeFromDMMFInput = {
    dmmf: DMMFClass;
    outputType: "console" | "file";
    targetDir: string;
    useSwagger?: boolean;
};
export declare const writeFromDMMF: (input: writeFromDMMFInput) => void;
export declare const writeToFile: (input: {
    dirPath: string;
    fileName: string;
    content: string;
}) => void;
