-- AlterTable
ALTER TABLE "CreditHistory" ADD COLUMN     "billplzId" TEXT;

-- CreateTable
CREATE TABLE "Billplz" (
    "id" TEXT NOT NULL,
    "billplz_id" TEXT NOT NULL,
    "collection_id" TEXT NOT NULL,
    "paid" BOOLEAN NOT NULL,
    "state" TEXT NOT NULL,
    "amount" DOUBLE PRECISION NOT NULL,
    "paid_amount" DOUBLE PRECISION NOT NULL,
    "due_at" TEXT NOT NULL,
    "email" TEXT NOT NULL,
    "mobile" TEXT,
    "name" TEXT,
    "url" TEXT,
    "paid_at" TIMESTAMP(3) NOT NULL,
    "transaction_id" TEXT NOT NULL,
    "transaction_status" TEXT NOT NULL,
    "x_signature" TEXT NOT NULL,

    CONSTRAINT "Billplz_pkey" PRIMARY KEY ("id")
);

-- CreateIndex
CREATE UNIQUE INDEX "Billplz_transaction_id_key" ON "Billplz"("transaction_id");

-- AddForeignKey
ALTER TABLE "CreditHistory" ADD CONSTRAINT "CreditHistory_billplzId_fkey" FOREIGN KEY ("billplzId") REFERENCES "Billplz"("id") ON DELETE SET NULL ON UPDATE CASCADE;
