/*
  Warnings:

  - You are about to drop the column `accumulatedPoints` on the `User` table. All the data in the column will be lost.
  - A unique constraint covering the columns `[loyaltyPointId]` on the table `User` will be added. If there are existing duplicate values, this will fail.

*/
-- AlterTable
ALTER TABLE "CreditHistory" ALTER COLUMN "status" SET DEFAULT 'Pending';

-- AlterTable
ALTER TABLE "User" DROP COLUMN "accumulatedPoints",
ADD COLUMN     "loyaltyPointId" TEXT;

-- CreateTable
CREATE TABLE "LoyaltyPoint" (
    "id" TEXT NOT NULL,
    "balance" DOUBLE PRECISION NOT NULL DEFAULT 0.0,
    "userId" TEXT NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3),

    CONSTRAINT "LoyaltyPoint_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "LoyaltyPointHistory" (
    "id" TEXT NOT NULL,
    "userId" TEXT NOT NULL,
    "amount" DOUBLE PRECISION NOT NULL,
    "newTotal" DOUBLE PRECISION NOT NULL,
    "type" TEXT NOT NULL,
    "orderId" TEXT,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3),
    "lastLoyaltyPointAmount" DOUBLE PRECISION,
    "loyaltyPointId" TEXT,

    CONSTRAINT "LoyaltyPointHistory_pkey" PRIMARY KEY ("id")
);

-- CreateIndex
CREATE UNIQUE INDEX "LoyaltyPoint_userId_key" ON "LoyaltyPoint"("userId");

-- CreateIndex
CREATE UNIQUE INDEX "User_loyaltyPointId_key" ON "User"("loyaltyPointId");

-- AddForeignKey
ALTER TABLE "User" ADD CONSTRAINT "User_loyaltyPointId_fkey" FOREIGN KEY ("loyaltyPointId") REFERENCES "LoyaltyPoint"("id") ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "LoyaltyPointHistory" ADD CONSTRAINT "LoyaltyPointHistory_orderId_fkey" FOREIGN KEY ("orderId") REFERENCES "Order"("id") ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "LoyaltyPointHistory" ADD CONSTRAINT "LoyaltyPointHistory_loyaltyPointId_fkey" FOREIGN KEY ("loyaltyPointId") REFERENCES "LoyaltyPoint"("id") ON DELETE SET NULL ON UPDATE CASCADE;
