// data.ts
export const sampleData = {
  users: [
    {
      id: '79bf6b00-e52d-44c9-93ad-b2e9ffd3089c',
      email: 'user1@example.com',
      name: 'User 1',
      phoneNumber: '123-456-7890',
      dateOfBirth: new Date('1990-01-01'),
      password: 'abc123',
      profilePic: 'https://placehold.co/600x400',
      roleId: 'dfdfcd66-ba0b-4512-a58c-363ae525143c',
      creditId: '23dd6ce3-79fe-461a-aaef-8bcef4325456',
      address : {
        create : {
          address : 'PJ PJ 123',
          city : 'Kepong',
          state : 'KL',
          country : 'Malaysia',
          postalCode : '52200'
        }
      }
    },
    {
      id: 'a205d24e-56d9-4a50-bd21-cc2248193709',
      email: 'user2@example.com',
      name: 'User 2',
      phoneNumber: '123-456-7891',
      dateOfBirth: new Date('1990-01-01'),
      password: 'abc123',
      profilePic: 'https://th.bing.com/th/id/OIP.aiaNK-lx9mVVhUQX5Con0wHaFj?rs=1&pid=ImgDetMain',
      roleId: 'dfdfcd66-ba0b-4512-a58c-363ae525143c',
      creditId: 'a205d24e-56d9-4a50-bd21-cc2248193709',
      address : {
        create : {
          address : 'PJ PJ 123',
          city : 'Kepong',
          state : 'KL',
          country : 'Malaysia',
          postalCode : '52200'
        }
      }
    },
    {
      id: '5b17cd8b-5c05-404f-a2a9-f1ac0a8ccd0d',
      email: 'user3@example.com',
      name: 'User 3',
      phoneNumber: '123-456-7892',
      dateOfBirth: new Date('1990-01-01'),
      password: 'abc123',
      profilePic: 'https://placehold.co/600x400',
      roleId: 'dfdfcd66-ba0b-4512-a58c-363ae525143c',
      address : {
        create : {
          address : 'PJ PJ 123',
          city : 'Kepong',
          state : 'KL',
          country : 'Malaysia',
          postalCode : '52200'
        }
      }
    },
    // Add more user data as needed
  ],
  merchants: [
    {
      id: '44e76488-d7b6-4e52-a3c5-4532811f3e04',
      email: 'merchant1@example.com',
      name: 'Merchant 1',
      phoneNumber: '123-456-7892',
      dateOfBirth: new Date('1990-01-01'),
      password: 'abc123',
      profilePic: 'https://th.bing.com/th/id/OIP.aiaNK-lx9mVVhUQX5Con0wHaFj?rs=1&pid=ImgDetMain',
      roleId: 'f94f3dcc-c48f-4859-971f-673b1fe717d1',
      merchant : {
        create : {
          id: '04ce57dd-5d7a-4704-84d4-b6bb52d474f3',
          name: 'Merchant Pow 1',                                    
          businessType: 'sole_proprietorship',
          businessRegistrationNumber: 'SSM112312',
          contractSigneeName: 'Test123',
          contractSigneeNRIC: '12312321312321',                             
          address : {
            create : {
              address : 'PJ PJ 123',
              city : 'Kepong',
              state : 'KL',
              country : 'Malaysia',
              postalCode : '52200',
              latitude: 3.057333,
              longitude: 101.790797
            }
          }
        }
      },
    },
    {
      id: '26f048ad-1f01-4acd-8701-a984afb96fd6',
      email: 'merchant2@example.com',
      name: 'Merchant 2',
      phoneNumber: '123-456-7892',
      dateOfBirth: new Date('1990-01-01'),
      password: 'abc123',
      profilePic: 'https://th.bing.com/th/id/OIP.uGpa6afUNibRMdLRwNNSDgHaD5?w=948&h=498&rs=1&pid=ImgDetMain',
      roleId: 'f94f3dcc-c48f-4859-971f-673b1fe717d1',
      merchant : {
        create : {
          id: '9b103f40-9793-412f-babd-219b28c202cc',
          name: 'Merchant Pow 2',                                    
          businessType: 'charitities',
          businessRegistrationNumber: 'SSM112312',
          contractSigneeName: 'Test123',
          contractSigneeNRIC: '12312321312321',                             
          address : {
            create : {
              address : 'PJ PJ 123',
              city : 'Kepong',
              state : 'KL',
              country : 'Malaysia',
              postalCode : '52200',
              latitude: 3.057333,
              longitude: 101.790797
            }
          }
        }
      },
    },
    {
      id: '78e70795-3eb5-4e2f-abfc-56b8d931c361',
      email: 'merchant3@example.com',
      name: 'Merchant 3',
      phoneNumber: '123-456-7892',
      dateOfBirth: new Date('1990-01-01'),
      password: 'abc123',
      profilePic: 'https://i.pinimg.com/originals/42/f2/12/42f21215bb0c0692e9c4e6b75866f832.jpg',
      roleId: 'f94f3dcc-c48f-4859-971f-673b1fe717d1',
      merchant : {
        create : {
          id: 'b5a07d5e-2acd-4d34-9523-31d528e79a72',
          name: 'Merchant Pow 1',                                    
          businessType: 'company',
          businessRegistrationNumber: 'SSM112312',
          contractSigneeName: 'Test123',
          contractSigneeNRIC: '12312321312321',                             
          address : {
            create : {
              address : 'PJ PJ 123',
              city : 'Kepong',
              state : 'KL',
              country : 'Malaysia',
              postalCode : '52200',
              latitude: 3.057333,
              longitude: 101.790797
            }
          }
        }
      },
    },
    // Add more merchant data as needed
  ],
  menus: [
    {
      id: 'f99151e0-590e-4f18-80e5-d910efd7948d',
      name: 'Menu Item 1',
      basePrice: 5.99,
      category: "coffee",
      description: 'Delicious menu item 1',
      merchantId: '04ce57dd-5d7a-4704-84d4-b6bb52d474f3',
      image: 'https://www.coffeebean.com.ph/wp-content/uploads/2023/09/Tea-Tea-Latte-425x320.jpg',
      menuOptions: [
        {
          id: "f8e7c5e0-2cbf-4b92-9a0a-7e4bde1d8b1e",
          name: 'Size',
          isRequired: true,
          min: 1,
          max: 1,
          options: [
            { id: "b0760015-dfe7-4d22-8a05-0b6b493e4e71", name: 'Small', price: 0, default: false },
            { id: "79bf1a3b-7c07-41a8-a781-6e0b4467f48a", name: 'Medium', price: 0, default: false },
            { id: "4bf76f35-153b-4821-8b9c-0d04a098e3e1", name: 'Large', price: 0, default: false }
          ],
        },
        {
          id: "0c40f28d-66d2-4c7c-9a42-cd5c7bc5f529",
          name: 'Ice',
          isRequired: true,
          min: 0,
          max: 1,
          options: [
            { id: "ad26516c-e9a5-4772-bc1c-0c489b4ba4db", name: '0%', price: 0, default: false },
            { id: "5a2d36e9-61a9-4617-9dfb-3f8d0da8e3d6", name: '25%', price: 0, default: false },
            { id: "0e11ccbb-0388-4e7d-bc07-82b9e2287d56", name: '50%', price: 0, default: false },
            { id: "b6fe2d85-8a7e-4e43-bd17-0c44dd942ad2", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "9e9f2de3-4f4b-4f84-b50d-5f205e37d582",
          name: 'sugar',
          isRequired: false,
          min: 0,
          max: 1,
          options: [
            { id: "f91d96c1-1f1b-47df-a23a-5c3b8d88332f", name: '0%', price: 0, default: false },
            { id: "65bf505e-fac3-4a72-93f5-f5372be71392", name: '25%', price: 0, default: false },
            { id: "df5a41b3-6d7a-43e0-bc2d-b1900c265f9d", name: '50%', price: 0, default: false },
            { id: "0ce415b8-e493-4b7c-87d8-ae2b7f87072b", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "6e9f6796-d2b3-4e01-8f6e-20e257d78d66",
          name: 'milk',
          isRequired: false,
          min: 0,
          max: 5,
          options: [
            { id: "1b9d6bcd-bbfd-4b2d-9b5d-ab8dfbbd4bed", name: 'Whole', price: 0.50 },
            { id: "b9c9ff21-8a08-44e5-a09e-6018a66b0ea7", name: 'Low-fat', price: 0.75 },
            { id: "d5e26ca3-1464-4f31-99b1-282b1b9a450b", name: 'Organic', price: 1.00 },
            { id: "f06508c5-9493-4b0a-9d8c-42468e70cdd5", name: 'Lactose-free', price: 1.00 },
          ],
        },
      ]
    },
    {
      id: '79f80417-e438-44ba-afb3-8138788d336b',
      name: 'Menu Item 2',
      basePrice: 6.99,
      category: "coffee",
      description: 'Delicious menu item 2',
      merchantId: '04ce57dd-5d7a-4704-84d4-b6bb52d474f3',
      image: 'https://www.coffeebean.com.ph/wp-content/uploads/2023/09/IBC-Coffee-425x320.jpg',
      menuOptions: [
        {
          id: "f8e7c5e0-2cbf-4b92-9a0a-7e4bde1d8b1e",
          name: 'Size',
          isRequired: true,
          min: 1,
          max: 1,
          options: [
            { id: "b0760015-dfe7-4d22-8a05-0b6b493e4e71", name: 'Small', price: 0, default: false },
            { id: "79bf1a3b-7c07-41a8-a781-6e0b4467f48a", name: 'Medium', price: 0, default: false },
            { id: "4bf76f35-153b-4821-8b9c-0d04a098e3e1", name: 'Large', price: 0, default: false }
          ],
        },
        {
          id: "0c40f28d-66d2-4c7c-9a42-cd5c7bc5f529",
          name: 'Ice',
          isRequired: true,
          min: 0,
          max: 1,
          options: [
            { id: "ad26516c-e9a5-4772-bc1c-0c489b4ba4db", name: '0%', price: 0, default: false },
            { id: "5a2d36e9-61a9-4617-9dfb-3f8d0da8e3d6", name: '25%', price: 0, default: false },
            { id: "0e11ccbb-0388-4e7d-bc07-82b9e2287d56", name: '50%', price: 0, default: false },
            { id: "b6fe2d85-8a7e-4e43-bd17-0c44dd942ad2", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "9e9f2de3-4f4b-4f84-b50d-5f205e37d582",
          name: 'sugar',
          isRequired: false,
          min: 0,
          max: 1,
          options: [
            { id: "f91d96c1-1f1b-47df-a23a-5c3b8d88332f", name: '0%', price: 0, default: false },
            { id: "65bf505e-fac3-4a72-93f5-f5372be71392", name: '25%', price: 0, default: false },
            { id: "df5a41b3-6d7a-43e0-bc2d-b1900c265f9d", name: '50%', price: 0, default: false },
            { id: "0ce415b8-e493-4b7c-87d8-ae2b7f87072b", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "6e9f6796-d2b3-4e01-8f6e-20e257d78d66",
          name: 'milk',
          isRequired: false,
          min: 0,
          max: 5,
          options: [
            { id: "1b9d6bcd-bbfd-4b2d-9b5d-ab8dfbbd4bed", name: 'Whole', price: 0.50 },
            { id: "b9c9ff21-8a08-44e5-a09e-6018a66b0ea7", name: 'Low-fat', price: 0.75 },
            { id: "d5e26ca3-1464-4f31-99b1-282b1b9a450b", name: 'Organic', price: 1.00 },
            { id: "f06508c5-9493-4b0a-9d8c-42468e70cdd5", name: 'Lactose-free', price: 1.00 },
          ],
        },
      ]
    },
    {
      id: '3b86c699-2f14-4d5e-92c9-5bf554262a28',
      name: 'Menu Item 3',
      basePrice: 7.99,
      category: "coffee",
      description: 'Delicious menu item 3',
      merchantId: '04ce57dd-5d7a-4704-84d4-b6bb52d474f3',
      image: 'https://th.bing.com/th/id/R.eedb21ccd0dde41e5c17f73410821d99?rik=wlVDJ3YXQjohlA&riu=http%3a%2f%2fwww.pixelstalk.net%2fwp-content%2fuploads%2f2016%2f05%2fDesktop-Download-Coffee-Wallpapers-HD.jpg&ehk=Le2PR6nQerimLHsK%2bjLPXRCWXBL%2bpKnzM7Y4z1MhuuY%3d&risl=&pid=ImgRaw&r=0',
      menuOptions: [
        {
          id: "f8e7c5e0-2cbf-4b92-9a0a-7e4bde1d8b1e",
          name: 'Size',
          isRequired: true,
          min: 1,
          max: 1,
          options: [
            { id: "b0760015-dfe7-4d22-8a05-0b6b493e4e71", name: 'Small', price: 0, default: false },
            { id: "79bf1a3b-7c07-41a8-a781-6e0b4467f48a", name: 'Medium', price: 0, default: false },
            { id: "4bf76f35-153b-4821-8b9c-0d04a098e3e1", name: 'Large', price: 0, default: false }
          ],
        },
        {
          id: "0c40f28d-66d2-4c7c-9a42-cd5c7bc5f529",
          name: 'Ice',
          isRequired: true,
          min: 0,
          max: 1,
          options: [
            { id: "ad26516c-e9a5-4772-bc1c-0c489b4ba4db", name: '0%', price: 0, default: false },
            { id: "5a2d36e9-61a9-4617-9dfb-3f8d0da8e3d6", name: '25%', price: 0, default: false },
            { id: "0e11ccbb-0388-4e7d-bc07-82b9e2287d56", name: '50%', price: 0, default: false },
            { id: "b6fe2d85-8a7e-4e43-bd17-0c44dd942ad2", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "9e9f2de3-4f4b-4f84-b50d-5f205e37d582",
          name: 'sugar',
          isRequired: false,
          min: 0,
          max: 1,
          options: [
            { id: "f91d96c1-1f1b-47df-a23a-5c3b8d88332f", name: '0%', price: 0, default: false },
            { id: "65bf505e-fac3-4a72-93f5-f5372be71392", name: '25%', price: 0, default: false },
            { id: "df5a41b3-6d7a-43e0-bc2d-b1900c265f9d", name: '50%', price: 0, default: false },
            { id: "0ce415b8-e493-4b7c-87d8-ae2b7f87072b", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "6e9f6796-d2b3-4e01-8f6e-20e257d78d66",
          name: 'milk',
          isRequired: false,
          min: 0,
          max: 5,
          options: [
            { id: "1b9d6bcd-bbfd-4b2d-9b5d-ab8dfbbd4bed", name: 'Whole', price: 0.50 },
            { id: "b9c9ff21-8a08-44e5-a09e-6018a66b0ea7", name: 'Low-fat', price: 0.75 },
            { id: "d5e26ca3-1464-4f31-99b1-282b1b9a450b", name: 'Organic', price: 1.00 },
            { id: "f06508c5-9493-4b0a-9d8c-42468e70cdd5", name: 'Lactose-free', price: 1.00 },
          ],
        },
      ]
    },
    {
      id: 'a469b96c-e9f2-434a-9fba-6a4470568243',
      name: 'Menu Item 4',
      basePrice: 5.99,
      category: "coffee",
      description: 'Delicious menu item 4',
      merchantId: '9b103f40-9793-412f-babd-219b28c202cc',
      image: 'https://www.pixelstalk.net/wp-content/uploads/2016/05/Free-download-coffee-wallpaper-hd-desktop.jpg',
      menuOptions: [
        {
          id: "f8e7c5e0-2cbf-4b92-9a0a-7e4bde1d8b1e",
          name: 'Size',
          isRequired: true,
          min: 1,
          max: 1,
          options: [
            { id: "b0760015-dfe7-4d22-8a05-0b6b493e4e71", name: 'Small', price: 0, default: false },
            { id: "79bf1a3b-7c07-41a8-a781-6e0b4467f48a", name: 'Medium', price: 0, default: false },
            { id: "4bf76f35-153b-4821-8b9c-0d04a098e3e1", name: 'Large', price: 0, default: false }
          ],
        },
        {
          id: "0c40f28d-66d2-4c7c-9a42-cd5c7bc5f529",
          name: 'Ice',
          isRequired: true,
          min: 0,
          max: 1,
          options: [
            { id: "ad26516c-e9a5-4772-bc1c-0c489b4ba4db", name: '0%', price: 0, default: false },
            { id: "5a2d36e9-61a9-4617-9dfb-3f8d0da8e3d6", name: '25%', price: 0, default: false },
            { id: "0e11ccbb-0388-4e7d-bc07-82b9e2287d56", name: '50%', price: 0, default: false },
            { id: "b6fe2d85-8a7e-4e43-bd17-0c44dd942ad2", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "9e9f2de3-4f4b-4f84-b50d-5f205e37d582",
          name: 'sugar',
          isRequired: false,
          min: 0,
          max: 1,
          options: [
            { id: "f91d96c1-1f1b-47df-a23a-5c3b8d88332f", name: '0%', price: 0, default: false },
            { id: "65bf505e-fac3-4a72-93f5-f5372be71392", name: '25%', price: 0, default: false },
            { id: "df5a41b3-6d7a-43e0-bc2d-b1900c265f9d", name: '50%', price: 0, default: false },
            { id: "0ce415b8-e493-4b7c-87d8-ae2b7f87072b", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "6e9f6796-d2b3-4e01-8f6e-20e257d78d66",
          name: 'milk',
          isRequired: false,
          min: 0,
          max: 5,
          options: [
            { id: "1b9d6bcd-bbfd-4b2d-9b5d-ab8dfbbd4bed", name: 'Whole', price: 0.50 },
            { id: "b9c9ff21-8a08-44e5-a09e-6018a66b0ea7", name: 'Low-fat', price: 0.75 },
            { id: "d5e26ca3-1464-4f31-99b1-282b1b9a450b", name: 'Organic', price: 1.00 },
            { id: "f06508c5-9493-4b0a-9d8c-42468e70cdd5", name: 'Lactose-free', price: 1.00 },
          ],
        },
      ]
    },
    {
      id: '08b46828-43e1-49a7-a527-f212e0faff8b',
      name: 'Menu Item 5',
      basePrice: 6.99,
      category: "coffee",
      description: 'Delicious menu item 5',
      merchantId: '9b103f40-9793-412f-babd-219b28c202cc',
      image: 'https://th.bing.com/th/id/R.c5412d3987f72030a9e9d296b3ed5ac5?rik=ZBhqu6do9rDUBg&riu=http%3a%2f%2fgetwallpapers.com%2fwallpaper%2ffull%2fa%2f8%2f4%2f1040113-free-coffee-cup-wallpaper-2560x1600-for-ipad.jpg&ehk=GK0FF5Wmm1NKHdB%2bV0da2%2fuAl3dgByAX7zf8oMgGynU%3d&risl=&pid=ImgRaw&r=0',
      menuOptions: [
        {
          id: "f8e7c5e0-2cbf-4b92-9a0a-7e4bde1d8b1e",
          name: 'Size',
          isRequired: true,
          min: 1,
          max: 1,
          options: [
            { id: "b0760015-dfe7-4d22-8a05-0b6b493e4e71", name: 'Small', price: 0, default: false },
            { id: "79bf1a3b-7c07-41a8-a781-6e0b4467f48a", name: 'Medium', price: 0, default: false },
            { id: "4bf76f35-153b-4821-8b9c-0d04a098e3e1", name: 'Large', price: 0, default: false }
          ],
        },
        {
          id: "0c40f28d-66d2-4c7c-9a42-cd5c7bc5f529",
          name: 'Ice',
          isRequired: true,
          min: 0,
          max: 1,
          options: [
            { id: "ad26516c-e9a5-4772-bc1c-0c489b4ba4db", name: '0%', price: 0, default: false },
            { id: "5a2d36e9-61a9-4617-9dfb-3f8d0da8e3d6", name: '25%', price: 0, default: false },
            { id: "0e11ccbb-0388-4e7d-bc07-82b9e2287d56", name: '50%', price: 0, default: false },
            { id: "b6fe2d85-8a7e-4e43-bd17-0c44dd942ad2", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "9e9f2de3-4f4b-4f84-b50d-5f205e37d582",
          name: 'sugar',
          isRequired: false,
          min: 0,
          max: 1,
          options: [
            { id: "f91d96c1-1f1b-47df-a23a-5c3b8d88332f", name: '0%', price: 0, default: false },
            { id: "65bf505e-fac3-4a72-93f5-f5372be71392", name: '25%', price: 0, default: false },
            { id: "df5a41b3-6d7a-43e0-bc2d-b1900c265f9d", name: '50%', price: 0, default: false },
            { id: "0ce415b8-e493-4b7c-87d8-ae2b7f87072b", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "6e9f6796-d2b3-4e01-8f6e-20e257d78d66",
          name: 'milk',
          isRequired: false,
          min: 0,
          max: 5,
          options: [
            { id: "1b9d6bcd-bbfd-4b2d-9b5d-ab8dfbbd4bed", name: 'Whole', price: 0.50 },
            { id: "b9c9ff21-8a08-44e5-a09e-6018a66b0ea7", name: 'Low-fat', price: 0.75 },
            { id: "d5e26ca3-1464-4f31-99b1-282b1b9a450b", name: 'Organic', price: 1.00 },
            { id: "f06508c5-9493-4b0a-9d8c-42468e70cdd5", name: 'Lactose-free', price: 1.00 },
          ],
        },
      ]
    },
    {
      id: '43412852-754b-4f61-a2c0-efa68910acdb',
      name: 'Menu Item 6',
      basePrice: 7.99,
      category: "coffee",
      description: 'Delicious menu item 6',
      merchantId: '9b103f40-9793-412f-babd-219b28c202cc',
      image: 'https://www.coffeebean.com.ph/wp-content/uploads/2023/09/Coffee-Coffee-425x320.jpg',
      menuOptions: [
        {
          id: "f8e7c5e0-2cbf-4b92-9a0a-7e4bde1d8b1e",
          name: 'Size',
          isRequired: true,
          min: 1,
          max: 1,
          options: [
            { id: "b0760015-dfe7-4d22-8a05-0b6b493e4e71", name: 'Small', price: 0, default: false },
            { id: "79bf1a3b-7c07-41a8-a781-6e0b4467f48a", name: 'Medium', price: 0, default: false },
            { id: "4bf76f35-153b-4821-8b9c-0d04a098e3e1", name: 'Large', price: 0, default: false }
          ],
        },
        {
          id: "0c40f28d-66d2-4c7c-9a42-cd5c7bc5f529",
          name: 'Ice',
          isRequired: true,
          min: 0,
          max: 1,
          options: [
            { id: "ad26516c-e9a5-4772-bc1c-0c489b4ba4db", name: '0%', price: 0, default: false },
            { id: "5a2d36e9-61a9-4617-9dfb-3f8d0da8e3d6", name: '25%', price: 0, default: false },
            { id: "0e11ccbb-0388-4e7d-bc07-82b9e2287d56", name: '50%', price: 0, default: false },
            { id: "b6fe2d85-8a7e-4e43-bd17-0c44dd942ad2", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "9e9f2de3-4f4b-4f84-b50d-5f205e37d582",
          name: 'sugar',
          isRequired: false,
          min: 0,
          max: 1,
          options: [
            { id: "f91d96c1-1f1b-47df-a23a-5c3b8d88332f", name: '0%', price: 0, default: false },
            { id: "65bf505e-fac3-4a72-93f5-f5372be71392", name: '25%', price: 0, default: false },
            { id: "df5a41b3-6d7a-43e0-bc2d-b1900c265f9d", name: '50%', price: 0, default: false },
            { id: "0ce415b8-e493-4b7c-87d8-ae2b7f87072b", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "6e9f6796-d2b3-4e01-8f6e-20e257d78d66",
          name: 'milk',
          isRequired: false,
          min: 0,
          max: 5,
          options: [
            { id: "1b9d6bcd-bbfd-4b2d-9b5d-ab8dfbbd4bed", name: 'Whole', price: 0.50 },
            { id: "b9c9ff21-8a08-44e5-a09e-6018a66b0ea7", name: 'Low-fat', price: 0.75 },
            { id: "d5e26ca3-1464-4f31-99b1-282b1b9a450b", name: 'Organic', price: 1.00 },
            { id: "f06508c5-9493-4b0a-9d8c-42468e70cdd5", name: 'Lactose-free', price: 1.00 },
          ],
        },
      ]
    },
    {
      id: 'a48c09e5-d532-4883-8470-bf30235a787c',
      name: 'Menu Item 7',
      basePrice: 5.99,
      category: "coffee",
      description: 'Delicious menu item 7',
      merchantId: 'b5a07d5e-2acd-4d34-9523-31d528e79a72',
      image: 'https://www.coffeebean.com.ph/wp-content/uploads/2023/09/Coffee-Non-coffee-425x320.jpg',
      menuOptions: [
        {
          id: "f8e7c5e0-2cbf-4b92-9a0a-7e4bde1d8b1e",
          name: 'Size',
          isRequired: true,
          min: 1,
          max: 1,
          options: [
            { id: "b0760015-dfe7-4d22-8a05-0b6b493e4e71", name: 'Small', price: 0, default: false },
            { id: "79bf1a3b-7c07-41a8-a781-6e0b4467f48a", name: 'Medium', price: 0, default: false },
            { id: "4bf76f35-153b-4821-8b9c-0d04a098e3e1", name: 'Large', price: 0, default: false }
          ],
        },
        {
          id: "0c40f28d-66d2-4c7c-9a42-cd5c7bc5f529",
          name: 'Ice',
          isRequired: true,
          min: 0,
          max: 1,
          options: [
            { id: "ad26516c-e9a5-4772-bc1c-0c489b4ba4db", name: '0%', price: 0, default: false },
            { id: "5a2d36e9-61a9-4617-9dfb-3f8d0da8e3d6", name: '25%', price: 0, default: false },
            { id: "0e11ccbb-0388-4e7d-bc07-82b9e2287d56", name: '50%', price: 0, default: false },
            { id: "b6fe2d85-8a7e-4e43-bd17-0c44dd942ad2", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "9e9f2de3-4f4b-4f84-b50d-5f205e37d582",
          name: 'sugar',
          isRequired: false,
          min: 0,
          max: 1,
          options: [
            { id: "f91d96c1-1f1b-47df-a23a-5c3b8d88332f", name: '0%', price: 0, default: false },
            { id: "65bf505e-fac3-4a72-93f5-f5372be71392", name: '25%', price: 0, default: false },
            { id: "df5a41b3-6d7a-43e0-bc2d-b1900c265f9d", name: '50%', price: 0, default: false },
            { id: "0ce415b8-e493-4b7c-87d8-ae2b7f87072b", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "6e9f6796-d2b3-4e01-8f6e-20e257d78d66",
          name: 'milk',
          isRequired: false,
          min: 0,
          max: 5,
          options: [
            { id: "1b9d6bcd-bbfd-4b2d-9b5d-ab8dfbbd4bed", name: 'Whole', price: 0.50 },
            { id: "b9c9ff21-8a08-44e5-a09e-6018a66b0ea7", name: 'Low-fat', price: 0.75 },
            { id: "d5e26ca3-1464-4f31-99b1-282b1b9a450b", name: 'Organic', price: 1.00 },
            { id: "f06508c5-9493-4b0a-9d8c-42468e70cdd5", name: 'Lactose-free', price: 1.00 },
          ],
        },
      ]
    },
    {
      id: '3bf488f2-a5f6-45c5-b8b5-4011b0ad33a5',
      name: 'Menu Item 8',
      basePrice: 6.99,
      category: "tea",
      description: 'Delicious menu item 8',
      merchantId: 'b5a07d5e-2acd-4d34-9523-31d528e79a72',
      image: 'https://www.coffeebean.com.ph/wp-content/uploads/2023/09/Coffee-Espresso-425x320.jpg',
      menuOptions: [
        {
          id: "f8e7c5e0-2cbf-4b92-9a0a-7e4bde1d8b1e",
          name: 'Size',
          isRequired: true,
          min: 1,
          max: 1,
          options: [
            { id: "b0760015-dfe7-4d22-8a05-0b6b493e4e71", name: 'Small', price: 0, default: false },
            { id: "79bf1a3b-7c07-41a8-a781-6e0b4467f48a", name: 'Medium', price: 0, default: false },
            { id: "4bf76f35-153b-4821-8b9c-0d04a098e3e1", name: 'Large', price: 0, default: false }
          ],
        },
        {
          id: "0c40f28d-66d2-4c7c-9a42-cd5c7bc5f529",
          name: 'Ice',
          isRequired: true,
          min: 0,
          max: 1,
          options: [
            { id: "ad26516c-e9a5-4772-bc1c-0c489b4ba4db", name: '0%', price: 0, default: false },
            { id: "5a2d36e9-61a9-4617-9dfb-3f8d0da8e3d6", name: '25%', price: 0, default: false },
            { id: "0e11ccbb-0388-4e7d-bc07-82b9e2287d56", name: '50%', price: 0, default: false },
            { id: "b6fe2d85-8a7e-4e43-bd17-0c44dd942ad2", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "9e9f2de3-4f4b-4f84-b50d-5f205e37d582",
          name: 'sugar',
          isRequired: false,
          min: 0,
          max: 1,
          options: [
            { id: "f91d96c1-1f1b-47df-a23a-5c3b8d88332f", name: '0%', price: 0, default: false },
            { id: "65bf505e-fac3-4a72-93f5-f5372be71392", name: '25%', price: 0, default: false },
            { id: "df5a41b3-6d7a-43e0-bc2d-b1900c265f9d", name: '50%', price: 0, default: false },
            { id: "0ce415b8-e493-4b7c-87d8-ae2b7f87072b", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "6e9f6796-d2b3-4e01-8f6e-20e257d78d66",
          name: 'milk',
          isRequired: false,
          min: 0,
          max: 5,
          options: [
            { id: "1b9d6bcd-bbfd-4b2d-9b5d-ab8dfbbd4bed", name: 'Whole', price: 0.50 },
            { id: "b9c9ff21-8a08-44e5-a09e-6018a66b0ea7", name: 'Low-fat', price: 0.75 },
            { id: "d5e26ca3-1464-4f31-99b1-282b1b9a450b", name: 'Organic', price: 1.00 },
            { id: "f06508c5-9493-4b0a-9d8c-42468e70cdd5", name: 'Lactose-free', price: 1.00 },
          ],
        },
      ]
    },
    {
      id: '459b0c65-9517-4167-852e-7e67402ed9e8',
      name: 'Menu Item 9',
      basePrice: 7.99,
      category: "tea",
      description: 'Delicious menu item 9',
      merchantId: 'b5a07d5e-2acd-4d34-9523-31d528e79a72',
      image: 'https://www.coffeebean.com.ph/wp-content/uploads/2023/09/Tea-Tea-425x320.jpg',
      menuOptions: [
        {
          id: "f8e7c5e0-2cbf-4b92-9a0a-7e4bde1d8b1e",
          name: 'Size',
          isRequired: true,
          min: 1,
          max: 1,
          options: [
            { id: "b0760015-dfe7-4d22-8a05-0b6b493e4e71", name: 'Small', price: 0, default: false },
            { id: "79bf1a3b-7c07-41a8-a781-6e0b4467f48a", name: 'Medium', price: 0, default: false },
            { id: "4bf76f35-153b-4821-8b9c-0d04a098e3e1", name: 'Large', price: 0, default: false }
          ],
        },
        {
          id: "0c40f28d-66d2-4c7c-9a42-cd5c7bc5f529",
          name: 'Ice',
          isRequired: true,
          min: 0,
          max: 1,
          options: [
            { id: "ad26516c-e9a5-4772-bc1c-0c489b4ba4db", name: '0%', price: 0, default: false },
            { id: "5a2d36e9-61a9-4617-9dfb-3f8d0da8e3d6", name: '25%', price: 0, default: false },
            { id: "0e11ccbb-0388-4e7d-bc07-82b9e2287d56", name: '50%', price: 0, default: false },
            { id: "b6fe2d85-8a7e-4e43-bd17-0c44dd942ad2", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "9e9f2de3-4f4b-4f84-b50d-5f205e37d582",
          name: 'sugar',
          isRequired: false,
          min: 0,
          max: 1,
          options: [
            { id: "f91d96c1-1f1b-47df-a23a-5c3b8d88332f", name: '0%', price: 0, default: false },
            { id: "65bf505e-fac3-4a72-93f5-f5372be71392", name: '25%', price: 0, default: false },
            { id: "df5a41b3-6d7a-43e0-bc2d-b1900c265f9d", name: '50%', price: 0, default: false },
            { id: "0ce415b8-e493-4b7c-87d8-ae2b7f87072b", name: '100%', price: 0, default: true },
          ],
        },
        {
          id: "6e9f6796-d2b3-4e01-8f6e-20e257d78d66",
          name: 'milk',
          isRequired: false,
          min: 0,
          max: 5,
          options: [
            { id: "1b9d6bcd-bbfd-4b2d-9b5d-ab8dfbbd4bed", name: 'Whole', price: 0.50 },
            { id: "b9c9ff21-8a08-44e5-a09e-6018a66b0ea7", name: 'Low-fat', price: 0.75 },
            { id: "d5e26ca3-1464-4f31-99b1-282b1b9a450b", name: 'Organic', price: 1.00 },
            { id: "f06508c5-9493-4b0a-9d8c-42468e70cdd5", name: 'Lactose-free', price: 1.00 },
          ],
        },
      ]
    },
    // Add more menu data as needed
  ],
  roles : [
    {
      id: 'dfdfcd66-ba0b-4512-a58c-363ae525143c',
      name: 'Customer'
    },
    {
      id: 'f94f3dcc-c48f-4859-971f-673b1fe717d1',
      name: 'Merchant'
    }
  ],
  orders: [
    {
      id: '4ae38fd9-39b9-493d-9d73-65c3096a367e',
      totalAmount: 10.99,
      orderTime: new Date(),
      pickupTime: new Date(),
      status: 'Pending',
      merchantId: 'b5a07d5e-2acd-4d34-9523-31d528e79a72',
      userId: '79bf6b00-e52d-44c9-93ad-b2e9ffd3089c',
      orderDetails: [
        {
          id: 'ae682bee-d6d0-4146-b859-4939be568198',
          quantity: 1,
          basePrice: 5.00, // Use the actual base price from the menu
          orderDetailOptions: [
            {
              id: 'ae682bee-d6d0-4146-b859-4939be568199',
              type: 'ice',
              name: '100%',
              price: 0,
            },
            {
              id: 'ae682bee-d6d0-4146-b859-4939be568200',
              type: 'sugar',
              name: '100%',
              price: 0,
            },
          ],
        },
        {
          id: 'ae682bee-d6d0-4146-b859-4939be568201',
          quantity: 1,
          basePrice: 5.99, // Use the actual base price from the menu
          orderDetailOptions: [
            {
              id: 'ae682bee-d6d0-4146-b859-4939be568202',
              type: 'ice',
              name: '50%',
              price: 0,
            },
            {
              id: 'ae682bee-d6d0-4146-b859-4939be568203',
              type: 'sugar',
              name: '50%',
              price: 0,
            },
          ],
        },
        // Add more order details data as needed
      ],
    },
    // Add more order data as needed
  ],
  transactions: [
    {
      id: '23dd6ce3-79fe-461a-aaef-8bcef4327156',
      totalAmount: 10.99, // Use the actual total amount from the order
      paymentTime: new Date(),
      paymentMethod: 'Credit Card',
      orderId: '4ae38fd9-39b9-493d-9d73-65c3096a367e', // Use the actual order ID
    },
    // Add more transaction data as needed
  ],
  credit: [
    {
      id: '23dd6ce3-79fe-461a-aaef-8bcef4325456',
      balance: 100.50, 
      userId: '79bf6b00-e52d-44c9-93ad-b2e9ffd3089c',
      createdAt: new Date()
    },
    // Add more credit data as needed
  ],
  creditHistory: [
    {
      id: '77dd6ce3-34fe-aa1a-aaef-8bcef4325456',
      amount: 40.50, 
      actualAmount: 40.50, 
      type: 'RELOAD',
      status: 'SUCCESS',
      lastCreditAmount: 30.00,
      creditId: '23dd6ce3-79fe-461a-aaef-8bcef4325456',
      createdAt: new Date(),
      orderId: null
    },
    {
      id: '65dd6ce3-abcd-abba-aaef-8bcef4325456',
      amount: 60.00, 
      actualAmount: 60.00, 
      type: 'RELOAD',
      status: 'SUCCESS',
      lastCreditAmount: 40.00,
      creditId: '23dd6ce3-79fe-461a-aaef-8bcef4325456',
      createdAt: new Date(),
      orderId: null
    },
    // Add more credit History data as needed
  ]
};
