import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

function generateReferenceId() {

    const now = new Date();
    const year = now.getFullYear().toString().slice(-2); // Last two digits of the year
    const month = String(now.getMonth() + 1).padStart(2, '0'); // MM
    const day = String(now.getDate()).padStart(2, '0'); // DD
    const datePrefix = `${year}${month}${day}`; // YYMMDD
    const randomSuffix = this.nanoid(); // Random part
    return `${datePrefix}-${randomSuffix}`;
}

async function updateExistingOrders() {
    const ordersWithoutRefId = await prisma.order.findMany({
        where: { referenceId: null },
    });

    for (const order of ordersWithoutRefId) {
        let referenceId: string;
        let exists: boolean;

        do {
            // Generate a unique referenceId (e.g., using UUID)
            referenceId = generateReferenceId()// or use a custom function

            // Check if the referenceId already exists
            const res = await prisma.order.findUnique({
                where: { referenceId },
            });

            exists = !!res; // Set exists to true if a record is found, otherwise false
        } while (exists);

        // Update the order with the new referenceId
        await prisma.order.update({
            where: { id: order.id },
            data: { referenceId },
        });

        console.log(`Updated Order ID ${order.id} with Reference ID ${referenceId}`);
    }
}

updateExistingOrders()
    .then(() => {
        console.log('All orders updated');
    })
    .catch((error) => {
        console.error('Error updating orders:', error);
    })
    .finally(async () => {
        await prisma.$disconnect();
    });
