import { User } from './user';
import { Merchant } from './merchant';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class Address {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: String })
  address: string;

  @ApiProperty({ type: String })
  city: string;

  @ApiProperty({ type: String })
  state: string;

  @ApiProperty({ type: String })
  country: string;

  @ApiProperty({ type: String })
  postalCode: string;

  @ApiPropertyOptional({ type: Number })
  latitude?: number;

  @ApiPropertyOptional({ type: Number })
  longitude?: number;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiProperty({ type: Date })
  updatedAt: Date;

  @ApiProperty({ isArray: true, type: () => User })
  User: User[];

  @ApiProperty({ isArray: true, type: () => Merchant })
  Merchant: Merchant[];
}
