import { CreditHistory } from './credit_history';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class Billplz {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: String })
  billplz_id: string;

  @ApiProperty({ type: String })
  collection_id: string;

  @ApiProperty({ type: Boolean })
  paid: boolean;

  @ApiProperty({ type: String })
  state: string;

  @ApiProperty({ type: Number })
  amount: number;

  @ApiProperty({ type: Number })
  paid_amount: number;

  @ApiProperty({ type: String })
  due_at: string;

  @ApiProperty({ type: String })
  email: string;

  @ApiPropertyOptional({ type: String })
  mobile?: string;

  @ApiPropertyOptional({ type: String })
  name?: string;

  @ApiPropertyOptional({ type: String })
  url?: string;

  @ApiProperty({ type: Date })
  paid_at: Date;

  @ApiProperty({ type: String })
  x_signature: string;

  @ApiProperty({ isArray: true, type: () => CreditHistory })
  CreditHistory: CreditHistory[];
}
