import { User } from './user';
import { CreditHistory } from './credit_history';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class Credit {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: Number })
  balance: number;

  @ApiPropertyOptional({ type: () => User })
  user?: User;

  @ApiProperty({ type: String })
  userId: string;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiPropertyOptional({ type: Date })
  updatedAt?: Date;

  @ApiProperty({ isArray: true, type: () => CreditHistory })
  history: CreditHistory[];
}
