import { Credit } from './credit';
import { Order } from './order';
import { Billplz } from './billplz';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class CreditHistory {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: Number })
  amount: number;

  @ApiProperty({ type: Number })
  actualAmount: number;

  @ApiProperty({ type: String })
  type: string;

  @ApiProperty({ type: String })
  status: string = 'PENDING';

  @ApiPropertyOptional({ type: String })
  creditId?: string;

  @ApiPropertyOptional({ type: String })
  orderId?: string;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiPropertyOptional({ type: Date })
  updatedAt?: Date;

  @ApiPropertyOptional({ type: Number })
  lastCreditAmount?: number;

  @ApiPropertyOptional({ type: () => Credit })
  credit?: Credit;

  @ApiPropertyOptional({ type: () => Order })
  order?: Order;

  @ApiPropertyOptional({ type: String })
  billplzId?: string;

  @ApiPropertyOptional({ type: () => Billplz })
  billplz?: Billplz;
}
