import { User as _User } from './user';
import { UserVehicle as _UserVehicle } from './user_vehicle';
import { Merchant as _Merchant } from './merchant';
import { Address as _Address } from './address';
import { Menu as _Menu } from './menu';
import { MenuOption as _MenuOption } from './menu_option';
import { Option as _Option } from './option';
import { Order as _Order } from './order';
import { OrderDetails as _OrderDetails } from './order_details';
import { OrderDetailOptions as _OrderDetailOptions } from './order_detail_options';
import { Transaction as _Transaction } from './transaction';
import { Rating as _Rating } from './rating';
import { Role as _Role } from './role';
import { Credit as _Credit } from './credit';
import { CreditHistory as _CreditHistory } from './credit_history';
import { Billplz as _Billplz } from './billplz';
import { Voucher as _Voucher } from './voucher';
import { Tag as _Tag } from './tag';
import { Tier as _Tier } from './tier';
import { LoyaltyPoint as _LoyaltyPoint } from './loyalty_point';
import { LoyaltyPointHistory as _LoyaltyPointHistory } from './loyalty_point_history';
import { MerchandiseProduct as _MerchandiseProduct } from './merchandise_product';
import { UserRedemptionHistory as _UserRedemptionHistory } from './user_redemption_history';

export namespace PrismaModel {
  export class User extends _User {}
  export class UserVehicle extends _UserVehicle {}
  export class Merchant extends _Merchant {}
  export class Address extends _Address {}
  export class Menu extends _Menu {}
  export class MenuOption extends _MenuOption {}
  export class Option extends _Option {}
  export class Order extends _Order {}
  export class OrderDetails extends _OrderDetails {}
  export class OrderDetailOptions extends _OrderDetailOptions {}
  export class Transaction extends _Transaction {}
  export class Rating extends _Rating {}
  export class Role extends _Role {}
  export class Credit extends _Credit {}
  export class CreditHistory extends _CreditHistory {}
  export class Billplz extends _Billplz {}
  export class Voucher extends _Voucher {}
  export class Tag extends _Tag {}
  export class Tier extends _Tier {}
  export class LoyaltyPoint extends _LoyaltyPoint {}
  export class LoyaltyPointHistory extends _LoyaltyPointHistory {}
  export class MerchandiseProduct extends _MerchandiseProduct {}
  export class UserRedemptionHistory extends _UserRedemptionHistory {}

  export const extraModels = [
    User,
    UserVehicle,
    Merchant,
    Address,
    Menu,
    MenuOption,
    Option,
    Order,
    OrderDetails,
    OrderDetailOptions,
    Transaction,
    Rating,
    Role,
    Credit,
    CreditHistory,
    Billplz,
    Voucher,
    Tag,
    Tier,
    LoyaltyPoint,
    LoyaltyPointHistory,
    MerchandiseProduct,
    UserRedemptionHistory,
  ];
}
