import { Order } from './order';
import { LoyaltyPoint } from './loyalty_point';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class LoyaltyPointHistory {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: String })
  userId: string;

  @ApiProperty({ type: Number })
  amount: number;

  @ApiProperty({ type: Number })
  newTotal: number;

  @ApiProperty({ type: String })
  type: string;

  @ApiPropertyOptional({ type: String })
  orderId?: string;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiPropertyOptional({ type: Date })
  updatedAt?: Date;

  @ApiPropertyOptional({ type: Number })
  lastLoyaltyPointAmount?: number;

  @ApiPropertyOptional({ type: () => Order })
  order?: Order;

  @ApiPropertyOptional({ type: () => LoyaltyPoint })
  LoyaltyPoint?: LoyaltyPoint;

  @ApiPropertyOptional({ type: String })
  loyaltyPointId?: string;
}
