import { Merchant } from './merchant';
import { OrderDetails } from './order_details';
import { MenuOption } from './menu_option';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class Menu {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: String })
  name: string;

  @ApiPropertyOptional({ type: String })
  image?: string;

  @ApiProperty({ type: Number })
  basePrice: number;

  @ApiProperty({ type: String })
  description: string;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiPropertyOptional({ type: Date })
  updatedAt?: Date;

  @ApiProperty({ type: Boolean })
  active: boolean = true;

  @ApiProperty({ type: String })
  category: string;

  @ApiProperty({ type: String })
  merchantId: string;

  @ApiProperty({ type: () => Merchant })
  merchant: Merchant;

  @ApiProperty({ isArray: true, type: () => OrderDetails })
  orderDetails: OrderDetails[];

  @ApiProperty({ isArray: true, type: () => MenuOption })
  menuOption: MenuOption[];
}
