import { Menu } from './menu';
import { Option } from './option';
import { ApiProperty } from '@nestjs/swagger';

export class MenuOption {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: String })
  name: string;

  @ApiProperty({ type: Boolean })
  isRequired: boolean;

  @ApiProperty({ type: Number })
  min: number;

  @ApiProperty({ type: Number })
  max: number;

  @ApiProperty({ type: Boolean })
  active: boolean = true;

  @ApiProperty({ type: String })
  menuId: string;

  @ApiProperty({ type: () => Menu })
  menu: Menu;

  @ApiProperty({ isArray: true, type: () => Option })
  option: Option[];
}
