import { Tag } from './tag';
import { UserRedemptionHistory } from './user_redemption_history';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class MerchandiseProduct {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: String })
  name: string;

  @ApiProperty({ type: String })
  category: string;

  @ApiProperty({ type: String })
  description: string;

  @ApiProperty({ type: Number })
  price: number;

  @ApiProperty({ type: Number })
  pointsCost: number;

  @ApiProperty({ isArray: true, type: String })
  images: string[] = [];

  @ApiProperty({ type: Number })
  stock: number;

  @ApiPropertyOptional({ type: String })
  tagId?: string;

  @ApiPropertyOptional({ type: () => Tag })
  tag?: Tag;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiProperty({ type: Date })
  updatedAt: Date;

  @ApiProperty({ isArray: true, type: () => UserRedemptionHistory })
  UserRedemptionHistory: UserRedemptionHistory[];
}
