import { Menu } from './menu';
import { Rating } from './rating';
import { Order } from './order';
import { Address } from './address';
import { User } from './user';
import { UserRedemptionHistory } from './user_redemption_history';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class Merchant {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: String })
  name: string;

  @ApiPropertyOptional({ type: String })
  image?: string;

  @ApiProperty({ type: String })
  businessType: string = 'non_ssm';

  @ApiPropertyOptional({ type: String })
  businessRegistrationNumber?: string;

  @ApiPropertyOptional({ type: String })
  contractSigneeName?: string;

  @ApiPropertyOptional({ type: String })
  contractSigneeNRIC?: string;

  @ApiPropertyOptional({ type: String })
  openingHours?: string;

  @ApiProperty({ type: String })
  userId: string;

  @ApiPropertyOptional({ type: String })
  addressId?: string;

  @ApiProperty({ type: Boolean })
  active: boolean = true;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiPropertyOptional({ type: Date })
  updatedAt?: Date;

  @ApiPropertyOptional({ type: String })
  storyDescription?: string;

  @ApiProperty({ isArray: true, type: () => Menu })
  menu: Menu[];

  @ApiProperty({ isArray: true, type: () => Rating })
  rating: Rating[];

  @ApiProperty({ isArray: true, type: () => Order })
  order: Order[];

  @ApiPropertyOptional({ type: () => Address })
  address?: Address;

  @ApiPropertyOptional({ type: () => User })
  user?: User;

  @ApiProperty({ isArray: true, type: () => UserRedemptionHistory })
  UserRedemptionHistory: UserRedemptionHistory[];
}
