import { MenuOption } from './menu_option';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class Option {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: String })
  name: string;

  @ApiProperty({ type: Number })
  price: number;

  @ApiProperty({ type: Boolean })
  active: boolean = true;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiPropertyOptional({ type: Date })
  updatedAt?: Date;

  @ApiProperty({ type: String })
  menuOptionId: string;

  @ApiProperty({ type: () => MenuOption })
  menuOption: MenuOption;
}
