import { Merchant } from './merchant';
import { User } from './user';
import { UserVehicle } from './user_vehicle';
import { Transaction } from './transaction';
import { OrderDetails } from './order_details';
import { Rating } from './rating';
import { CreditHistory } from './credit_history';
import { LoyaltyPointHistory } from './loyalty_point_history';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class Order {
  @ApiProperty({ type: String })
  id: string;

  @ApiPropertyOptional({ type: String })
  referenceId?: string;

  @ApiProperty({ type: Number })
  totalAmount: number;

  @ApiProperty({ type: Date })
  orderTime: Date;

  @ApiProperty({ type: Date })
  pickupTime: Date;

  @ApiProperty({ type: String })
  status: string;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiPropertyOptional({ type: Date })
  updatedAt?: Date;

  @ApiPropertyOptional({ type: Date })
  completedAt?: Date;

  @ApiPropertyOptional({ type: String })
  transactionId?: string;

  @ApiPropertyOptional({ type: String })
  merchantId?: string;

  @ApiProperty({ type: String })
  userId: string;

  @ApiPropertyOptional({ type: String })
  userVehicleId?: string;

  @ApiPropertyOptional({ type: () => Merchant })
  merchant?: Merchant;

  @ApiProperty({ type: () => User })
  user: User;

  @ApiPropertyOptional({ type: () => UserVehicle })
  userVehicle?: UserVehicle;

  @ApiPropertyOptional({ type: () => Transaction })
  transaction?: Transaction;

  @ApiProperty({ type: Boolean })
  voucherUsed: boolean;

  @ApiProperty({ isArray: true, type: () => OrderDetails })
  orderDetails: OrderDetails[];

  @ApiProperty({ isArray: true, type: () => Rating })
  rating: Rating[];

  @ApiProperty({ isArray: true, type: () => CreditHistory })
  CreditHistory: CreditHistory[];

  @ApiProperty({ isArray: true, type: () => LoyaltyPointHistory })
  LoyaltyPointHistory: LoyaltyPointHistory[];
}
