import { OrderDetails } from './order_details';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class OrderDetailOptions {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: String })
  type: string;

  @ApiProperty({ type: String })
  name: string;

  @ApiProperty({ type: Number })
  price: number;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiPropertyOptional({ type: Date })
  updatedAt?: Date;

  @ApiProperty({ type: String })
  orderDetailsId: string;

  @ApiProperty({ type: () => OrderDetails })
  orderDetails: OrderDetails;
}
