import { Menu } from './menu';
import { Order } from './order';
import { OrderDetailOptions } from './order_detail_options';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class OrderDetails {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: Number })
  quantity: number;

  @ApiProperty({ type: Number })
  basePrice: number;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiPropertyOptional({ type: Date })
  updatedAt?: Date;

  @ApiProperty({ type: String })
  orderId: string;

  @ApiProperty({ type: String })
  menuId: string;

  @ApiProperty({ type: () => Menu })
  menu: Menu;

  @ApiProperty({ type: () => Order })
  order: Order;

  @ApiProperty({ isArray: true, type: () => OrderDetailOptions })
  orderDetailOptions: OrderDetailOptions[];
}
