import { Merchant } from './merchant';
import { User } from './user';
import { Order } from './order';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class Rating {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: Number })
  rating: number;

  @ApiProperty({ type: String })
  review: string;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiPropertyOptional({ type: Date })
  updatedAt?: Date;

  @ApiProperty({ type: String })
  merchantId: string;

  @ApiProperty({ type: String })
  reviewerId: string;

  @ApiPropertyOptional({ type: String })
  orderId?: string;

  @ApiPropertyOptional({ type: () => Merchant })
  merchant?: Merchant;

  @ApiPropertyOptional({ type: () => User })
  user?: User;

  @ApiPropertyOptional({ type: () => Order })
  order?: Order;
}
