import { Order } from './order';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class Transaction {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: Number })
  totalAmount: number;

  @ApiProperty({ type: Date })
  paymentTime: Date;

  @ApiProperty({ type: String })
  paymentMethod: string;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiPropertyOptional({ type: Date })
  updatedAt?: Date;

  @ApiProperty({ type: String })
  orderId: string;

  @ApiPropertyOptional({ type: () => Order })
  order?: Order;
}
