import { Address } from './address';
import { Merchant } from './merchant';
import { Role } from './role';
import { UserVehicle } from './user_vehicle';
import { Rating } from './rating';
import { Order } from './order';
import { Credit } from './credit';
import { Voucher } from './voucher';
import { Tier } from './tier';
import { LoyaltyPoint } from './loyalty_point';
import { UserRedemptionHistory } from './user_redemption_history';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class User {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: String })
  email: string;

  @ApiProperty({ type: String })
  name: string;

  @ApiProperty({ type: String })
  roleId: string;

  @ApiProperty({ type: String })
  phoneNumber: string;

  @ApiProperty({ type: Date })
  dateOfBirth: Date;

  @ApiPropertyOptional({ type: String })
  addressId?: string;

  @ApiPropertyOptional({ type: String })
  profilePic?: string;

  @ApiProperty({ type: Boolean })
  active: boolean = true;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiProperty({ type: Date })
  updatedAt: Date;

  @ApiPropertyOptional({ type: () => Address })
  address?: Address;

  @ApiPropertyOptional({ type: () => Merchant })
  merchant?: Merchant;

  @ApiProperty({ type: () => Role })
  role: Role;

  @ApiPropertyOptional({ type: String })
  membershipTierId?: string;

  @ApiProperty({ isArray: true, type: () => UserVehicle })
  userVehicle: UserVehicle[];

  @ApiProperty({ isArray: true, type: () => Rating })
  reviews: Rating[];

  @ApiProperty({ isArray: true, type: () => Order })
  Order: Order[];

  @ApiPropertyOptional({ type: () => Credit })
  credit?: Credit;

  @ApiPropertyOptional({ type: String })
  creditId?: string;

  @ApiProperty({ isArray: true, type: () => Voucher })
  Voucher: Voucher[];

  @ApiPropertyOptional({ type: () => Tier })
  membershipTier?: Tier;

  @ApiPropertyOptional({ type: () => LoyaltyPoint })
  loyaltyPoint?: LoyaltyPoint;

  @ApiPropertyOptional({ type: String })
  loyaltyPointId?: string;

  @ApiProperty({ isArray: true, type: () => UserRedemptionHistory })
  UserRedemptionHistory: UserRedemptionHistory[];
}
