import { User } from './user';
import { MerchandiseProduct } from './merchandise_product';
import { Merchant } from './merchant';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class UserRedemptionHistory {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: String })
  userId: string;

  @ApiProperty({ type: String })
  productId: string;

  @ApiPropertyOptional({ type: String })
  merchantId?: string;

  @ApiPropertyOptional({ type: Number })
  pointsRedeemed?: number;

  @ApiPropertyOptional({ type: Number })
  creditRedeemed?: number;

  @ApiProperty({ type: Boolean })
  collected: boolean;

  @ApiPropertyOptional({ type: String })
  deliveryAddress?: string;

  @ApiProperty({ type: String })
  deliveryMethod: string;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiProperty({ type: Date })
  updatedAt: Date;

  @ApiPropertyOptional({ type: String })
  courierType?: string;

  @ApiPropertyOptional({ type: String })
  shippingNo?: string;

  @ApiPropertyOptional({ type: String })
  remarks?: string;

  @ApiProperty({ type: () => User })
  user: User;

  @ApiProperty({ type: () => MerchandiseProduct })
  product: MerchandiseProduct;

  @ApiPropertyOptional({ type: () => Merchant })
  merchant?: Merchant;
}
