import { User } from './user';
import { Order } from './order';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class UserVehicle {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: String })
  plate: string;

  @ApiProperty({ type: String })
  userId: string;

  @ApiProperty({ type: () => User })
  user: User;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiPropertyOptional({ type: Date })
  updatedAt?: Date;

  @ApiProperty({ isArray: true, type: () => Order })
  Order: Order[];
}
