import { User } from './user';
import { Tag } from './tag';
import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class Voucher {
  @ApiProperty({ type: String })
  id: string;

  @ApiProperty({ type: String })
  name: string;

  @ApiProperty({ type: String })
  code: string;

  @ApiPropertyOptional({ type: Number })
  amount?: number;

  @ApiPropertyOptional({ type: Number })
  percentage?: number;

  @ApiProperty({ type: Date })
  validFrom: Date;

  @ApiProperty({ type: Date })
  validTo: Date;

  @ApiProperty({ type: Boolean })
  isUsed: boolean;

  @ApiPropertyOptional({ type: Number })
  minPurchaseQuantity?: number;

  @ApiPropertyOptional({ type: String })
  userId?: string;

  @ApiPropertyOptional({ type: () => User })
  user?: User;

  @ApiProperty({ type: Boolean })
  isAllowed: boolean;

  @ApiPropertyOptional({ type: String })
  tagId?: string;

  @ApiPropertyOptional({ type: () => Tag })
  tag?: Tag;

  @ApiProperty({ type: Date })
  createdAt: Date;

  @ApiPropertyOptional({ type: Date })
  updatedAt?: Date;
}
