import { NestjsFormDataModule } from 'nestjs-form-data';

import { Module } from '@nestjs/common';

import { AppController } from './app.controller';
import { AppService } from './app.service';
import { AuthModule } from './auth/auth.module';
import { CreditHistoryModule } from './credit-history/credit-history.module';
import { CreditModule } from './credit/credit.module';
import { MenuModule } from './menu/menu.module';
import { MerchantModule } from './merchant/merchant.module';
import { OrderDetailsModule } from './order-details/order-details.module';
import { OrderModule } from './order/order.module';
import { PaymentModule } from './payment/payment.module';
import { TransactionModule } from './transaction/transaction.module';
import { UserModule } from './user/user.module';
import { MembershipModule } from './membership/membership.module';
``

@Module({
  imports: [NestjsFormDataModule, MerchantModule, MenuModule, OrderModule, OrderDetailsModule, TransactionModule, UserModule, AuthModule, CreditModule, CreditHistoryModule, PaymentModule, MembershipModule],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule {}
